/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.LicenseStatus;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.TradeLicenseUpdateIndexService;
import org.egov.tl.service.ValidityService;
import org.elasticsearch.common.joda.time.DateTime;
import org.hibernate.CacheMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class AbstractLicenseService<T extends License> {
    @Autowired
    @Qualifier(value="entityQueryService")
    protected PersistenceService persistenceService;
    @Autowired
    protected InstallmentHibDao installmentDao;
    @Autowired
    protected SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    protected ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    protected FeeMatrixService feeMatrixService;
    @Autowired
    @Qualifier(value="licenseDocumentTypeService")
    protected PersistenceService<LicenseDocumentType, Long> licenseDocumentTypeService;
    @Autowired
    private TradeLicenseUpdateIndexService updateIndexService;
    @Autowired
    protected SecurityUtils securityUtils;
    @Autowired
    protected DemandGenericHibDao demandGenericDao;
    @Autowired
    protected ValidityService validityService;
    protected SimpleWorkflowService<T> licenseWorkflowService;
    protected PersistenceService<T, Long> licensePersitenceService;

    public AbstractLicenseService(PersistenceService<T, Long> licensePersitenceService) {
        this.licensePersitenceService = licensePersitenceService;
    }

    protected abstract LicenseAppType getLicenseApplicationTypeForRenew();

    protected abstract LicenseAppType getLicenseApplicationType();

    protected abstract Module getModuleName();

    protected abstract NatureOfBusiness getNatureOfBusiness();

    protected abstract void sendEmailAndSMS(T var1, String var2);

    public PersistenceService<T, Long> licensePersitenceService() {
        return this.licensePersitenceService;
    }

    public void setLicenseWorkflowService(SimpleWorkflowService<T> licenseWorkflowService) {
        this.licenseWorkflowService = licenseWorkflowService;
    }

    public T getLicenseById(Long id) {
        return (T)((Object)((License)((Object)this.licensePersitenceService.findById((Serializable)id, false))));
    }

    @Transactional
    public void create(T license, WorkflowBean workflowBean) {
        ((License)((Object)license)).setLicenseAppType((LicenseAppType)((Object)this.persistenceService.find("from  LicenseAppType where name='New' ")));
        this.raiseNewDemand(license);
        ((License)((Object)license)).getLicensee().setLicense((License)((Object)license));
        ((License)((Object)license)).setStatus((LicenseStatus)this.persistenceService.find("from org.egov.tl.entity.LicenseStatus where name=? ", new Object[]{"Acknowledged"}));
        EgwStatus statusChange = (EgwStatus)this.persistenceService.find("from org.egov.commons.EgwStatus where moduletype=? and code=?", new Object[]{"TRADELICENSE", "CREATED"});
        ((License)((Object)license)).setEgwStatus(statusChange);
        ((License)((Object)license)).setApplicationNumber(this.applicationNumberGenerator.generate());
        this.licensePersitenceService.applyAuditing(license);
        this.processAndStoreDocument(((License)((Object)license)).getDocuments());
        this.transitionWorkFlow(license, workflowBean);
        license.getState().setCreatedBy(license.getCreatedBy());
        license.getState().setCreatedDate(new Date());
        license.getState().setLastModifiedBy(license.getCreatedBy());
        license.getState().setLastModifiedDate(new Date());
        this.licensePersitenceService.persist(license);
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        this.updateIndexService.updateTradeLicenseIndexes((License)((Object)license));
    }

    private BigDecimal raiseNewDemand(T license) {
        LicenseDemand ld = new LicenseDemand();
        Module moduleName = this.getModuleName();
        BigDecimal totalAmount = BigDecimal.ZERO;
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(moduleName, ((License)((Object)license)).getApplicationDate());
        ld.setIsHistory("N");
        ld.setEgInstallmentMaster(installment);
        ld.setLicense((License)((Object)license));
        ld.setIsLateRenewal('0');
        ld.setCreateDate(new Date());
        List<FeeMatrixDetail> feeMatrixDetails = this.feeMatrixService.findFeeList(license);
        for (FeeMatrixDetail fm : feeMatrixDetails) {
            EgDemandReasonMaster reasonMaster = this.demandGenericDao.getDemandReasonMasterByCode(fm.getFeeMatrix().getFeeType().getName(), moduleName);
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(reasonMaster, installment, moduleName);
            if (fm.getFeeMatrix().getFeeType().getName().contains("Late") || reason == null) continue;
            ld.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)fm.getAmount(), (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            totalAmount = totalAmount.add(fm.getAmount());
        }
        ld.setBaseDemand(totalAmount);
        ((License)((Object)license)).setLicenseDemand(ld);
        return totalAmount;
    }

    public License updateDemandForChangeTradeArea(T license) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getLicenseDemand();
        Module moduleName = this.getModuleName();
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(moduleName, ((License)((Object)license)).getApplicationDate());
        Set demandDetails = licenseDemand.getEgDemandDetails();
        List<FeeMatrixDetail> feeList = this.feeMatrixService.findFeeList(license);
        for (EgDemandDetails dmd : demandDetails) {
            for (FeeMatrixDetail fm : feeList) {
                if (!installment.getId().equals(dmd.getEgDemandReason().getEgInstallmentMaster().getId()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                dmd.setAmount(fm.getAmount());
                dmd.setModifiedDate(new Date());
            }
        }
        this.recalculateBaseDemand(licenseDemand);
        return license;
    }

    @Transactional
    public BigDecimal recalculateDemand(List<FeeMatrixDetail> feeList, T license) {
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new Date());
        BigDecimal totalAmount = BigDecimal.ZERO;
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails dmd : licenseDemand.getEgDemandDetails()) {
            for (FeeMatrixDetail fm : feeList) {
                if (!installment.getId().equals(dmd.getEgDemandReason().getEgInstallmentMaster().getId()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                dmd.setAmount(fm.getAmount());
                dmd.setAmtCollected(BigDecimal.ZERO);
                totalAmount = totalAmount.add(fm.getAmount());
            }
        }
        this.recalculateBaseDemand(licenseDemand);
        return totalAmount;
    }

    @Transactional
    public void createLegacyLicense(T license, Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus) {
        if (!this.licensePersitenceService.findAllBy("from License where oldLicenseNumber = ?", new Object[]{((License)((Object)license)).getOldLicenseNumber()}).isEmpty()) {
            throw new ValidationException("TL-001", "TL-001", new String[]{((License)((Object)license)).getOldLicenseNumber()});
        }
        this.addLegacyDemand(legacyInstallmentwiseFees, legacyFeePayStatus, license);
        this.processAndStoreDocument(((License)((Object)license)).getDocuments());
        ((License)((Object)license)).setLicenseAppType((LicenseAppType)((Object)this.persistenceService.find("from  LicenseAppType where name='New' ")));
        ((License)((Object)license)).getLicensee().setLicense((License)((Object)license));
        ((License)((Object)license)).setStatus((LicenseStatus)this.persistenceService.find("from org.egov.tl.entity.LicenseStatus where name=? ", new Object[]{"Active"}));
        ((License)((Object)license)).setApplicationNumber(this.applicationNumberGenerator.generate());
        ((License)((Object)license)).setLegacy(true);
        ((License)((Object)license)).setActive(true);
        this.licensePersitenceService.applyAuditing(license);
        ((License)((Object)license)).generateLicenseNumber(this.getNextRunningLicenseNumber("egtl_license_number"));
        this.validityService.applyLicenseValidity((License)((Object)license));
        this.licensePersitenceService.persist(license);
    }

    private void addLegacyDemand(Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus, T license) {
        LicenseDemand licenseDemand = new LicenseDemand();
        licenseDemand.setIsHistory("N");
        licenseDemand.setCreateDate(new Date());
        licenseDemand.setLicense((License)((Object)license));
        licenseDemand.setIsLateRenewal('0');
        Module module = this.getModuleName();
        for (Map.Entry<Integer, Integer> legacyInstallmentwiseFee : legacyInstallmentwiseFees.entrySet()) {
            if (legacyInstallmentwiseFee.getValue() == null || legacyInstallmentwiseFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, legacyInstallmentwiseFee.getKey());
            licenseDemand.setEgInstallmentMaster(installment);
            BigDecimal demandAmount = BigDecimal.valueOf(legacyInstallmentwiseFee.getValue().intValue());
            BigDecimal amtCollected = legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == null || legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
            licenseDemand.setBaseDemand(demandAmount.add(licenseDemand.getBaseDemand()));
            licenseDemand.setAmtCollected(amtCollected.add(licenseDemand.getAmtCollected()));
        }
        ((License)((Object)license)).setLicenseDemand(licenseDemand);
    }

    @Transactional
    public void updateLegacyLicense(T license, Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus) {
        this.updateLegacyDemand(license, updatedInstallmentFees, legacyFeePayStatus);
        this.licensePersitenceService.applyAuditing(license);
        this.processAndStoreDocument(((License)((Object)license)).getDocuments());
        this.licensePersitenceService.persist(license);
    }

    private void updateLegacyDemand(T license, Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        Iterator demandDetails = licenseDemand.getEgDemandDetails().iterator();
        while (demandDetails.hasNext()) {
            EgDemandDetails demandDetail = (EgDemandDetails)demandDetails.next();
            Integer installmentNumber = demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber();
            Integer updatedFee = updatedInstallmentFees.get(installmentNumber);
            Boolean feePaymentStatus = legacyFeePayStatus.get(installmentNumber);
            if (updatedFee != null) {
                BigDecimal updatedDemandAmt = BigDecimal.valueOf(updatedFee.intValue());
                demandDetail.setAmount(updatedDemandAmt);
                if (feePaymentStatus != null && feePaymentStatus.booleanValue()) {
                    demandDetail.setAmtCollected(updatedDemandAmt);
                } else {
                    demandDetail.setAmtCollected(BigDecimal.ZERO);
                }
            } else {
                demandDetails.remove();
            }
            updatedInstallmentFees.put(installmentNumber, 0);
        }
        Module module = this.getModuleName();
        for (Map.Entry<Integer, Integer> updatedInstallmentFee : updatedInstallmentFees.entrySet()) {
            if (updatedInstallmentFee.getValue() == null || updatedInstallmentFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, updatedInstallmentFee.getKey());
            BigDecimal demandAmount = BigDecimal.valueOf(updatedInstallmentFee.getValue().intValue());
            BigDecimal amtCollected = legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == null || legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
        }
        this.recalculateBaseDemand(licenseDemand);
    }

    public void recalculateBaseDemand(LicenseDemand licenseDemand) {
        licenseDemand.setAmtCollected(BigDecimal.ZERO);
        licenseDemand.setBaseDemand(BigDecimal.ZERO);
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            licenseDemand.setAmtCollected(licenseDemand.getAmtCollected().add(demandDetail.getAmtCollected()));
            licenseDemand.setBaseDemand(licenseDemand.getBaseDemand().add(demandDetail.getAmount()));
        }
    }

    public Serializable getNextRunningLicenseNumber(String sequenceName) {
        return this.sequenceNumberGenerator.getNextSequence(sequenceName);
    }

    @Transactional
    public void renew(T license, WorkflowBean workflowBean) {
        ((License)((Object)license)).setApplicationNumber(this.applicationNumberGenerator.generate());
        this.recalculateDemand(this.feeMatrixService.findFeeList(license), license);
        LicenseStatus status = (LicenseStatus)this.persistenceService.find("from org.egov.tl.entity.LicenseStatus where name=? ", new Object[]{"Acknowledged"});
        ((License)((Object)license)).setStatus(status);
        EgwStatus statusChange = (EgwStatus)this.persistenceService.find("from org.egov.commons.EgwStatus where moduletype=? and code=?", new Object[]{"TRADELICENSE", "CREATED"});
        ((License)((Object)license)).setEgwStatus(statusChange);
        Position pos = null;
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationTypeForRenew());
        User currentUser = this.securityUtils.getCurrentUser();
        if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
            pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
        }
        WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
        license.reinitiateTransition().start().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
        this.licensePersitenceService.applyAuditing(license);
        this.licensePersitenceService.persist(license);
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        this.updateIndexService.updateTradeLicenseIndexes((License)((Object)license));
    }

    @Transactional
    public void transitionWorkFlow(T license, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        if (null != ((License)((Object)license)).getId()) {
            wfInitiator = this.getWorkflowInitiator(license);
        }
        if ("Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                license.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
                if (((License)((Object)license)).getLicenseAppType() != null && ((License)((Object)license)).getLicenseAppType().getName().equals("Renew")) {
                    ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationType());
                }
            } else {
                String stateValue = license.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Sanitary inspector Approve pending");
            }
        } else if ("Generate Certificate".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            license.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else {
            WorkFlowMatrix wfmatrix;
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{workflowBean.getApproverPositionId()});
            }
            if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
                Assignment commissionerUsr = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
                pos = (Position)this.persistenceService.find("from Position where id=?", new Object[]{commissionerUsr.getPosition().getId()});
            }
            if (null == license.getState()) {
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
                license.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if (license.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                license.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
    }

    protected Assignment getWorkflowInitiator(T license) {
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(license.getCreatedBy().getId());
        return wfInitiator;
    }

    @Transactional
    public void processAndStoreDocument(List<LicenseDocument> documents) {
        documents.forEach(document -> {
            if (!document.getUploads().isEmpty() && !document.getUploadsContentType().isEmpty()) {
                int fileCount = 0;
                for (File file : document.getUploads()) {
                    FileStoreMapper fileStore = this.fileStoreService.store(file, document.getUploadsFileName().get(fileCount), document.getUploadsContentType().get(fileCount++), "EGTL");
                    document.getFiles().add(fileStore);
                }
            }
            document.setType((LicenseDocumentType)((Object)((Object)this.licenseDocumentTypeService.load((Serializable)document.getType().getId(), LicenseDocumentType.class))));
            this.persistenceService.applyAuditing((AbstractAuditable)document);
        });
    }

    public List<LicenseDocumentType> getDocumentTypesByTransaction(String transaction) {
        return this.persistenceService.findAllBy("from LicenseDocumentType where applicationType = ?", new Object[]{transaction});
    }

    public List<NatureOfBusiness> getAllNatureOfBusinesses() {
        return this.persistenceService.findAllBy("from NatureOfBusiness order by name", new Object[0]);
    }

    public T getLicenseByLicenseNumber(String licenseNumber) {
        return (T)((Object)((License)((Object)this.licensePersitenceService.find("from License where licenseNumber=?", new Object[]{licenseNumber}))));
    }

    public T getLicenseByApplicationNumber(String applicationNumber) {
        return (T)((Object)((License)((Object)this.licensePersitenceService.find("from License where applicationNumber=?", new Object[]{applicationNumber}))));
    }

    public List<Installment> getLastFiveYearInstallmentsForLicense() {
        List installmentList = this.installmentDao.fetchInstallments(this.getModuleName(), new Date(), 6);
        Collections.reverse(installmentList);
        return installmentList;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee(T license) {
        HashMap<String, Map<String, BigDecimal>> outstandingFee = new HashMap<String, Map<String, BigDecimal>>();
        Installment currentInstallmentYear = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new Date());
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            String demandReason = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
            Installment installmentYear = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            Map<String, BigDecimal> feeByTypes = null;
            if (outstandingFee.containsKey(demandReason)) {
                feeByTypes = (Map)outstandingFee.get(demandReason);
            } else {
                feeByTypes = new HashMap();
                feeByTypes.put("arrear", BigDecimal.ZERO);
                feeByTypes.put("current", BigDecimal.ZERO);
            }
            BigDecimal demandAmount = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (installmentYear.equals((Object)currentInstallmentYear)) {
                feeByTypes.put("current", demandAmount);
            } else {
                feeByTypes.put("arrear", ((BigDecimal)feeByTypes.get("arrear")).add(demandAmount));
            }
            outstandingFee.put(demandReason, feeByTypes);
        }
        return outstandingFee;
    }

    public List<T> getAllLicensesByNatureOfBusiness(String natureOfBusiness) {
        return this.licensePersitenceService.getSession().createCriteria(License.class).createAlias("natureOfBusiness", "nb", JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.eq((String)"nb.name", (Object)natureOfBusiness)).setCacheMode(CacheMode.IGNORE).list();
    }
}

