/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.NatureOfBusiness;

@Entity
@Table(name="egtl_validity")
@SequenceGenerator(name="seq_egtl_validity", sequenceName="seq_egtl_validity", allocationSize=1)
@CompositeUnique(fields={"natureOfBusiness", "licenseCategory"}, enableDfltMsg=true, checkForNull=true, message="{license.validity.exist}")
public class Validity
extends AbstractAuditable {
    public static final String SEQ = "seq_egtl_validity";
    private static final long serialVersionUID = -6303436329433049423L;
    @Id
    @GeneratedValue(generator="seq_egtl_validity", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="natureOfBusiness", nullable=false)
    private NatureOfBusiness natureOfBusiness;
    @ManyToOne
    @JoinColumn(name="licenseCategory")
    private LicenseCategory licenseCategory;
    @Min(value=0L)
    @Max(value=6L)
    private Integer day = 0;
    @Min(value=0L)
    @Max(value=3L)
    private Integer week = 0;
    @Min(value=0L)
    @Max(value=11L)
    private Integer month = 0;
    @Min(value=0L)
    @Max(value=99L)
    private Integer year = 0;
    private boolean basedOnFinancialYear;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(NatureOfBusiness natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public LicenseCategory getLicenseCategory() {
        return this.licenseCategory;
    }

    public void setLicenseCategory(LicenseCategory licenseCategory) {
        this.licenseCategory = licenseCategory;
    }

    public Integer getDay() {
        return this.day;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getWeek() {
        return this.week;
    }

    public void setWeek(Integer week) {
        this.week = week;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public boolean isBasedOnFinancialYear() {
        return this.basedOnFinancialYear;
    }

    public void setBasedOnFinancialYear(boolean basedOnFinancialYear) {
        this.basedOnFinancialYear = basedOnFinancialYear;
    }

    public boolean hasValidValues() {
        return this.isBasedOnFinancialYear() || this.day != null && this.day != 0 || this.week != null && this.week != 0 || this.month != null && this.month != 0 || this.year != null && this.year != 0;
    }
}

