/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDocument;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;

@Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
public class TradeLicense
extends License {
    private List<LicenseDocument> documents = new ArrayList<LicenseDocument>();

    @Override
    public String generateLicenseNumber(Serializable runningNumber) {
        this.licenseNumber = String.format("TL/%05d/%s", runningNumber, DateUtils.currentDateToYearFormat());
        return this.licenseNumber;
    }

    public String getStateDetails() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        StringBuffer details = new StringBuffer();
        if (this.getLicenseNumber() != null && !this.getLicenseNumber().isEmpty()) {
            details.append("TradeLicense Number " + this.getLicenseNumber() + " and ");
        }
        details.append(String.format(" Application Number %s with application date %s.", this.applicationNumber, this.applicationDate != null ? formatter.format(this.applicationDate) : formatter.format(new Date())));
        return details.toString();
    }

    @Override
    @NotAudited
    public List<LicenseDocument> getDocuments() {
        return this.documents;
    }

    @Override
    public void setDocuments(List<LicenseDocument> documents) {
        this.documents = documents;
    }
}

