/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.math.BigDecimal;
import java.util.List;
import org.egov.demand.model.EgBill;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.service.notice.RecoveryNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/valuation"})
public class ValuationCertificateController {
    private static final String VALUATION_HAS_PT_DUE = "assessment.has.pt.due";
    @Autowired
    private RecoveryNoticeService recoveryNoticeService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    private static final String VALUATIONCERTIFICATE_FORM = "valuationcertificate-form";

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("egBill", (Object)new EgBill());
        return VALUATIONCERTIFICATE_FORM;
    }

    @RequestMapping(value={"/searchform"}, method={RequestMethod.POST})
    public String valuationNotice(@ModelAttribute(value="egBill") EgBill egBill, Model model, BindingResult errors) {
        List errorList = this.recoveryNoticeService.validateRecoveryNotices(egBill.getConsumerId(), "Valuation Certificate");
        for (String error : errorList) {
            if (VALUATION_HAS_PT_DUE.equals(error)) {
                BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(egBill.getConsumerId());
                BigDecimal totalDue = this.recoveryNoticeService.getTotalPropertyTaxDue(basicProperty);
                errors.reject(error, (Object[])new String[]{String.valueOf(totalDue)}, error);
                continue;
            }
            errors.reject(error, error);
        }
        if (errors.hasErrors()) {
            model.addAttribute("valuationnotice", (Object)new EgBill());
            return VALUATIONCERTIFICATE_FORM;
        }
        return "redirect:/valuation/generatenotice/" + egBill.getConsumerId();
    }

    @RequestMapping(value={"/generatenotice/{assessmentNo}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateNotice(Model model, @PathVariable String assessmentNo) {
        return this.recoveryNoticeService.generateNotice(assessmentNo, "Valuation Certificate");
    }
}

