/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.List;
import org.egov.demand.model.EgBill;
import org.egov.ptis.domain.service.notice.RecoveryNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/esdnotice"})
public class ESDNoticeController {
    private static final String ESDNOTICE_FORM = "esdnotice-form";
    @Autowired
    private RecoveryNoticeService recoveryNoticeService;

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("egBill", (Object)new EgBill());
        return ESDNOTICE_FORM;
    }

    @RequestMapping(value={"/searchform"}, method={RequestMethod.POST})
    public String searchProperty(@ModelAttribute(value="egBill") EgBill egBill, Model model, BindingResult errors) {
        List errorList = this.recoveryNoticeService.validateRecoveryNotices(egBill.getConsumerId(), "ESD Notice");
        for (String error : errorList) {
            if (error == "common.no.property.due") {
                errors.reject(error, (Object[])new String[]{"ESD Notice"}, error);
                continue;
            }
            errors.reject(error, error);
        }
        if (errors.hasErrors()) {
            model.addAttribute("esdNotice", (Object)new EgBill());
            return ESDNOTICE_FORM;
        }
        return "redirect:/esdnotice/generatenotice/" + egBill.getConsumerId();
    }

    @RequestMapping(value={"/generatenotice/{assessmentNo}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateNotice(Model model, @PathVariable String assessmentNo) {
        return this.recoveryNoticeService.generateNotice(assessmentNo, "ESD Notice");
    }
}

