/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.Date;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.transactions.AssessmentTransactions;
import org.egov.ptis.domain.service.report.DemandRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class DemandRegisterController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    public PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private DemandRegisterService transactionsService;

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="financialYears")
    public List<CFinancialYear> getFinancialYears() {
        return this.financialYearDAO.getAllPriorFinancialYears(new Date());
    }

    @RequestMapping(value={"/arrdmdrgstr-vlt/form"}, method={RequestMethod.GET})
    public String searchVLTArrearDemandRegisterForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("mode", (Object)"VLT");
        model.addAttribute("ADRReport", (Object)new AssessmentTransactions());
        return "arrdmdrgstr-vlt-form";
    }

    @RequestMapping(value={"/arrdmdrgstr-pt/form"}, method={RequestMethod.GET})
    public String searchPTArrearDemandRegisterForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("mode", (Object)"PT");
        model.addAttribute("ADRReport", (Object)new AssessmentTransactions());
        return "arrdmdrgstr-pt-form";
    }

    @ResponseBody
    @RequestMapping(value={"/arrdmdrgstr/result"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> generateNotice(Model model, @RequestParam Long wardId, @RequestParam Long financialYearId, @RequestParam String mode) {
        CFinancialYear financialYear = this.financialYearDAO.getFinancialYearById(financialYearId);
        ReportOutput reportOutput = this.transactionsService.generateDemandRegisterReport("ADR Report", wardId, financialYear, mode);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=ArrearDemandRegister_" + financialYear.getFinYearRange() + ".pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

