/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.objection;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.model.PropertyBillInfo;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.springframework.beans.factory.annotation.Autowired;

public class MemoGenerationAction
extends BaseFormAction {
    private final Logger LOGGER = Logger.getLogger(MemoGenerationAction.class);
    private RevisionPetition objection = new RevisionPetition();
    private static final String OBJECTIONMEMO = "ObjectionMemo";
    private static final String PROPERTYSATUSFORMEMO = "getPropertySatusForMemo";
    private PersistenceService<RevisionPetition, Long> objectionService;
    protected ReportService reportService;
    private Map<String, Map<String, BigDecimal>> reasonwiseDues;
    private String reportId;
    public static final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        if (null != this.objection.getId()) {
            this.objection = (RevisionPetition)this.objectionService.findById((Serializable)this.objection.getId(), false);
        }
    }

    public PersistenceService<RevisionPetition, Long> getObjectionService() {
        return this.objectionService;
    }

    public void setObjectionService(PersistenceService<RevisionPetition, Long> objectionService) {
        this.objectionService = objectionService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @SkipValidation
    public String print() {
        this.LOGGER.debug((Object)"Memo Print Started...");
        PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
        if (this.objection.getBasicProperty().getProperty().getPropertyDetail().getPropertyMutationMaster().getCode().equalsIgnoreCase("OBJ")) {
            List obj = this.persistenceService.findAllByNamedQuery(PROPERTYSATUSFORMEMO, new Object[]{this.objection.getBasicProperty().getUpicNo(), "MODIFY", this.objection.getDateOfOutcome()});
            if (obj != null && !obj.isEmpty()) {
                this.reasonwiseDues = propertyTaxUtil.getDemandDues(this.objection.getBasicProperty().getUpicNo());
                PropertyBillInfo propertyBillInfo = new PropertyBillInfo(this.reasonwiseDues, this.objection.getBasicProperty(), null);
                ReportRequest reportRequest = new ReportRequest(OBJECTIONMEMO, (Object)propertyBillInfo, this.getParamMap());
                reportRequest.setPrintDialogOnOpenReport(true);
                ReportOutput reportOutput = this.reportService.createReport(reportRequest);
                this.reportId = this.addingReportToSession(reportOutput);
            }
        } else {
            this.addActionMessage("Can not generate Memo since Bill Not Generated");
        }
        this.LOGGER.debug((Object)"Memo Print Ended...");
        return "print";
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("date", dateFormat.format(new Date()));
        paramMap.put("objectionNo", this.objection.getObjectionNumber());
        paramMap.put("dateOfOutcome", dateFormat.format(this.objection.getDateOfOutcome()));
        paramMap.put("objectionDate", dateFormat.format(this.objection.getRecievedOn()));
        Boundary zone = this.objection.getBasicProperty().getBoundary().getParent();
        paramMap.put("zoneNo", zone != null ? zone.getBoundaryNum().toString() : "");
        paramMap.put("owner", this.objection.getBasicProperty().getFullOwnerName());
        paramMap.put("memoNo", this.propertyTaxNumberGenerator.generateMemoNumber());
        return paramMap;
    }

    protected String addingReportToSession(ReportOutput reportOutput) {
        return this.reportViewerUtil.addReportToTempCache(reportOutput);
    }

    public RevisionPetition getObjection() {
        return this.objection;
    }

    public void setObjection(RevisionPetition objection) {
        this.objection = objection;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }
}

