/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.repository.master.woodtype.WoodTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WoodTypeService {
    private final WoodTypeRepository woodTypeRepository;
    @Autowired
    private UserService userService;

    @Autowired
    public WoodTypeService(WoodTypeRepository woodTypeRepository) {
        this.woodTypeRepository = woodTypeRepository;
    }

    @Transactional
    public void createWood(WoodType woodtype) {
        this.woodTypeRepository.save((Object)woodtype);
    }

    public WoodType getWoodTypeById(Long id) {
        return (WoodType)((Object)this.woodTypeRepository.findOne(id));
    }

    public WoodType getWoodTypeByName(String name) {
        return this.woodTypeRepository.findByName(name);
    }

    public List<WoodType> getAllWoodTypes() {
        return this.woodTypeRepository.findAll();
    }

    public String getRolesForUserId(Long userId) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }
}

