/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.entity.property.VacancyRemissionDetails;
import org.egov.ptis.domain.repository.vacancyremission.VacancyRemissionApprovalRepository;
import org.egov.ptis.domain.repository.vacancyremission.VacancyRemissionRepository;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
@Transactional(readOnly=true)
public class VacancyRemissionService {
    private static final Logger LOG = LoggerFactory.getLogger(VacancyRemissionService.class);
    @Autowired
    private VacancyRemissionRepository vacancyRemissionRepository;
    @Autowired
    private VacancyRemissionApprovalRepository vacancyRemissionApprovalRepository;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<VacancyRemission> vacancyRemissionWorkflowService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource ptisMessageSource;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    public VacancyRemission getApprovedVacancyRemissionForProperty(String upicNo) {
        return this.vacancyRemissionRepository.findByUpicNo(upicNo);
    }

    public VacancyRemission getLatestRejectAckGeneratedVacancyRemissionForProperty(String upicNo) {
        VacancyRemission vacancyRemission = null;
        List<VacancyRemission> rejectedRemissionList = this.vacancyRemissionRepository.findAllRejectionAckGeneratedForUpicNo(upicNo);
        if (!rejectedRemissionList.isEmpty()) {
            vacancyRemission = rejectedRemissionList.get(0);
        }
        return vacancyRemission;
    }

    public VacancyRemission getVacancyRemissionById(Long id) {
        return (VacancyRemission)((Object)this.vacancyRemissionRepository.findOne(id));
    }

    public List<VacancyRemission> getAllVacancyRemissionByUpicNo(String upicNo) {
        return this.vacancyRemissionRepository.getAllVacancyRemissionByUpicNo(upicNo);
    }

    public VacancyRemission getRejectedVacancyRemissionForProperty(String upicNo) {
        return this.vacancyRemissionRepository.findRejectedByUpicNo(upicNo);
    }

    @Transactional
    public VacancyRemission saveVacancyRemission(VacancyRemission vacancyRemission, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, Boolean propertyByEmployee) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String currentState = "";
        if (!propertyByEmployee.booleanValue()) {
            currentState = "Created";
            Assignment assignment = this.propertyService.getUserPositionByZone(vacancyRemission.getBasicProperty(), false);
            if (null != assignment) {
                approvalPosition = assignment.getPosition().getId();
            }
        } else {
            currentState = null;
        }
        wfInitiator = vacancyRemission.getId() != null && (workFlowAction.equalsIgnoreCase("Reject") || workFlowAction.equalsIgnoreCase("Generate Notice")) ? this.getWorkflowInitiator(vacancyRemission) : this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        if (StringUtils.isBlank((CharSequence)vacancyRemission.getApplicationNumber())) {
            vacancyRemission.setApplicationNumber(this.applicationNumberGenerator.generate());
        }
        if (workFlowAction.equalsIgnoreCase("Generate Notice")) {
            if (wfInitiator.getPosition().equals((Object)vacancyRemission.getState().getOwnerPosition())) {
                vacancyRemission.setStatus("Rejection Acknowledgement Generated");
                vacancyRemission.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate());
                vacancyRemission.getBasicProperty().setUnderWorkflow(false);
            }
        } else if (workFlowAction.equalsIgnoreCase("Reject")) {
            String stateValue = "Rejected";
            vacancyRemission.setStatus("REJECTED");
            vacancyRemission.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Application Rejected");
            this.buildSMS(vacancyRemission, workFlowAction);
        } else {
            if (workFlowAction.equalsIgnoreCase("Forward")) {
                vacancyRemission.setStatus("IN_WORKFLOW");
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                vacancyRemission.setStatus("APPROVED");
            }
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == vacancyRemission.getState()) {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemission.getStateType(), null, null, additionalRule, currentState, null);
                vacancyRemission.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Vacany Remission").withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
                vacancyRemission.getBasicProperty().setUnderWorkflow(true);
            } else {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemission.getStateType(), null, null, additionalRule, vacancyRemission.getCurrentState().getValue(), null);
                if (wfmatrix != null) {
                    if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                        vacancyRemission.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate());
                        vacancyRemission.getBasicProperty().setUnderWorkflow(false);
                    } else {
                        vacancyRemission.transition(false).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
                    }
                }
                if (workFlowAction.equalsIgnoreCase("Approve")) {
                    this.buildSMS(vacancyRemission, workFlowAction);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
        return (VacancyRemission)((Object)this.vacancyRemissionRepository.save((Object)vacancyRemission));
    }

    private void updateDemandDetailsWithRebate(VacancyRemission vacancyRemission, Installment demandInstallment, Installment effectiveInstallment) {
        Set<Ptdemand> activePropPtDemandSet = vacancyRemission.getBasicProperty().getActiveProperty().getPtDemandSet();
        Ptdemand currPtDemand = null;
        for (Ptdemand ptDemand : activePropPtDemandSet) {
            if (!ptDemand.getIsHistory().equalsIgnoreCase("N") || !ptDemand.getEgInstallmentMaster().equals((Object)demandInstallment)) continue;
            currPtDemand = ptDemand;
            break;
        }
        for (EgDemandDetails dmdDet : currPtDemand.getEgDemandDetails()) {
            if (!dmdDet.getInstallmentStartDate().equals(effectiveInstallment.getFromDate())) continue;
            dmdDet.setAmount(dmdDet.getAmount().divide(new BigDecimal("2")).setScale(0, 4));
        }
        this.ptDemandDAO.update(currPtDemand);
    }

    public void addModelAttributes(Model model, BasicProperty basicProperty) {
        PropertyImpl property = basicProperty.getActiveProperty();
        model.addAttribute("property", (Object)property);
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (ptDemand != null && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            model.addAttribute("ARV", (Object)ptDemand.getDmdCalculations().getAlv());
        } else {
            model.addAttribute("ARV", (Object)BigDecimal.ZERO);
        }
        if (!basicProperty.getActiveProperty().getIsExemptedFromTax().booleanValue()) {
            try {
                Map<String, Map<String, BigDecimal>> demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.propertyTaxCommonUtils.getCurrentInstallment());
                Map<String, BigDecimal> currentTaxDetails = this.propertyService.getCurrentTaxDetails(demandCollMap, new Date());
                model.addAttribute("propertyTax", (Object)currentTaxDetails.get("General Tax"));
                model.addAttribute("eduCess", (Object)(currentTaxDetails.get("Education Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Education Cess")));
                model.addAttribute("libraryCess", (Object)(currentTaxDetails.get("Library Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Library Cess")));
                model.addAttribute("currTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("currTaxDue", (Object)currentTaxDetails.get("CURR_BAL"));
                model.addAttribute("totalTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("totalArrDue", (Object)currentTaxDetails.get("ARR_BAL"));
            }
            catch (Exception e) {
                LOG.error("Exception in addModelAttributes : ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception in addModelAttributes : " + e);
            }
            Boolean propertyByEmployee = Boolean.TRUE;
            propertyByEmployee = this.checkIfEmployee(this.getLoggedInUser());
            model.addAttribute("propertyByEmployee", (Object)propertyByEmployee);
        }
    }

    public Boolean checkIfEmployee(User user) {
        return this.propertyService.isEmployee(user);
    }

    public String getInitiatorName(VacancyRemission vacancyRemission) {
        String initiatorName = "";
        Assignment assignment = new Assignment();
        assignment = this.checkIfEmployee(vacancyRemission.getCreatedBy()) != false ? this.assignmentService.getPrimaryAssignmentForUser(vacancyRemission.getCreatedBy().getId()) : this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)vacancyRemission.getStateHistory().get(0)).getOwnerPosition().getId());
        initiatorName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
        return initiatorName;
    }

    protected Assignment getWorkflowInitiator(VacancyRemission vacancyRemission) {
        Assignment wfInitiator = null;
        wfInitiator = this.checkIfEmployee(vacancyRemission.getCreatedBy()).booleanValue() ? (vacancyRemission.getState() != null && vacancyRemission.getState().getInitiatorPosition() != null ? this.propertyTaxCommonUtils.getUserAssignmentByPassingPositionAndUser(vacancyRemission.getCreatedBy(), vacancyRemission.getState().getInitiatorPosition()) : this.assignmentService.getPrimaryAssignmentForUser(vacancyRemission.getCreatedBy().getId())) : (!vacancyRemission.getStateHistory().isEmpty() ? this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)vacancyRemission.getStateHistory().get(0)).getOwnerPosition().getId()) : this.assignmentService.getPrimaryAssignmentForPositon(vacancyRemission.getState().getOwnerPosition().getId()));
        return wfInitiator;
    }

    @Transactional
    public void saveRemissionDetails(VacancyRemission vacancyRemission) {
        this.vacancyRemissionRepository.save((Object)vacancyRemission);
    }

    public List<VacancyRemissionDetails> getMonthlyDetailsHistory(VacancyRemission vacancyRemission) {
        List<VacancyRemissionDetails> historyList = new ArrayList<VacancyRemissionDetails>();
        if (!vacancyRemission.getVacancyRemissionDetails().isEmpty()) {
            historyList = vacancyRemission.getVacancyRemissionDetails();
            Collections.reverse(historyList);
        }
        return historyList;
    }

    public VacancyRemissionApproval getVacancyRemissionApprovalById(Long id) {
        return (VacancyRemissionApproval)((Object)this.vacancyRemissionApprovalRepository.findOne(id));
    }

    @Transactional
    public void saveVacancyRemissionApproval(VacancyRemissionApproval vacancyRemissionApproval, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        String designationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(user.getId());
        Position pos = null;
        Object wfInitiator = null;
        if (vacancyRemissionApproval.getId() != null && (workFlowAction.equalsIgnoreCase("Reject") || workFlowAction.equalsIgnoreCase("Generate Notice"))) {
            wfInitiator = StringUtils.containsIgnoreCase((CharSequence)designationList, (CharSequence)"UD Revenue Inspector") ? this.assignmentService.getPrimaryAssignmentForUser(vacancyRemissionApproval.getVacancyRemission().getCreatedBy().getId()) : this.assignmentService.getPrimaryAssignmentForUser(vacancyRemissionApproval.getCreatedBy().getId());
        }
        if (workFlowAction.equalsIgnoreCase("Generate Notice")) {
            if (wfInitiator.equals(userAssignment)) {
                vacancyRemissionApproval.setStatus("Rejection Acknowledgement Generated");
                vacancyRemissionApproval.transition().end().withSenderName(user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate());
            }
        } else if (workFlowAction.equalsIgnoreCase("Reject")) {
            String stateValue = "";
            String nextAction = "";
            if (StringUtils.containsIgnoreCase((CharSequence)designationList, (CharSequence)"Revenue officer") || StringUtils.containsIgnoreCase((CharSequence)designationList, (CharSequence)"Commissioner")) {
                stateValue = "Rejected";
                nextAction = "Revenue Inspector Approval Pending";
            } else {
                stateValue = "Revenue Inspector Rejected";
                nextAction = "Assistant Approval Pending";
            }
            vacancyRemissionApproval.setStatus("REJECTED");
            vacancyRemissionApproval.transition().withSenderName(user.getName()).withComments(approvalComent).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction(nextAction);
        } else {
            if (workFlowAction.equalsIgnoreCase("Forward")) {
                vacancyRemissionApproval.setStatus("IN_WORKFLOW");
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                vacancyRemissionApproval.setStatus("APPROVED");
            }
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            } else if ("Approve".equalsIgnoreCase(workFlowAction)) {
                pos = this.assignmentService.getPrimaryAssignmentForUser(vacancyRemissionApproval.getVacancyRemission().getCreatedBy().getId()).getPosition();
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == vacancyRemissionApproval.getState()) {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemissionApproval.getStateType(), null, null, additionalRule, null, null);
                vacancyRemissionApproval.transition().start().withSenderName(user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Vacany Remission");
            } else {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemissionApproval.getStateType(), null, null, additionalRule, vacancyRemissionApproval.getCurrentState().getValue(), null);
                if (wfmatrix != null) {
                    if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                        vacancyRemissionApproval.transition().end().withSenderName(user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate());
                    } else {
                        vacancyRemissionApproval.transition(false).withSenderName(user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
                    }
                    if (workFlowAction.equalsIgnoreCase("Approve")) {
                        Map<String, Installment> installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                        Installment installmentFirstHalf = installmentMap.get("Current 1st Half");
                        Installment installmentSecondHalf = installmentMap.get("Current 2nd Half");
                        if (DateUtils.between((Date)vacancyRemissionApproval.getVacancyRemission().getVacancyToDate(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                            this.updateDemandDetailsWithRebate(vacancyRemissionApproval.getVacancyRemission(), installmentFirstHalf, installmentSecondHalf);
                        }
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
        this.vacancyRemissionApprovalRepository.save((Object)vacancyRemissionApproval);
    }

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public VacancyRemission saveVacancyRemission(VacancyRemission vacancyRemission, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, Boolean propertyByEmployee, HashMap<String, String> meesevaParams) {
        return this.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, additionalRule, workFlowAction, propertyByEmployee);
    }

    public void buildSMS(VacancyRemission vacancyRemission, String workFlowAction) {
        for (PropertyOwnerInfo ownerInfo : vacancyRemission.getBasicProperty().getPropertyOwnerInfo()) {
            if (!StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getMobileNumber())) continue;
            this.buildSms(vacancyRemission, ownerInfo.getOwner(), workFlowAction);
        }
    }

    private void buildSms(VacancyRemission vacancyRemission, User user, String workFlowAction) {
        String assessmentNo = vacancyRemission.getBasicProperty().getUpicNo();
        String mobileNumber = user.getMobileNumber();
        String applicantName = user.getName();
        String smsMsg = "";
        if (!workFlowAction.equals("Forward")) {
            if (workFlowAction.equals("Reject")) {
                smsMsg = this.ptisMessageSource.getMessage("vacancyremission.rejection.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            } else if (workFlowAction.equals("Approve")) {
                smsMsg = this.ptisMessageSource.getMessage("vacancyremission.approval.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
    }
}

