/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.demolition;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.FlushMode;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

public class PropertyDemolitionService
extends PersistenceService<PropertyImpl, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyDemolitionService.class);
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private PropertyService propService;
    @Autowired
    private PropertyPersistenceService propertyPerService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource ptisMessageSource;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    public PropertyDemolitionService() {
        super(PropertyImpl.class);
    }

    public PropertyDemolitionService(Class<PropertyImpl> type) {
        super(type);
    }

    @Transactional
    public void saveProperty(Property oldProperty, Property newProperty, Character status, String comments, String workFlowAction, Long approverPosition, String additionalRule) throws TaxCalculatorExeption {
        BasicProperty basicProperty = oldProperty.getBasicProperty();
        PropertyTypeMaster propTypeMstr = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND");
        PropertyImpl propertyModel = (PropertyImpl)newProperty;
        newProperty.getPropertyDetail().setPropertyTypeMaster(propTypeMstr);
        newProperty.getBasicProperty().setPropOccupationDate(newProperty.getPropertyDetail().getDateOfCompletion());
        String areaOfPlot = String.valueOf(propertyModel.getPropertyDetail().getSitalArea().getArea());
        propertyModel = this.propService.createProperty(propertyModel, areaOfPlot, "FULL DEMOLITION", propertyModel.getPropertyDetail().getPropertyTypeMaster().getId().toString(), null, null, status, null, null, null, null, null, null, null);
        Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
        Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
        Date effectiveDate = null;
        effectiveDate = DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate()) ? installmentFirstHalf.getFromDate() : installmentSecondHalf.getFromDate();
        propertyModel.setBasicProperty(basicProperty);
        propertyModel.setEffectiveDate(effectiveDate);
        if (!propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
            this.propService.changePropertyDetail(propertyModel, new VacantProperty(), 0);
        }
        propertyModel.getPropertyDetail().setCategoryType("VACANTLAND");
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        propertyModel.setBasicProperty(basicProperty);
        basicProperty.addProperty(propertyModel);
        this.getSession().setFlushMode(FlushMode.MANUAL);
        this.transitionWorkFlow(propertyModel, comments, workFlowAction, approverPosition, additionalRule);
        Installment currInstall = this.propertyTaxCommonUtils.getCurrentInstallment();
        Property modProperty = this.propService.createDemand(propertyModel, effectiveDate);
        Object currPtDmd = null;
        for (Object demand : modProperty.getPtDemandSet()) {
            if (!demand.getIsHistory().equalsIgnoreCase("N") || !demand.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            currPtDmd = demand;
            break;
        }
        Ptdemand oldCurrPtDmd = null;
        for (Ptdemand ptDmd : oldProperty.getPtDemandSet()) {
            if (!ptDmd.getIsHistory().equalsIgnoreCase("N") || !ptDmd.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            oldCurrPtDmd = ptDmd;
            break;
        }
        Installment effectiveInstall = null;
        Module module = this.moduleDao.getModuleByName("Property Tax");
        effectiveInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, effectiveDate);
        this.propService.addArrDmdDetToCurrentDmd(oldCurrPtDmd, (Ptdemand)((Object)currPtDmd), effectiveInstall, true);
        basicProperty.addProperty(modProperty);
        for (Ptdemand ptDemand : modProperty.getPtDemandSet()) {
            this.propertyPerService.applyAuditing(ptDemand.getDmdCalculations());
        }
        currPtDmd = this.adjustCollection(oldCurrPtDmd, (Ptdemand)((Object)currPtDmd), effectiveInstall);
        this.propertyPerService.update(basicProperty);
        this.getSession().flush();
    }

    private Ptdemand adjustCollection(Ptdemand oldCurrPtDmd, Ptdemand currPtDmd, Installment effectiveInstall) {
        BigDecimal totalColl = BigDecimal.ZERO;
        for (EgDemandDetails oldDmdDtls : oldCurrPtDmd.getEgDemandDetails()) {
            if (!oldDmdDtls.getInstallmentStartDate().equals(effectiveInstall.getFromDate()) && !oldDmdDtls.getInstallmentStartDate().after(effectiveInstall.getFromDate())) continue;
            totalColl = totalColl.add(oldDmdDtls.getAmtCollected());
        }
        if (totalColl.compareTo(BigDecimal.ZERO) > 0) {
            for (EgDemandDetails dmdDtls : currPtDmd.getEgDemandDetails()) {
                if (!dmdDtls.getInstallmentStartDate().equals(effectiveInstall.getFromDate()) && !dmdDtls.getInstallmentStartDate().after(effectiveInstall.getFromDate())) continue;
                if (dmdDtls.getAmount().compareTo(totalColl) >= 0) {
                    dmdDtls.setAmtCollected(totalColl);
                    totalColl = BigDecimal.ZERO;
                    continue;
                }
                dmdDtls.setAmtCollected(dmdDtls.getAmount());
                totalColl = totalColl.subtract(dmdDtls.getAmount());
            }
            if (totalColl.compareTo(BigDecimal.ZERO) > 0) {
                Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installment = yearwiseInstMap.get("Current 2nd Half");
                EgDemandDetails newDtls = this.ptBillServiceImpl.insertDemandDetails("ADVANCE", totalColl, installment);
                currPtDmd.addEgDemandDetails(newDtls);
            }
        }
        return currPtDmd;
    }

    public void updateProperty(Property newProperty, String comments, String workFlowAction, Long approverPosition, String additionalRule) {
        this.transitionWorkFlow((PropertyImpl)newProperty, comments, workFlowAction, approverPosition, additionalRule);
        this.propertyPerService.update(newProperty.getBasicProperty());
        this.getSession().flush();
    }

    private void transitionWorkFlow(PropertyImpl property, String approvarComments, String workFlowAction, Long approverPosition, String additionalRule) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WorkFlow Transition For Demolition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        wfInitiator = property.getId() != null ? this.propService.getWorkflowInitiator(property) : this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        if ("Reject".equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.getPosition().equals((Object)property.getState().getOwnerPosition())) {
                property.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
                property.setStatus(PropertyTaxConstants.STATUS_CANCELLED);
                property.getBasicProperty().setUnderWorkflow(Boolean.FALSE);
            } else {
                String stateValue = property.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                property.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Assistant Approval Pending");
                this.buildSMS(property, workFlowAction);
            }
        } else {
            if (null != approverPosition && approverPosition != -1L && !approverPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approverPosition);
            } else if ("Approve".equalsIgnoreCase(workFlowAction)) {
                pos = this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId());
            } else if ("Sign".equalsIgnoreCase(workFlowAction)) {
                pos = wfInitiator.getPosition();
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == property.getState()) {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, null, null);
                property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Demolition").withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
            } else {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, property.getCurrentState().getValue(), null);
                if (wfmatrix != null) {
                    if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                        property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
                    } else {
                        property.transition(false).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
                    }
                    if (workFlowAction.equalsIgnoreCase("Approve")) {
                        this.buildSMS(property, workFlowAction);
                        String clientSpecificDmdBill = this.propertyTaxCommonUtils.getAppConfigValue("IS_CLIENT_SPECIFIC_DEMANDBILL", "Property Tax");
                        if ("Y".equalsIgnoreCase(clientSpecificDmdBill)) {
                            this.propertyTaxCommonUtils.makeExistingDemandBillInactive(property.getBasicProperty().getUpicNo());
                        } else {
                            this.propertyTaxUtil.makeTheEgBillAsHistory(property.getBasicProperty());
                        }
                    }
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" WorkFlow Transition Completed for Demolition ...");
        }
    }

    public void validateProperty(Property property, BindingResult errors, HttpServletRequest request) {
        PropertyDetail propertyDetail = property.getPropertyDetail();
        if (StringUtils.isBlank((CharSequence)propertyDetail.getPattaNumber())) {
            errors.rejectValue("propertyDetail.pattaNumber", "pattaNumber.required");
        }
        if (StringUtils.isBlank((CharSequence)propertyDetail.getSurveyNumber())) {
            errors.rejectValue("propertyDetail.surveyNumber", "surveyNumber.required");
        }
        if (null == propertyDetail.getSitalArea().getArea()) {
            errors.rejectValue("propertyDetail.sitalArea.area", "vacantLandArea.required");
        }
        if (null == propertyDetail.getMarketValue()) {
            errors.rejectValue("propertyDetail.marketValue", "marketValue.required");
        }
        if (null == propertyDetail.getCurrentCapitalValue()) {
            errors.rejectValue("propertyDetail.currentCapitalValue", "currCapitalValue.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getNorthBoundary())) {
            errors.rejectValue("basicProperty.propertyID.northBoundary", "northBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getEastBoundary())) {
            errors.rejectValue("basicProperty.propertyID.eastBoundary", "eastBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getWestBoundary())) {
            errors.rejectValue("basicProperty.propertyID.westBoundary", "westBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getSouthBoundary())) {
            errors.rejectValue("basicProperty.propertyID.southBoundary", "southBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getDemolitionReason())) {
            errors.rejectValue("demolitionReason", "demolitionReason.required");
        }
    }

    public void addModelAttributes(Model model, BasicProperty basicProperty) {
        Property property = null;
        property = null != basicProperty.getProperty() ? basicProperty.getProperty() : basicProperty.getActiveProperty();
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (ptDemand != null && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            model.addAttribute("ARV", (Object)ptDemand.getDmdCalculations().getAlv());
        } else {
            model.addAttribute("ARV", (Object)BigDecimal.ZERO);
        }
        if (!basicProperty.getActiveProperty().getIsExemptedFromTax().booleanValue()) {
            try {
                Map<String, Map<String, BigDecimal>> demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.propertyTaxCommonUtils.getCurrentInstallment());
                Map<String, BigDecimal> currentTaxDetails = this.propService.getCurrentTaxDetails(demandCollMap, new Date());
                model.addAttribute("propertyTax", (Object)currentTaxDetails.get("General Tax"));
                model.addAttribute("eduCess", (Object)(currentTaxDetails.get("Education Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Education Cess")));
                model.addAttribute("libraryCess", (Object)(currentTaxDetails.get("Library Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Library Cess")));
                model.addAttribute("currTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("currTaxDue", (Object)currentTaxDetails.get("CURR_BAL"));
                model.addAttribute("totalTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("totalArrDue", (Object)currentTaxDetails.get("ARR_BAL"));
            }
            catch (Exception e) {
                LOGGER.error("Exception in addModelAttributes : ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception in addModelAttributes : " + e);
            }
        }
    }

    public void buildSMS(Property property, String workFlowAction) {
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfo()) {
            if (!StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getMobileNumber())) continue;
            this.buildSms(property, ownerInfo.getOwner(), workFlowAction);
        }
    }

    private void buildSms(Property property, User user, String workFlowAction) {
        String assessmentNo = property.getBasicProperty().getUpicNo();
        String mobileNumber = user.getMobileNumber();
        String applicantName = user.getName();
        String smsMsg = "";
        if (!workFlowAction.equals("Forward")) {
            if (workFlowAction.equals("Reject")) {
                smsMsg = this.ptisMessageSource.getMessage("demolition.rejection.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            } else if (workFlowAction.equals("Approve")) {
                Installment effectiveInstallment = null;
                Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
                Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
                Date effectiveDate = null;
                Map<String, BigDecimal> demandMap = null;
                BigDecimal totalTax = BigDecimal.ZERO;
                if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                    effectiveInstallment = installmentSecondHalf;
                } else {
                    Module module = this.moduleDao.getModuleByName("Property Tax");
                    effectiveDate = DateUtils.addDays((Date)installmentSecondHalf.getToDate(), (int)1);
                    effectiveInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, effectiveDate);
                }
                demandMap = this.propertyTaxUtil.getTaxDetailsForInstallment(property, effectiveInstallment, installmentFirstHalf);
                totalTax = demandMap.get("Vacant Land Tax") == null ? BigDecimal.ZERO : demandMap.get("Vacant Land Tax").add(demandMap.get("Library Cess") == null ? BigDecimal.ZERO : demandMap.get("Library Cess"));
                smsMsg = this.ptisMessageSource.getMessage("demolition.approval.sms", (Object[])new String[]{applicantName, assessmentNo, totalTax.toString(), new SimpleDateFormat("dd/MM/yyyy").format(effectiveInstallment.getFromDate()), ApplicationThreadLocals.getMunicipalityName()}, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
    }
}

