/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.dao.property.PropertyUsageDAO;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyUsageDAO")
@Transactional(readOnly=true)
public class PropertyUsageHibernateDAO
implements PropertyUsageDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PropertyUsage getPropertyUsage(String usageCode) {
        Query qry = this.getCurrentSession().createQuery("from PropertyUsage PU where PU.usageCode = :usageCode AND PU.usageCode IS NOT NULL AND ((PU.toDate IS NULL AND PU.fromDate <= :currDate) OR (PU.fromDate <= :currDate AND PU.toDate >= :currDate)) ");
        qry.setString("usageCode", usageCode);
        qry.setDate("currDate", new Date());
        return (PropertyUsage)((Object)qry.uniqueResult());
    }

    @Override
    public PropertyUsage getPropertyUsage(String usageCode, Date fromDate) {
        Query qry = this.getCurrentSession().createQuery("from PropertyUsage PU where PU.usageCode = :usageCode AND PU.usageCode IS NOT NULL AND ((PU.toDate IS NULL AND PU.fromDate <= :fromDate) OR (PU.fromDate <= :fromDate AND PU.toDate >= :fromDate)) ");
        qry.setString("usageCode", usageCode);
        qry.setDate("fromDate", fromDate);
        return (PropertyUsage)((Object)qry.uniqueResult());
    }

    @Override
    public List<PropertyUsage> getAllActivePropertyUsage() {
        Query qry = this.getCurrentSession().createQuery("from PropertyUsage PU where PU.isEnabled = 1");
        return qry.list();
    }

    @Override
    public List<PropertyUsage> getAllPropertyUsage() {
        Query qry = this.getCurrentSession().createQuery("from PropertyUsage PU where ((PU.toDate IS NULL AND PU.fromDate <= :currDate) OR (PU.fromDate <= :currDate AND PU.toDate >= :currDate))");
        qry.setDate("currDate", new Date());
        return qry.list();
    }

    @Override
    public List getPropUsageAscOrder() {
        Criteria criteria = this.getCurrentSession().createCriteria(PropertyUsage.class).addOrder(Order.asc((String)"id"));
        return criteria.list();
    }

    @Override
    public PropertyUsage findById(Long id, boolean lock) {
        return (PropertyUsage)((Object)this.getCurrentSession().createQuery("from PropertyUsage where id = ?").setParameter(0, (Object)id).uniqueResult());
    }

    @Override
    public PropertyUsage create(PropertyUsage propertyUsage) {
        this.getCurrentSession().save((Object)propertyUsage);
        this.getCurrentSession().flush();
        return propertyUsage;
    }

    @Override
    public void delete(PropertyUsage propertyUsage) {
        this.getCurrentSession().delete((Object)propertyUsage);
    }

    @Override
    public List<PropertyUsage> findAll() {
        return this.getCurrentSession().createQuery("From PropertyUsage order by usageName").list();
    }
}

