/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.integration.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.PaymentInfo;
import org.egov.collection.integration.models.PaymentInfoCard;
import org.egov.collection.integration.models.PaymentInfoCash;
import org.egov.collection.integration.models.PaymentInfoChequeDD;
import org.egov.commons.CChartOfAccounts;
import org.egov.dcb.bean.CashPayment;
import org.egov.dcb.bean.ChequePayment;
import org.egov.dcb.bean.CreditCardPayment;
import org.egov.dcb.bean.DDPayment;
import org.egov.dcb.bean.Payment;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.client.integration.utils.SpringBeanUtil;
import org.egov.ptis.constants.PropertyTaxConstants;

public class CollectionHelper {
    private static final Logger LOG = Logger.getLogger(CollectionHelper.class);
    private EgBill bill;
    private boolean isMutationFeePayment = false;

    public CollectionHelper() {
    }

    public CollectionHelper(EgBill bill) {
        this.bill = bill;
    }

    public BillReceiptInfo executeCollection(Payment payment, String source) {
        if (!this.isCollectionPermitted()) {
            throw new ApplicationRuntimeException("Collection is not allowed - current balance is zero and advance coll exists.");
        }
        List<PaymentInfo> paymentInfoList = this.preparePaymentInfo(payment);
        LOG.debug((Object)"CollectionHelper.executeCollection(): collection is from the field...");
        BillInfoImpl billInfo = this.prepareBillInfo(payment.getAmount(), BillInfo.COLLECTIONTYPE.F, source);
        return SpringBeanUtil.getCollectionIntegrationService().createReceipt((BillInfo)billInfo, paymentInfoList);
    }

    public BillReceiptInfo generateMiscReceipt(Payment payment) {
        if (!this.isCollectionPermitted()) {
            throw new ApplicationRuntimeException("Collection is not allowed - Fully paid or excess Paid.");
        }
        List<PaymentInfo> paymentInfoList = this.preparePaymentInfo(payment);
        BillInfoImpl billInfo = this.prepareBillInfo(payment.getAmount(), BillInfo.COLLECTIONTYPE.C, null);
        return SpringBeanUtil.getCollectionIntegrationService().createMiscellaneousReceipt((BillInfo)billInfo, paymentInfoList);
    }

    public BillReceiptInfo getReceiptInfo(String receiptNumber) {
        return SpringBeanUtil.getCollectionIntegrationService().getReceiptInfo("PT", receiptNumber);
    }

    private List<PaymentInfo> preparePaymentInfo(Payment payment) {
        ArrayList<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        PaymentInfoCard paymentInfo = null;
        if (payment != null) {
            if (payment instanceof ChequePayment) {
                ChequePayment chequePayment = (ChequePayment)payment;
                paymentInfo = new PaymentInfoChequeDD(chequePayment.getBankId(), chequePayment.getBranchName(), chequePayment.getInstrumentDate(), chequePayment.getInstrumentNumber(), PaymentInfo.TYPE.cheque, payment.getAmount());
            } else if (payment instanceof DDPayment) {
                DDPayment chequePayment = (DDPayment)payment;
                paymentInfo = new PaymentInfoChequeDD(chequePayment.getBankId(), chequePayment.getBranchName(), chequePayment.getInstrumentDate(), chequePayment.getInstrumentNumber(), PaymentInfo.TYPE.dd, payment.getAmount());
            } else if (payment instanceof CreditCardPayment) {
                paymentInfo = this.prepareCardPaymentInfo((CreditCardPayment)payment, new PaymentInfoCard());
            } else if (payment instanceof CashPayment) {
                paymentInfo = new PaymentInfoCash(payment.getAmount());
            }
        }
        paymentInfoList.add((PaymentInfo)paymentInfo);
        return paymentInfoList;
    }

    public BillInfoImpl prepareBillInfo(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, String source) {
        BillInfoImpl billInfoImpl = this.initialiseFromBill(amountPaid, collType);
        ArrayList<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>();
        ArrayList billDetails = new ArrayList(this.bill.getEgBillDetails());
        Collections.sort(billDetails);
        if (this.isMutationFeePayment) {
            for (EgBillDetails billDet : billDetails) {
                receiptDetails.add(this.initReceiptDetail(billDet.getGlcode(), billDet.getCrAmount(), billDet.getCrAmount().subtract(billDet.getDrAmount()), billDet.getDrAmount(), billDet.getDescription()));
            }
        } else {
            for (EgBillDetails billDet : billDetails) {
                receiptDetails.add(this.initReceiptDetail(billDet.getGlcode(), BigDecimal.ZERO, billDet.getCrAmount().subtract(billDet.getDrAmount()), billDet.getDrAmount(), billDet.getDescription()));
            }
            SpringBeanUtil.getPropertyTaxCollection().apportionPaidAmount(String.valueOf(this.bill.getId()), amountPaid, receiptDetails);
        }
        boolean isActualDemand = false;
        block2: for (EgBillDetails billDet : this.bill.getEgBillDetails()) {
            for (ReceiptDetail rd : receiptDetails) {
                if (!billDet.getGlcode().equals(rd.getAccounthead().getGlcode()) || !billDet.getDescription().equals(rd.getDescription())) continue;
                isActualDemand = billDet.getAdditionalFlag() == 1;
                BillAccountDetails billAccDetails = new BillAccountDetails(billDet.getGlcode(), billDet.getOrderNo(), rd.getCramount(), rd.getDramount(), billDet.getFunctionCode(), billDet.getDescription(), Boolean.valueOf(isActualDemand), BillAccountDetails.PURPOSE.valueOf((String)billDet.getPurpose()));
                ((BillDetails)((BillPayeeDetails)billInfoImpl.getPayees().get(0)).getBillDetails().get(0)).addBillAccountDetails(billAccDetails);
                continue block2;
            }
        }
        billInfoImpl.setTransactionReferenceNumber(this.bill.getTransanctionReferenceNumber());
        billInfoImpl.setSource(source != null ? source : "");
        return billInfoImpl;
    }

    private BillInfoImpl initialiseFromBill(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType) {
        String[] collModes;
        BillInfoImpl billInfoImpl = null;
        BillPayeeDetails billPayeeDet = null;
        ArrayList<BillPayeeDetails> billPayeeDetList = new ArrayList<BillPayeeDetails>();
        ArrayList<String> collModesList = new ArrayList<String>();
        for (String coll : collModes = this.bill.getCollModesNotAllowed().split(",")) {
            collModesList.add(coll);
        }
        billInfoImpl = new BillInfoImpl(this.bill.getServiceCode(), this.bill.getFundCode(), this.bill.getFunctionaryCode(), this.bill.getFundSourceCode(), this.bill.getDepartmentCode(), this.bill.getDisplayMessage(), this.bill.getCitizenName(), this.bill.getPartPaymentAllowed(), this.bill.getOverrideAccountHeadsAllowed(), collModesList, collType);
        billPayeeDet = new BillPayeeDetails(this.bill.getCitizenName(), this.bill.getCitizenAddress(), this.bill.getEmailId());
        BillDetails billDetails = new BillDetails(this.bill.getId().toString(), this.bill.getCreateDate(), this.bill.getConsumerId(), this.bill.getBoundaryNum().toString(), this.bill.getBoundaryType(), this.bill.getDescription(), amountPaid, this.bill.getMinAmtPayable());
        billPayeeDet.addBillDetails(billDetails);
        billPayeeDetList.add(billPayeeDet);
        billInfoImpl.setPayees(billPayeeDetList);
        return billInfoImpl;
    }

    private ReceiptDetail initReceiptDetail(String glCode, BigDecimal crAmount, BigDecimal crAmountToBePaid, BigDecimal drAmount, String description) {
        ReceiptDetail receiptDetail = new ReceiptDetail();
        CChartOfAccounts accountHead = new CChartOfAccounts();
        accountHead.setGlcode(glCode);
        receiptDetail.setAccounthead(accountHead);
        receiptDetail.setDescription(description);
        receiptDetail.setCramount(crAmount);
        receiptDetail.setCramountToBePaid(crAmountToBePaid);
        receiptDetail.setDramount(drAmount);
        return receiptDetail;
    }

    private PaymentInfoCard prepareCardPaymentInfo(CreditCardPayment cardPayment, PaymentInfoCard paymentInfoCard) {
        paymentInfoCard.setInstrumentNumber(cardPayment.getCreditCardNo());
        paymentInfoCard.setInstrumentAmount(cardPayment.getAmount());
        paymentInfoCard.setExpMonth(cardPayment.getExpMonth());
        paymentInfoCard.setExpYear(cardPayment.getExpYear());
        paymentInfoCard.setCvvNumber(cardPayment.getCvv());
        paymentInfoCard.setCardTypeValue(cardPayment.getCardType());
        paymentInfoCard.setTransactionNumber(cardPayment.getTransactionNumber());
        return paymentInfoCard;
    }

    private boolean isCollectionPermitted() {
        boolean allowed = this.thereIsBalanceToBePaid();
        LOG.debug((Object)("isCollectionPermitted() returned: " + allowed));
        return allowed;
    }

    private boolean thereIsBalanceToBePaid() {
        boolean result = false;
        BigDecimal balance = BigDecimal.ZERO;
        for (EgBillDetails bd : this.bill.getEgBillDetails()) {
            if ((balance = balance.add(bd.balance())).compareTo(BigDecimal.ZERO) <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean thereIsCurrentBalanceToBePaid() {
        boolean result = false;
        BigDecimal currentBal = BigDecimal.ZERO;
        for (Map.Entry<String, String> entry : PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.entrySet()) {
            currentBal = currentBal.add(this.bill.balanceForGLCode(entry.getValue()));
        }
        if (currentBal != null && currentBal.compareTo(BigDecimal.ZERO) > 0) {
            result = true;
        }
        return result;
    }

    EgBill getBill() {
        return this.bill;
    }

    void setBill(EgBill bill) {
        this.bill = bill;
    }

    public boolean getIsMutationFeePayment() {
        return this.isMutationFeePayment;
    }

    public void setIsMutationFeePayment(boolean isMutationFeePayment) {
        this.isMutationFeePayment = isMutationFeePayment;
    }
}

