/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.elasticsearch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.PropertyTaxDefaultersRequest;
import org.egov.ptis.bean.dashboard.TaxDefaulters;
import org.egov.ptis.bean.dashboard.TaxPayerDetails;
import org.egov.ptis.bean.dashboard.TaxPayerResponseDetails;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.elasticsearch.model.PropertyTaxIndex;
import org.egov.ptis.repository.elasticsearch.PropertyTaxIndexRepository;
import org.egov.ptis.service.elasticsearch.CollectionIndexElasticSearchService;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class PropertyTaxElasticSearchIndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyTaxElasticSearchIndexService.class);
    private PropertyTaxIndexRepository propertyTaxIndexRepository;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private CollectionIndexElasticSearchService collectionIndexElasticSearchService;

    @Autowired
    public PropertyTaxElasticSearchIndexService(PropertyTaxIndexRepository propertyTaxIndexRepository) {
        this.propertyTaxIndexRepository = propertyTaxIndexRepository;
    }

    public Page<PropertyTaxIndex> findByConsumercode(String consumerCode, PageRequest pageRequest) {
        return this.propertyTaxIndexRepository.findByConsumerCode(consumerCode, (Pageable)new PageRequest(0, 10));
    }

    public BigDecimal getTotalDemand() {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totaldemand").field("totalDemand")).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)aggregations.get("totaldemand");
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public void getConsolidatedDemandInfo(CollectionDetailsRequest collectionDetailsRequest, CollectionDetails collectionIndexDetails) {
        Date toDate;
        Date fromDate;
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        BigDecimal totalDemand = this.getTotalDemandBasedOnInputFilters(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getTotalDemandBasedOnInputFilters() is : " + timeTaken + " (millisecs) ");
        startTime = System.currentTimeMillis();
        int noOfMonths = DateUtils.noOfMonths((Date)fromDate, (Date)toDate) + 1;
        collectionIndexDetails.setTotalDmd(totalDemand);
        BigDecimal proportionalDemand = totalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        collectionIndexDetails.setCytdDmd(proportionalDemand.setScale(0, 4));
        collectionIndexDetails.setPerformance(collectionIndexDetails.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
        BigDecimal variation = BigDecimal.ZERO;
        variation = collectionIndexDetails.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : collectionIndexDetails.getCytdColl().subtract(collectionIndexDetails.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(collectionIndexDetails.getLytdColl(), 1, 4);
        collectionIndexDetails.setLyVar(variation);
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getConsolidatedDemandInfo() is : " + timeTaken + " (millisecs) ");
    }

    public BigDecimal getTotalDemandBasedOnInputFilters(CollectionDetailsRequest collectionDetailsRequest) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest);
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totaldemand").field("totalDemand")).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)collAggr.get("totaldemand");
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public TaxPayerResponseDetails getTopTenTaxPerformers(CollectionDetailsRequest collectionDetailsRequest) {
        TaxPayerResponseDetails topTaxPerformers = new TaxPayerResponseDetails();
        List<TaxPayerDetails> taxProducers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", false, "total_collection", 10);
        List<TaxPayerDetails> taxAchievers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", false, "total_collection", 120);
        topTaxPerformers.setProducers(taxProducers);
        topTaxPerformers.setAchievers(taxAchievers);
        return topTaxPerformers;
    }

    public TaxPayerResponseDetails getBottomTenTaxPerformers(CollectionDetailsRequest collectionDetailsRequest) {
        TaxPayerResponseDetails topTaxPerformers = new TaxPayerResponseDetails();
        List<TaxPayerDetails> taxProducers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", true, "total_collection", 10);
        List<TaxPayerDetails> taxAchievers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", true, "total_collection", 120);
        topTaxPerformers.setProducers(taxProducers);
        topTaxPerformers.setAchievers(taxAchievers);
        return topTaxPerformers;
    }

    public List<TaxPayerDetails> returnUlbWiseAggregationResults(CollectionDetailsRequest collectionDetailsRequest, String indexName, Boolean order, String orderingAggregationName, int size) {
        ArrayList<TaxPayerDetails> taxPayers = new ArrayList<TaxPayerDetails>();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest);
        String groupingField = StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode()) || StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType()) && collectionDetailsRequest.getType().equals("ward") ? "revenueWard" : "cityName";
        Long startTime = System.currentTimeMillis();
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"by_aggregationField").field(groupingField)).size(size).order(Terms.Order.aggregation((String)orderingAggregationName, (boolean)order)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"totaldemand").field("totalDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total_collection").field("totalCollection"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by ulbWiseAggregations is : " + timeTaken + " (millisecs) ");
        startTime = System.currentTimeMillis();
        Date fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
        Date toDate = DateUtils.addDays((Date)new Date(), (int)1);
        Date lastYearFromDate = DateUtils.addYears((Date)fromDate, (int)-1);
        Date lastYearToDate = DateUtils.addYears((Date)toDate, (int)-1);
        StringTerms totalAmountAggr = (StringTerms)collAggr.get("by_aggregationField");
        for (Terms.Bucket entry : totalAmountAggr.getBuckets()) {
            TaxPayerDetails taxDetail = new TaxPayerDetails();
            taxDetail.setRegionName(collectionDetailsRequest.getRegionName());
            taxDetail.setDistrictName(collectionDetailsRequest.getDistrictName());
            taxDetail.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            String fieldName = String.valueOf(entry.getKey());
            if (groupingField.equals("revenueWard")) {
                taxDetail.setWardName(fieldName);
            } else {
                taxDetail.setUlbName(fieldName);
            }
            int noOfMonths = DateUtils.noOfMonths((Date)fromDate, (Date)toDate) + 1;
            Sum totalDemandAggregation = (Sum)entry.getAggregations().get("totaldemand");
            Sum totalCollectionAggregation = (Sum)entry.getAggregations().get("total_collection");
            BigDecimal totalDemandValue = BigDecimal.valueOf(totalDemandAggregation.getValue()).setScale(0, 4);
            BigDecimal totalCollections = BigDecimal.valueOf(totalCollectionAggregation.getValue()).setScale(0, 4);
            BigDecimal proportionalDemand = totalDemandValue.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            taxDetail.setTotalDmd(totalDemandValue);
            taxDetail.setCytdColl(totalCollections);
            taxDetail.setCytdDmd(proportionalDemand);
            taxDetail.setAchievement(totalCollections.multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
            taxDetail.setCytdBalDmd(proportionalDemand.subtract(totalCollections));
            BigDecimal lastYearCollection = this.collectionIndexElasticSearchService.getCollectionBetweenDates(collectionDetailsRequest, lastYearFromDate, lastYearToDate, fieldName);
            taxDetail.setLytdColl(lastYearCollection);
            BigDecimal variation = BigDecimal.ZERO;
            variation = lastYearCollection.compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : totalCollections.subtract(lastYearCollection).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(lastYearCollection, 1, 4);
            taxDetail.setLyVar(variation);
            taxPayers.add(taxDetail);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in returnUlbWiseAggregationResults() is : " + timeTaken + " (millisecs) ");
        return this.returnTopResults(taxPayers, size, order);
    }

    private List<TaxPayerDetails> returnTopResults(List<TaxPayerDetails> taxPayers, int size, Boolean order) {
        if (size > 10) {
            if (order.booleanValue()) {
                Collections.sort(taxPayers);
            } else {
                Collections.sort(taxPayers, Collections.reverseOrder());
            }
            return taxPayers.subList(0, taxPayers.size() < 10 ? taxPayers.size() : 10);
        }
        return taxPayers;
    }

    public List<TaxDefaulters> getTopDefaulters(PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.filterBasedOnRequest(propertyTaxDefaultersRequest);
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)"Guntur")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)"Vijayawada")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)"Visakhapatnam"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder("totalBalance").order(SortOrder.DESC)).withPageable((Pageable)new PageRequest(0, 100)).build();
        Page propertyTaxRecords = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, PropertyTaxIndex.class);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by defaulters aggregation is : " + timeTaken + " (millisecs) ");
        ArrayList<TaxDefaulters> taxDefaulters = new ArrayList<TaxDefaulters>();
        startTime = System.currentTimeMillis();
        for (PropertyTaxIndex property : propertyTaxRecords) {
            TaxDefaulters taxDfaulter = new TaxDefaulters();
            taxDfaulter.setOwnerName(property.getConsumerName());
            taxDfaulter.setPropertyType(property.getPropertyType());
            taxDfaulter.setUlbName(property.getCityName());
            taxDfaulter.setBalance(BigDecimal.valueOf(property.getTotalBalance()));
            taxDfaulter.setPeriod("");
            taxDefaulters.add(taxDfaulter);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getTopDefaulters() is : " + timeTaken + " (millisecs) ");
        return taxDefaulters;
    }

    private BoolQueryBuilder filterBasedOnRequest(PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"totalDemand").from(0).to(null));
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)propertyTaxDefaultersRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)propertyTaxDefaultersRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)propertyTaxDefaultersRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)propertyTaxDefaultersRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getWardName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)propertyTaxDefaultersRequest.getWardName()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getType())) {
            if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("region") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getRegionName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)propertyTaxDefaultersRequest.getRegionName()));
            } else if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("district") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getDistrictName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)propertyTaxDefaultersRequest.getDistrictName()));
            } else if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("city") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbCode())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)propertyTaxDefaultersRequest.getUlbCode()));
            } else if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("grade") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbGrade())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)propertyTaxDefaultersRequest.getUlbGrade()));
            }
        }
        return boolQuery;
    }

    private BoolQueryBuilder prepareWhereClause(CollectionDetailsRequest collectionDetailsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"totalDemand").from(0).to(null));
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)collectionDetailsRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)collectionDetailsRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)collectionDetailsRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)collectionDetailsRequest.getUlbCode()));
        }
        return boolQuery;
    }
}

