/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.dashboard;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.bean.dashboard.CollReceiptDetails;
import org.egov.ptis.bean.dashboard.CollTableData;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.CollectionStats;
import org.egov.ptis.bean.dashboard.CollectionTrend;
import org.egov.ptis.bean.dashboard.PropertyTaxDefaultersRequest;
import org.egov.ptis.bean.dashboard.ReceiptTableData;
import org.egov.ptis.bean.dashboard.ReceiptsTrend;
import org.egov.ptis.bean.dashboard.StateCityInfo;
import org.egov.ptis.bean.dashboard.TaxDefaulters;
import org.egov.ptis.bean.dashboard.TaxPayerResponseDetails;
import org.egov.ptis.bean.dashboard.TotalCollectionStats;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.service.elasticsearch.CollectionIndexElasticSearchService;
import org.egov.ptis.service.elasticsearch.PropertyTaxElasticSearchIndexService;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropTaxDashboardService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropTaxDashboardService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CollectionIndexElasticSearchService collectionIndexElasticSearchService;
    @Autowired
    private PropertyTaxElasticSearchIndexService propertyTaxElasticSearchIndexService;
    @Autowired
    private SimpleRestClient simpleRestClient;

    public List<StateCityInfo> getStateCityDetails() {
        String query = "select regionname as region, districtname as district, city as city, grade as grade, citycode as ulbcode from public.statecityinfo order by city ";
        SQLQuery sqlQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(query);
        sqlQuery.addScalar("region", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("district", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("city", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("grade", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("ulbCode", (Type)StandardBasicTypes.STRING);
        sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(StateCityInfo.class));
        List stateCityDetails = sqlQuery.list();
        return stateCityDetails;
    }

    public TotalCollectionStats getTotalCollectionStats(HttpServletRequest request) {
        TotalCollectionStats consolidatedCollectionDetails = new TotalCollectionStats();
        Long startTime = System.currentTimeMillis();
        CollectionStats consolidatedData = new CollectionStats();
        Map<String, BigDecimal> consolidatedColl = this.collectionIndexElasticSearchService.getFinYearsCollByService("Property Tax");
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getFinYearsCollByService() for Property Tax is : " + timeTaken + " (millisecs) ");
        if (!consolidatedColl.isEmpty()) {
            consolidatedData.setCytdColl(consolidatedColl.get("cytdColln"));
            consolidatedData.setLytdColl(consolidatedColl.get("lytdColln"));
        }
        startTime = System.currentTimeMillis();
        BigDecimal totalDmd = this.propertyTaxElasticSearchIndexService.getTotalDemand();
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by Property Tax getTotalDemand() is : " + timeTaken + " (millisecs) ");
        int noOfMonths = DateUtils.noOfMonths((Date)new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate(), (Date)new Date()) + 1;
        consolidatedData.setTotalDmd(totalDmd.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths)));
        consolidatedData.setPerformance(consolidatedData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getTotalDmd(), 1, 4));
        consolidatedData.setLyVar(consolidatedData.getCytdColl().subtract(consolidatedData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getCytdColl(), 1, 4));
        consolidatedCollectionDetails.setPropertyTax(consolidatedData);
        consolidatedData = new CollectionStats();
        startTime = System.currentTimeMillis();
        consolidatedColl = this.collectionIndexElasticSearchService.getFinYearsCollByService("Water Tax");
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getFinYearsCollByService() for Water Tax is : " + timeTaken + " (millisecs) ");
        if (!consolidatedColl.isEmpty()) {
            consolidatedData.setCytdColl(consolidatedColl.get("cytdColln"));
            consolidatedData.setLytdColl(consolidatedColl.get("lytdColln"));
        }
        startTime = System.currentTimeMillis();
        consolidatedData.setTotalDmd(this.getWaterChargeTotalDemand(request));
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by Water Tax getTotalDemand() is : " + timeTaken + " (millisecs) ");
        consolidatedData.setPerformance(consolidatedData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getTotalDmd(), 1, 4));
        consolidatedData.setLyVar(consolidatedData.getCytdColl().subtract(consolidatedData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getCytdColl(), 1, 4));
        consolidatedCollectionDetails.setWaterTax(consolidatedData);
        consolidatedData = new CollectionStats();
        consolidatedData.setCytdColl(BigDecimal.ZERO);
        consolidatedData.setTotalDmd(BigDecimal.ZERO);
        consolidatedData.setLytdColl(BigDecimal.ZERO);
        consolidatedData.setPerformance(BigDecimal.ZERO);
        consolidatedData.setLyVar(BigDecimal.ZERO);
        consolidatedCollectionDetails.setOthers(consolidatedData);
        return consolidatedCollectionDetails;
    }

    public BigDecimal getWaterChargeTotalDemand(HttpServletRequest request) {
        String wtmsRestURL = String.format("%s/wtms/rest/watertax/totaldemandamount/", WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        return waterTaxInfo.get("currentDemand") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("currentDemand"));
    }

    public CollectionDetails getCollectionIndexDetails(CollectionDetailsRequest collectionDetailsRequest) {
        CollectionDetails collectionIndexDetails = new CollectionDetails();
        this.collectionIndexElasticSearchService.getCompleteCollectionIndexDetails(collectionDetailsRequest, collectionIndexDetails);
        this.propertyTaxElasticSearchIndexService.getConsolidatedDemandInfo(collectionDetailsRequest, collectionIndexDetails);
        List<CollectionTrend> collectionTrends = this.collectionIndexElasticSearchService.getMonthwiseCollectionDetails(collectionDetailsRequest);
        List<CollTableData> collIndexData = StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType()) && collectionDetailsRequest.getType().equals("billcollector") ? this.collectionIndexElasticSearchService.getResponseTableDataForBillCollector(collectionDetailsRequest) : this.collectionIndexElasticSearchService.getResponseTableData(collectionDetailsRequest);
        collectionIndexDetails.setCollTrends(collectionTrends);
        collectionIndexDetails.setResponseDetails(collIndexData);
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        collectionIndexDetails.setErrorDetails(errorDetails);
        return collectionIndexDetails;
    }

    public CollReceiptDetails getReceiptDetails(CollectionDetailsRequest collectionDetailsRequest) {
        CollReceiptDetails receiptDetails = new CollReceiptDetails();
        this.collectionIndexElasticSearchService.getTotalReceiptsCount(collectionDetailsRequest, receiptDetails);
        List<ReceiptsTrend> receiptTrends = this.collectionIndexElasticSearchService.getMonthwiseReceiptsTrend(collectionDetailsRequest);
        List<ReceiptTableData> receiptTableData = this.collectionIndexElasticSearchService.getReceiptTableData(collectionDetailsRequest);
        receiptDetails.setReceiptDetails(receiptTableData);
        receiptDetails.setReceiptsTrends(receiptTrends);
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        receiptDetails.setErrorDetails(errorDetails);
        return receiptDetails;
    }

    public TaxPayerResponseDetails getTopTenTaxProducers(CollectionDetailsRequest collectionDetailsRequest) {
        return this.propertyTaxElasticSearchIndexService.getTopTenTaxPerformers(collectionDetailsRequest);
    }

    public TaxPayerResponseDetails getBottomTenTaxProducers(CollectionDetailsRequest collectionDetailsRequest) {
        return this.propertyTaxElasticSearchIndexService.getBottomTenTaxPerformers(collectionDetailsRequest);
    }

    public List<TaxDefaulters> getTaxDefaulters(PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) {
        return this.propertyTaxElasticSearchIndexService.getTopDefaulters(propertyTaxDefaultersRequest);
    }
}

