/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Installment;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.service.CollectionApportioner;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PropertyTaxCollection
extends TaxCollection {
    private static final Logger LOGGER = Logger.getLogger(PropertyTaxCollection.class);
    private PersistenceService persistenceService;
    private BigDecimal totalAmount = BigDecimal.ZERO;
    private Installment currInstallment = null;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private PersistenceService<Property, Long> propertyImplService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private FunctionHibernateDAO functionDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsDAO;
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private CollectionIntegrationService collectionService;

    protected Module module() {
        return this.moduleDao.getModuleByName("Property Tax");
    }

    public void updateDemandDetails(BillReceiptInfo billRcptInfo) throws ApplicationRuntimeException {
        this.totalAmount = billRcptInfo.getTotalAmount();
        this.currInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        LOGGER.debug((Object)("updateDemandDetails : Updating Demand Details Started, billRcptInfo : " + billRcptInfo));
        try {
            EgDemand demand = this.getCurrentDemand(Long.valueOf(billRcptInfo.getBillReferenceNum()));
            String assessmentNo = ((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode();
            LOGGER.info((Object)("updateDemandDetails : Demand before proceeding : " + demand));
            LOGGER.info((Object)("updateDemandDetails : collection back update started for property : " + assessmentNo + " and receipt event is " + billRcptInfo.getEvent() + ". Total Receipt amount is." + this.totalAmount + " with receipt no." + billRcptInfo.getReceiptNum()));
            if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
                this.updateCollForRcptCreate(demand, billRcptInfo);
                this.activateDemand(demand);
                this.buildSMS(demand, billRcptInfo);
            } else if (billRcptInfo.getEvent().equals("RECEIPT_CANCELLED")) {
                this.updateCollForRcptCancel(demand, billRcptInfo);
            } else if (billRcptInfo.getEvent().equals("INSTRUMENT_BOUNCED")) {
                this.updateCollForChequeBounce(demand, billRcptInfo);
            }
            LOGGER.info((Object)("updateDemandDetails : Demand after processed : " + demand));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occured during back update of DCB : " + e.getMessage(), (Throwable)e);
        }
        LOGGER.debug((Object)"updateDemandDetails : Updating Demand Details Finished...");
    }

    private void buildSMS(EgDemand demand, BillReceiptInfo billRcptInfo) {
        PropertyImpl property = ((Ptdemand)demand).getEgptProperty();
        User user = property.getBasicProperty().getPrimaryOwner();
        String mobileNumber = user.getMobileNumber();
        StringBuilder smsMsg = new StringBuilder(100);
        String instNumber = "";
        ArrayList<String> instrumentType = new ArrayList<String>();
        for (ReceiptInstrumentInfo instrumentInfo : billRcptInfo.getInstrumentDetails()) {
            instrumentType.add(instrumentInfo.getInstrumentType());
            instNumber = instrumentInfo.getInstrumentNumber();
        }
        if (instrumentType.contains("cheque")) {
            smsMsg.append("Your cheque no.").append(instNumber).append(" with amount :").append(billRcptInfo.getTotalAmount()).append("/- has been submitted for Property tax collection. Amount received will be adjusted against the assessment no : ").append(((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode()).append(" subject to the realization of instrument.");
        } else if (instrumentType.contains("dd")) {
            smsMsg.append("Your DD no.").append(instNumber).append(" with amount :").append(billRcptInfo.getTotalAmount()).append("/- has been submitted for Property tax collection. Amount received will be adjusted against the assessment no : ").append(((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode()).append(" subject to the realization of instrument.");
        } else if (instrumentType.contains("cash")) {
            smsMsg.append("We have received a property tax cash payment of Rs.").append(billRcptInfo.getTotalAmount()).append("/- and it would be adjusted against your assessment no.").append(((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode());
        }
        if (mobileNumber != null) {
            this.messagingService.sendSMS(mobileNumber, smsMsg.toString());
        }
    }

    public void updateReceiptDetails(Set<BillReceiptInfo> billReceipts) {
        LOGGER.debug((Object)("updateReceiptDetails : Updating Receipt Details Started, billReceipts : " + billReceipts));
        Boolean status = false;
        if (billReceipts != null) {
            super.updateReceiptDetails(billReceipts);
        }
        LOGGER.debug((Object)("updateReceiptDetails : Updating Receipt Details Finished, status : " + status));
    }

    private void updateCollForRcptCreate(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)("updateCollForRcptCreate : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        LOGGER.info((Object)("updateCollForRcptCreate : Total amount collected : " + this.totalAmount));
        demand.addCollected(this.totalAmount);
        try {
            if (demand.getMinAmtPayable() != null && demand.getMinAmtPayable().compareTo(BigDecimal.ZERO) > 0) {
                demand.setMinAmtPayable(BigDecimal.ZERO);
            }
            this.updateDemandDetailForReceiptCreate(billRcptInfo.getAccountDetails(), demand, billRcptInfo);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occured during back update of DCB : updateCollForRcptCreate() " + e.getMessage(), (Throwable)e);
        }
        LOGGER.debug((Object)"updateCollForRcptCreate : Updating Demand For Collection finished...");
    }

    private void updateCollForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        if (demand.getAmtCollected() != null) {
            demand.setAmtCollected(demand.getAmtCollected().subtract(billRcptInfo.getTotalAmount()));
        }
        this.updateDmdDetForRcptCancel(demand, billRcptInfo);
        LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection finished For Demand : " + demand));
    }

    private void updateCollForChequeBounce(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)("reconcileCollForChequeBounce : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        BigDecimal totalCollChqBounced = this.getTotalChequeAmt(billRcptInfo);
        BigDecimal chqBouncePenalty = this.getChqBouncePenaltyAmt(totalCollChqBounced);
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        EgDemandDetails dmdDet = null;
        EgDemandDetails penaltyDmdDet = this.ptBillServiceImpl.getDemandDetail(demand, this.currInstallment, "Cheque Bounce Penalty");
        if (penaltyDmdDet == null) {
            dmdDet = this.ptBillServiceImpl.insertDemandDetails("CHQ_BUNC_PENALTY", chqBouncePenalty, this.currInstallment);
        } else {
            BigDecimal existDmdDetAmt = penaltyDmdDet.getAmount();
            existDmdDetAmt = existDmdDetAmt == null || existDmdDetAmt.equals(BigDecimal.ZERO) ? (existDmdDetAmt = BigDecimal.ZERO) : existDmdDetAmt;
            penaltyDmdDet.setAmount(existDmdDetAmt.add(chqBouncePenalty));
            dmdDet = penaltyDmdDet;
        }
        demand.setMinAmtPayable(totalCollChqBounced.add(chqBouncePenalty));
        demand.setAmtCollected(demand.getAmtCollected().subtract(billRcptInfo.getTotalAmount()));
        demand.setBaseDemand(demand.getBaseDemand().add(chqBouncePenalty));
        demand.setStatus(PropertyTaxConstants.DMD_STATUS_CHEQUE_BOUNCED);
        demand.addEgDemandDetails(dmdDet);
        this.updateDmdDetForRcptCancel(demand, billRcptInfo);
        LOGGER.debug((Object)("reconcileCollForChequeBounce : Updating Collection finished For Demand : " + demand));
    }

    private void updateDemandDetailForReceiptCreate(Set<ReceiptAccountInfo> accountDetails, EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method saveCollectionDetails");
        BigDecimal rebateAmount = BigDecimal.ZERO;
        for (ReceiptAccountInfo accInfo : accountDetails) {
            if (accInfo.getDescription() == null || !accInfo.getDescription().contains("REBATE")) continue;
            rebateAmount = accInfo.getDrAmount();
        }
        LOGGER.info((Object)"saveCollectionDetails : Start get demandDetailList");
        List demandDetailList = this.persistenceService.findAllBy("select dmdet FROM EgDemandDetails dmdet left join fetch dmdet.egDemandReason dmdRsn left join fetch dmdRsn.egDemandReasonMaster dmdRsnMstr left join fetch dmdRsn.egInstallmentMaster installment WHERE dmdet.egDemand = ?", new Object[]{demand});
        LOGGER.info((Object)"saveCollectionDetails : End get demandDetailList");
        HashMap installmentWiseDemandDetailsByReason = new HashMap();
        HashMap<String, EgDemandDetails> demandDetailByReason = new HashMap<String, EgDemandDetails>();
        EgDemandReason dmdRsn = null;
        String installmentDesc = null;
        Map<String, Installment> currInstallments = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        for (EgDemandDetails dmdDtls : demandDetailList) {
            if (dmdDtls.getAmount().compareTo(BigDecimal.ZERO) > 0 || dmdDtls.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ADVANCE")) {
                dmdRsn = dmdDtls.getEgDemandReason();
                installmentDesc = dmdRsn.getEgInstallmentMaster().getDescription();
                demandDetailByReason = new HashMap();
                if (installmentWiseDemandDetailsByReason.get(installmentDesc) == null) {
                    demandDetailByReason.put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                    installmentWiseDemandDetailsByReason.put(installmentDesc, demandDetailByReason);
                    continue;
                }
                ((Map)installmentWiseDemandDetailsByReason.get(installmentDesc)).put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                continue;
            }
            LOGGER.info((Object)("saveCollectionDetails - demand detail amount is zero " + dmdDtls));
        }
        LOGGER.info((Object)("saveCollectionDetails - installment demandDetails size = " + installmentWiseDemandDetailsByReason.size()));
        EgDemandDetails demandDetail = null;
        for (ReceiptAccountInfo rcptAccInfo : accountDetails) {
            if (rcptAccInfo.getDescription() == null || rcptAccInfo.getDescription().isEmpty() || rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String instDesc = desc[1].trim();
            demandDetail = reason.equalsIgnoreCase("Advance") ? (EgDemandDetails)((Map)installmentWiseDemandDetailsByReason.get(currInstallments.get("Current 2nd Half").getDescription())).get(reason) : (EgDemandDetails)((Map)installmentWiseDemandDetailsByReason.get(instDesc)).get(reason);
            if (rcptAccInfo.getGlCode().equalsIgnoreCase("1402002")) {
                if (demandDetail == null) {
                    throw new ApplicationRuntimeException("Demand Details for reason " + reason + " and with installment " + instDesc + " is null ");
                }
                demandDetail.addCollected(rcptAccInfo.getCrAmount());
            } else if (rcptAccInfo.getGlCode().equalsIgnoreCase("3504102")) {
                if (demandDetail != null) {
                    demandDetail.setAmtCollected(demandDetail.getAmtCollected().add(rcptAccInfo.getCrAmount()));
                } else {
                    demandDetail = this.insertAdvanceCollection("ADVANCE", rcptAccInfo.getCrAmount(), currInstallments.get("Current 2nd Half"));
                    demand.addEgDemandDetails(demandDetail);
                    this.persistenceService.getSession().flush();
                    if (installmentWiseDemandDetailsByReason.get(currInstallments.get("Current 2nd Half").getDescription()) == null) {
                        HashMap<String, EgDemandDetails> reasonAndDemandDetail = new HashMap<String, EgDemandDetails>();
                        reasonAndDemandDetail.put("Advance", demandDetail);
                        installmentWiseDemandDetailsByReason.put(currInstallments.get("Current 2nd Half").getDescription(), reasonAndDemandDetail);
                    } else {
                        ((Map)installmentWiseDemandDetailsByReason.get(currInstallments.get("Current 2nd Half").getDescription())).put("Advance", demandDetail);
                    }
                }
            } else {
                demandDetail.addCollectedWithOnePaisaTolerance(rcptAccInfo.getCrAmount());
                if (rebateAmount.compareTo(BigDecimal.ZERO) > 0 && instDesc.equals(currInstallments.get("Current 1st Half").getDescription()) && demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equals("GEN_TAX")) {
                    demandDetail.setAmtRebate(rebateAmount);
                }
            }
            this.persistCollectedReceipts(demandDetail, billRcptInfo.getReceiptNum(), this.totalAmount, billRcptInfo.getReceiptDate(), demandDetail.getAmtCollected());
            LOGGER.info((Object)("Persisted demand and receipt details for tax : " + reason + " installment : " + instDesc + " with receipt No : " + billRcptInfo.getReceiptNum() + " for Rs. " + rcptAccInfo.getCrAmount()));
        }
        LOGGER.debug((Object)"Exiting method saveCollectionDetails");
    }

    private void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        ReceiptAccountInfo rebateRcptAccInfo = null;
        Map<String, ReceiptAccountInfo> rebateReceiptAccInfoByInstallment = this.getRebteReceiptAccountInfosByInstallment(billRcptInfo);
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount()) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String installment = desc[1].trim();
            EgDemandReasonMaster demandReasonMaster = null;
            rebateRcptAccInfo = rebateReceiptAccInfoByInstallment.get(installment);
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                demandReasonMaster = demandDetail.getEgDemandReason().getEgDemandReasonMaster();
                if (!reason.equalsIgnoreCase(demandReasonMaster.getReasonMaster()) || !reason.equalsIgnoreCase("ADVANCE") && !installment.equals(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                if (rebateRcptAccInfo != null && demandDetail.getAmtRebate().compareTo(BigDecimal.ZERO) > 0 && (demandReasonMaster.getCode().equals("GEN_TAX") || demandReasonMaster.getCode().equalsIgnoreCase("ADVANCE"))) {
                    demandDetail.setAmtRebate(demandDetail.getAmtRebate().subtract(rebateRcptAccInfo.getDrAmount()));
                }
                if (demandDetail.getAmtCollected().compareTo(rcptAccInfo.getCrAmount()) < 0) {
                    throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + rcptAccInfo.getCrAmount() + " is greater than the collected amount " + demandDetail.getAmtCollected() + " for demandDetail " + demandDetail);
                }
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                LOGGER.info((Object)("Deducted Collected amount Rs." + rcptAccInfo.getCrAmount() + " for tax : " + reason + " and installment : " + installment));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancel");
    }

    private Map<String, ReceiptAccountInfo> getRebteReceiptAccountInfosByInstallment(BillReceiptInfo billRcptInfo) {
        HashMap<String, ReceiptAccountInfo> rebateReceiptAccInfoByInstallment = new HashMap<String, ReceiptAccountInfo>();
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (!rcptAccInfo.getGlCode().equalsIgnoreCase("2202103") && !rcptAccInfo.getGlCode().equalsIgnoreCase("4314209")) continue;
            rebateReceiptAccInfoByInstallment.put(rcptAccInfo.getDescription().split("-", 2)[1].trim(), rcptAccInfo);
        }
        return rebateReceiptAccInfoByInstallment;
    }

    public void apportionCollection(String billRefNo, BigDecimal amtPaid, List<ReceiptDetail> receiptDetails) {
        boolean isEligibleForCurrentRebate = false;
        boolean isEligibleForAdvanceRebate = false;
        if (this.propertyTaxUtil.isRebatePeriodActive()) {
            isEligibleForCurrentRebate = true;
        }
        CollectionApportioner apportioner = new CollectionApportioner(isEligibleForCurrentRebate, false, BigDecimal.ZERO);
        Map<String, BigDecimal> instDemand = this.getInstDemand(receiptDetails);
        apportioner.apportion(amtPaid, receiptDetails, instDemand);
    }

    private EgDemand cancelBill(Long billId) {
        EgDemand egDemand = null;
        if (billId != null) {
            EgBill egBill = this.egBillDAO.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
        return egDemand;
    }

    public BigDecimal calcEarlyPayRebate(BigDecimal instTaxAmount, BigDecimal rebateApplTaxAmt, BigDecimal collection) {
        BigDecimal rebate = BigDecimal.ZERO;
        Date today = new Date();
        Calendar firstRebateDate = Calendar.getInstance();
        BigDecimal halfYearTax = instTaxAmount.divide(new BigDecimal(2));
        LOGGER.debug((Object)("calcEarlyPayRebate instTaxAmount " + instTaxAmount + " halfYearTax " + halfYearTax + " rebateApplTaxAmt " + rebateApplTaxAmt + " collection " + collection));
        int currMonth = firstRebateDate.get(2);
        if (currMonth <= 2) {
            firstRebateDate.set(1, firstRebateDate.get(1) - 1);
        }
        firstRebateDate.set(5, 31);
        firstRebateDate.set(2, 4);
        firstRebateDate.set(11, 23);
        firstRebateDate.set(12, 59);
        firstRebateDate.set(13, 59);
        Calendar secondRebateDate = Calendar.getInstance();
        if (currMonth <= 2) {
            secondRebateDate.set(1, secondRebateDate.get(1) - 1);
        }
        secondRebateDate.set(5, 30);
        secondRebateDate.set(2, 10);
        secondRebateDate.set(11, 23);
        secondRebateDate.set(12, 59);
        secondRebateDate.set(13, 59);
        if (today.before(firstRebateDate.getTime()) || today.equals(firstRebateDate.getTime())) {
            rebate = collection.compareTo(BigDecimal.ZERO) == 1 ? (collection.compareTo(halfYearTax) <= 0 ? MoneyUtils.roundOff((BigDecimal)rebateApplTaxAmt.multiply(PropertyTaxConstants.SECOND_REBATETAX_PERC).divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO) : MoneyUtils.roundOff((BigDecimal)rebateApplTaxAmt.multiply(PropertyTaxConstants.FIRST_REBATETAX_PERC).divide(BigDecimal.valueOf(100L)));
        } else if (today.before(secondRebateDate.getTime()) || today.equals(secondRebateDate.getTime())) {
            rebate = collection.compareTo(halfYearTax) <= 0 ? MoneyUtils.roundOff((BigDecimal)rebateApplTaxAmt.multiply(PropertyTaxConstants.SECOND_REBATETAX_PERC).divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO;
        }
        LOGGER.debug((Object)("calcEarlyPayRebate rebate " + rebate));
        return rebate;
    }

    public BigDecimal getRebateApplAmount(List<ReceiptDetail> receiptDetails) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (ReceiptDetail rd : receiptDetails) {
            if (!rd.getAccounthead().getGlcode().equals(PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get("GEN_TAX"))) continue;
            taxAmount = rd.getCramountToBePaid();
            break;
        }
        return taxAmount;
    }

    public Map<String, BigDecimal> getInstDemand(List<ReceiptDetail> receiptDetails) {
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        String installment = "";
        for (ReceiptDetail rd : receiptDetails) {
            String glCode = rd.getAccounthead().getGlcode();
            installment = "";
            String[] desc = rd.getDescription().split("-", 2);
            installment = desc[1].trim();
            if (!glCode.equalsIgnoreCase("2202103") && (PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.containsValue(glCode) || PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.containsValue(glCode))) {
                if (retMap.get(installment) == null) {
                    retMap.put(installment, rd.getCramountToBePaid());
                } else {
                    retMap.put(installment, ((BigDecimal)retMap.get(installment)).add(rd.getCramountToBePaid()));
                }
            }
            if (PropertyTaxConstants.GLCODES_FOR_CURRENTTAX.contains(glCode) || PropertyTaxConstants.GLCODES_FOR_ARREARTAX.contains(glCode)) {
                this.prepareTaxMap(retMap, installment, rd, "FULLTAX");
                continue;
            }
            if (!"3504102".equalsIgnoreCase(glCode)) continue;
            this.prepareTaxMap(retMap, installment, rd, "ADVANCE");
        }
        return retMap;
    }

    private void prepareTaxMap(Map<String, BigDecimal> retMap, String installment, ReceiptDetail rd, String type) {
        if (retMap.get(installment + type) == null) {
            retMap.put(installment + type, rd.getCramountToBePaid());
        } else {
            retMap.put(installment + type, retMap.get(installment + type).add(rd.getCramountToBePaid()));
        }
    }

    public BigDecimal getTotalChequeAmt(BillReceiptInfo billRcptInfo) {
        BigDecimal totalCollAmt = BigDecimal.ZERO;
        try {
            if (billRcptInfo != null) {
                for (ReceiptInstrumentInfo rctInst : billRcptInfo.getBouncedInstruments()) {
                    if (rctInst.getInstrumentAmount() == null) continue;
                    totalCollAmt = totalCollAmt.add(rctInst.getInstrumentAmount());
                }
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in calculate Total Collected Amt" + (Object)((Object)e));
        }
        return totalCollAmt;
    }

    public BigDecimal getChqBouncePenaltyAmt(BigDecimal totalChqAmount) {
        return PropertyTaxConstants.CHQ_BOUNCE_PENALTY;
    }

    public EgDemandDetails createDemandDetails(EgDemandReason egDemandReason, BigDecimal amtCollected, BigDecimal dmdAmount) {
        return EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount, (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
    }

    public EgDemand getCurrentDemand(Long billId) {
        LOGGER.debug((Object)"Entered into getCurrentDemand");
        EgBill egBill = this.egBillDAO.findById(billId, false);
        String query = "SELECT ptd FROM Ptdemand ptd WHERE ptd.egInstallmentMaster = ? AND ptd.egptProperty.basicProperty.upicNo = ? AND (ptd.egptProperty.status = 'I' OR ptd.egptProperty.status = 'A') AND ptd.egptProperty.basicProperty.active = true";
        EgDemand egDemand = (EgDemand)this.persistenceService.find("SELECT ptd FROM Ptdemand ptd WHERE ptd.egInstallmentMaster = ? AND ptd.egptProperty.basicProperty.upicNo = ? AND (ptd.egptProperty.status = 'I' OR ptd.egptProperty.status = 'A') AND ptd.egptProperty.basicProperty.active = true", new Object[]{this.currInstallment, egBill.getConsumerId()});
        LOGGER.debug((Object)"Exiting from getCurrentDemand");
        return egDemand;
    }

    public EgDemandDetails insertAdvanceCollection(String demandReason, BigDecimal advanceCollectionAmount, Installment installment) {
        EgDemandDetails demandDetail = null;
        if (advanceCollectionAmount != null && advanceCollectionAmount.compareTo(BigDecimal.ZERO) > 0) {
            EgDemandReasonMaster egDemandReasonMaster = this.demandGenericDAO.getDemandReasonMasterByCode(demandReason, this.module());
            if (egDemandReasonMaster == null) {
                throw new ApplicationRuntimeException(" Advance Demand reason Master is null in method  insertAdvanceCollection");
            }
            EgDemandReason egDemandReason = this.demandGenericDAO.getDmdReasonByDmdReasonMsterInstallAndMod(egDemandReasonMaster, installment, this.module());
            if (egDemandReason == null) {
                throw new ApplicationRuntimeException(" Advance Demand reason is null in method  insertAdvanceCollection ");
            }
            demandDetail = this.createDemandDetails(egDemandReason, advanceCollectionAmount, BigDecimal.ZERO);
        }
        return demandDetail;
    }

    @Transactional
    private void activateDemand(EgDemand demand) {
        PropertyImpl property = ((Ptdemand)demand).getEgptProperty();
        if (property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE)) {
            property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.propertyImplService.persist((Object)property);
        }
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        Long billID = Long.valueOf(billReferenceNumber);
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>(0);
        EgBill bill = this.ptBillServiceImpl.updateBillWithLatest(billID);
        LOGGER.debug((Object)("Reconstruct consumer code :" + bill.getConsumerId() + ", with bill reference number: " + billReferenceNumber + ", for Amount Paid :" + actualAmountPaid));
        boolean isEligibleForCurrentRebate = false;
        boolean isEligibleForAdvanceRebate = false;
        if (this.propertyTaxUtil.isRebatePeriodActive()) {
            isEligibleForCurrentRebate = true;
        }
        CollectionApportioner apportioner = new CollectionApportioner(isEligibleForCurrentRebate, false, actualAmountPaid);
        billDetails.addAll(bill.getEgBillDetails());
        return apportioner.reConstruct(actualAmountPaid, billDetails, this.functionDAO, this.chartOfAccountsDAO);
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        String[] desc;
        ReceiptAmountInfo receiptAmountInfo = new ReceiptAmountInfo();
        BigDecimal currentInstallmentAmount = BigDecimal.ZERO;
        BigDecimal arrearAmount = BigDecimal.ZERO;
        BigDecimal latePaymentCharges = BigDecimal.ZERO;
        BigDecimal arrearLibCess = BigDecimal.ZERO;
        BigDecimal currLibCess = BigDecimal.ZERO;
        BigDecimal rebateAmount = BigDecimal.ZERO;
        EgBill egBill = this.egBillDAO.findById(Long.valueOf(billReceiptInfo.getBillReferenceNum()), false);
        ArrayList billDetails = new ArrayList(egBill.getEgBillDetails());
        List reciptDetailList = this.collectionService.getReceiptDetailListByReceiptNumber(billReceiptInfo.getReceiptNum());
        for (ReceiptAccountInfo rcptAccInfo : billReceiptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() != null && rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) == 1) {
                desc = rcptAccInfo.getDescription().split("-", 2);
                String reason = desc[0];
                if (rcptAccInfo.getGlCode().equals("1402002") && reason.equals("Penalty Fines")) {
                    latePaymentCharges = latePaymentCharges.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                if (rcptAccInfo.getGlCode().equals(PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get("LIB_CESS")) && reason.equals("Library Cess")) {
                    currLibCess = currLibCess.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                if (rcptAccInfo.getGlCode().equals(PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get("LIB_CESS")) && reason.equals("Library Cess")) {
                    arrearLibCess = arrearLibCess.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                if (rcptAccInfo.getGlCode().equals("4311004")) {
                    arrearAmount = arrearAmount.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                currentInstallmentAmount = currentInstallmentAmount.add(rcptAccInfo.getCrAmount());
                continue;
            }
            if (rcptAccInfo.getDrAmount() == null || rcptAccInfo.getDrAmount().compareTo(BigDecimal.ZERO) != 1 || !rcptAccInfo.getGlCode().equals("2202103")) continue;
            rebateAmount = rebateAmount.add(rcptAccInfo.getDrAmount());
        }
        for (EgBillDetails billDet : egBill.getEgBillDetails()) {
            desc = billDet.getDescription().split("-", 2);
            if (billDet.getOrderNo() == 1) {
                receiptAmountInfo.setInstallmentFrom(desc[1]);
                if (billDetails.size() == 1) {
                    receiptAmountInfo.setInstallmentTo(desc[1]);
                    break;
                }
            }
            if (billDetails.size() <= 1 || billDet.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || !((ReceiptDetail)reciptDetailList.get(0)).getOrdernumber().equals(billDet.getOrderNo())) continue;
            receiptAmountInfo.setInstallmentTo(desc[1]);
        }
        String revenueWard = (String)this.persistenceService.find("select bp.propertyID.ward.name from BasicPropertyImpl bp where bp.upicNo = ?", new Object[]{((ReceiptDetail)reciptDetailList.get(0)).getReceiptHeader().getConsumerCode()});
        receiptAmountInfo.setCurrentInstallmentAmount(currentInstallmentAmount);
        receiptAmountInfo.setLatePaymentCharges(latePaymentCharges);
        receiptAmountInfo.setArrearsAmount(arrearAmount);
        receiptAmountInfo.setCurrentCess(currLibCess);
        receiptAmountInfo.setArrearCess(arrearLibCess);
        receiptAmountInfo.setReductionAmount(rebateAmount);
        receiptAmountInfo.setRevenueWard(revenueWard);
        return receiptAmountInfo;
    }

    public void setPtBillServiceImpl(PTBillServiceImpl ptBillServiceImpl) {
        this.ptBillServiceImpl = ptBillServiceImpl;
    }
}

