/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.ptis.domain.dao.property.CategoryDao;
import org.egov.ptis.domain.entity.property.Category;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class CategoryHibDao
implements CategoryDao {
    public static final String FROM_DATE = "fromDate";
    public static final String TO_DATE = "toDate";
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List getAllCategoriesbyHistory() {
        Query qry = this.getCurrentSession().createQuery("from Category C where (C.toDate IS NULL AND C.fromDate <= :currDate) OR (C.fromDate <= :currDate AND C.toDate >= :currDate)) ");
        qry.setDate("currDate", new Date());
        return qry.list();
    }

    @Override
    public Float getCategoryAmount(Integer usageId, Integer bndryId) {
        Query qry = null;
        Float catAmt = null;
        if (usageId != null && bndryId != null) {
            qry = this.getCurrentSession().createQuery("select C.categoryAmount from Category C left join C.catBoundaries cb left join cb.bndry cbndry where cbndry.id =:bndryId and C.propUsage =:usageId AND ((C.toDate IS NULL AND C.fromDate <= :currDate) OR (C.fromDate <= :currDate AND C.toDate >= :currDate)) ");
            qry.setInteger("bndryId", bndryId.intValue());
            qry.setInteger("usageId", usageId.intValue());
            qry.setDate("currDate", new Date());
            catAmt = (Float)qry.uniqueResult();
        }
        return catAmt;
    }

    @Override
    public Float getCategoryAmountByUsageAndBndryAndDate(Integer usageId, Integer bndryId, Date fromDate) {
        Query qry = null;
        Float catAmt = null;
        if (usageId != null && bndryId != null && fromDate != null) {
            qry = this.getCurrentSession().createQuery("select C.categoryAmount from Category C left join C.catBoundaries cb left join cb.bndry cbndry where cbndry.id =:bndryId and C.propUsage =:usageId AND ((C.toDate IS NULL AND C.fromDate <= :fromDate) OR (C.fromDate <= :fromDate AND C.toDate >= :fromDate)) ");
            qry.setInteger("bndryId", bndryId.intValue());
            qry.setInteger("usageId", usageId.intValue());
            qry.setDate(FROM_DATE, fromDate);
            catAmt = (Float)qry.uniqueResult();
        }
        return catAmt;
    }

    @Override
    public Float getCatAmntByPropertyId(String pid) {
        Query qry = this.getCurrentSession().createQuery("select bp.boundary from BasicPropertyImpl bp where bp.upicNo like :pid");
        qry.setString("pid", pid);
        Boundary bndry = (Boundary)qry.uniqueResult();
        qry = this.getCurrentSession().createQuery("select cat.categoryAmount from BoundaryCategory bCat left join bCat.category cat where bCat.bndry like :bndry");
        qry.setEntity("bndry", (Object)bndry);
        Float catAmnt = (Float)qry.uniqueResult();
        return catAmnt;
    }

    @Override
    public Category getCategoryByCategoryNameAndUsage(Criterion criterion) {
        Criteria criteria = this.getCurrentSession().createCriteria(Category.class);
        Category category = null;
        if (criterion != null) {
            LogicalExpression dateCondn1 = Restrictions.and((Criterion)Restrictions.le((String)FROM_DATE, (Object)new Date()), (Criterion)Restrictions.isNull((String)TO_DATE));
            LogicalExpression dateCondn2 = Restrictions.and((Criterion)Restrictions.le((String)FROM_DATE, (Object)new Date()), (Criterion)Restrictions.ge((String)TO_DATE, (Object)new Date()));
            LogicalExpression dateCondn = Restrictions.or((Criterion)dateCondn1, (Criterion)dateCondn2);
            criteria.add(criterion);
            criteria.add((Criterion)dateCondn);
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            category = (Category)((Object)criteria.uniqueResult());
        }
        return category;
    }

    @Override
    public List<Category> getCategoryByCatAmtAndUsage(Criterion criterion) {
        Criteria criteria = this.getCurrentSession().createCriteria(Category.class);
        if (criterion != null) {
            LogicalExpression dateCondn1 = Restrictions.and((Criterion)Restrictions.le((String)FROM_DATE, (Object)new Date()), (Criterion)Restrictions.isNull((String)TO_DATE));
            LogicalExpression dateCondn2 = Restrictions.and((Criterion)Restrictions.le((String)FROM_DATE, (Object)new Date()), (Criterion)Restrictions.ge((String)TO_DATE, (Object)new Date()));
            LogicalExpression dateCondn = Restrictions.or((Criterion)dateCondn1, (Criterion)dateCondn2);
            criteria.add(criterion);
            criteria.add((Criterion)dateCondn);
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        }
        return criteria.list();
    }

    @Override
    public List<Category> getCategoryByRateUsageAndStructClass(Criterion criterion) {
        Criteria criteria = this.getCurrentSession().createCriteria(Category.class);
        if (criterion != null) {
            criteria.add(criterion);
            criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        }
        return criteria.list();
    }

    @Override
    public Category findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<Category> findAll() {
        return null;
    }

    @Override
    public Category create(Category category) {
        return null;
    }

    @Override
    public void delete(Category category) {
    }

    @Override
    public Category update(Category category) {
        return null;
    }
}

