/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.integration.bean;

import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.dcb.bean.DCBReport;
import org.egov.dcb.bean.Payment;
import org.egov.dcb.service.DCBService;
import org.egov.dcb.service.DCBServiceImpl;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.client.integration.impl.PropertyImpl;
import org.egov.ptis.client.integration.utils.CollectionHelper;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class Property {
    private static final Logger LOGGER = Logger.getLogger(Property.class);
    public static final int FLAG_NONE = 0;
    public static final int FLAG_BASIC = 1;
    public static final int FLAG_DCB = 2;
    public static final int FLAG_RECEIPTS = 3;
    public static final int FLAG_BASIC_AND_RECEIPTINFO = 4;
    protected BasicProperty basicProperty;
    protected DCBService dcbService;
    private String propertyID;
    private String citizenName;
    private String doorNumber;
    private String wardName;
    private DCBReport dcbReport = new DCBReport();
    private BillReceiptInfo billreceiptInfo;
    private String receiptNo;
    private int infoFlag;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;

    protected abstract Billable getBillable();

    public abstract void setBillable(PropertyTaxBillable var1);

    protected abstract EgBill createBill();

    protected abstract DCBDisplayInfo getDCBDisplayInfo();

    protected abstract void checkAuthorization();

    protected abstract void checkIsActive();

    public static Property fromPropertyID(String propertyID, String receiptNo, int flag) {
        LOGGER.info((Object)("fromPropertyID : propertyID " + propertyID));
        PropertyImpl p = new PropertyImpl();
        p.propertyID = propertyID;
        p.infoFlag = flag;
        p.receiptNo = receiptNo;
        super.validate();
        super.initBasicProperty();
        super.initDCBService();
        super.populate();
        return p;
    }

    private void initBasicProperty() {
        if (this.getPropertyID() != null) {
            this.basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(this.getPropertyID());
        }
    }

    private void initDCBService() {
        this.dcbService = new DCBServiceImpl(this.getBillable());
    }

    private void populate() {
        LOGGER.info((Object)("Instantiating property with propertyID: " + this.propertyID));
        if (this.basicProperty != null) {
            this.getBasicInfo();
            this.getDCB();
            this.getReceipts();
            this.getReceiptForRcptNo();
        }
        LOGGER.info((Object)("Property instantiated: " + this));
    }

    public BillReceiptInfo collect(Payment payment) {
        LOGGER.info((Object)("Property.collect() called: " + payment));
        BillReceiptInfo billReceiptInfo = null;
        this.checkIsActive();
        this.checkAuthorization();
        EgBill egBill = this.createBill();
        CollectionHelper collHelper = new CollectionHelper(egBill);
        billReceiptInfo = collHelper.executeCollection(payment, null);
        LOGGER.info((Object)("Property.collect() returned: " + billReceiptInfo));
        return billReceiptInfo;
    }

    private void getBasicInfo() {
        if (!this.isBasicInfoRequested()) {
            return;
        }
        this.propertyID = this.basicProperty.getUpicNo();
        this.citizenName = this.basicProperty.getFullOwnerName();
        if (this.basicProperty.getPropertyID() != null && this.basicProperty.getPropertyID().getWard() != null) {
            this.wardName = this.basicProperty.getPropertyID().getWard().getName();
        }
        if (this.basicProperty.getAddress() != null && this.basicProperty.getAddress().getHouseNoBldgApt() != null) {
            this.doorNumber = this.basicProperty.getAddress().getHouseNoBldgApt();
        }
        LOGGER.info((Object)"Got basic info...");
    }

    private void getDCB() {
        if (!this.isDCBRequested()) {
            return;
        }
        DCBReport report = this.dcbService.getCurrentDCBOnly(this.getDCBDisplayInfo());
        this.dcbReport.setFieldNames(report.getFieldNames());
        this.dcbReport.setRecords(report.getRecords());
        LOGGER.info((Object)"Got DCB...");
    }

    private void getReceipts() {
        if (!this.isPaymentsRequested()) {
            return;
        }
        DCBReport report = this.dcbService.getReceiptsOnly();
        Map receipts = report.getReceipts();
        this.dcbReport.setReceipts(receipts);
        LOGGER.info((Object)"Got payments...");
    }

    private void getReceiptForRcptNo() {
        if (!this.isReceiptInfoRequested()) {
            return;
        }
        CollectionHelper collectionHelper = new CollectionHelper();
        this.billreceiptInfo = collectionHelper.getReceiptInfo(this.receiptNo);
        LOGGER.info((Object)"Got payments...");
    }

    private boolean isBasicInfoRequested() {
        return this.infoFlag == 1 || this.infoFlag == 4;
    }

    private boolean isDCBRequested() {
        return (this.infoFlag & 2) == 2;
    }

    private boolean isPaymentsRequested() {
        return (this.infoFlag & 3) == 3;
    }

    private boolean isReceiptInfoRequested() {
        return (this.infoFlag & 4) == 4;
    }

    private void validate() {
        if (this.propertyID == null || this.propertyID.trim().equals("")) {
            throw new ApplicationRuntimeException("PropertyID was null or empty!");
        }
        if (this.isReceiptInfoRequested() && (this.receiptNo == null || this.receiptNo.equals(""))) {
            throw new ApplicationRuntimeException("receiptNo was null or empty!");
        }
    }

    public String getFullAddress() {
        return this.basicProperty.getAddress().toString();
    }

    public String getPropertyID() {
        return this.propertyID;
    }

    public String getCitizenName() {
        return this.citizenName;
    }

    public String getDoorNumber() {
        return this.doorNumber;
    }

    public String getWardName() {
        return this.wardName;
    }

    public DCBReport getDcbReport() {
        return this.dcbReport;
    }

    public String toString() {
        return this.getPropertyID() + "-" + this.getDcbReport();
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public BillReceiptInfo getBillreceiptInfo() {
        return this.billreceiptInfo;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }
}

