/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.service;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.portal.entity.Citizen;
import org.egov.portal.repository.CitizenRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CitizenService {
    @Autowired
    private CitizenRepository citizenRepository;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Transactional
    public void create(Citizen citizen) {
        citizen.addRole(this.roleService.getRoleByName("Citizen"));
        citizen.updateNextPwdExpiryDate(this.applicationProperties.userPasswordExpiryInDays());
        citizen.setPassword(this.passwordEncoder.encode((CharSequence)citizen.getPassword()));
        citizen.setActivationCode(RandomStringUtils.random((int)5, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        this.citizenRepository.save((Object)citizen);
        this.sendActivationMessage(citizen);
    }

    @Transactional
    public void update(Citizen citizen) {
        this.citizenRepository.save((Object)citizen);
    }

    public Citizen getCitizenByEmailId(String emailId) {
        return this.citizenRepository.findByEmailId(emailId);
    }

    public Citizen getCitizenByUserName(String userName) {
        return this.citizenRepository.findByUsername(userName);
    }

    public Citizen getCitizenByActivationCode(String activationCode) {
        return this.citizenRepository.findByActivationCode(activationCode);
    }

    @Transactional
    public Citizen activateCitizen(String activationCode) {
        Citizen citizen = this.getCitizenByActivationCode(StringUtils.defaultString((String)activationCode));
        if (citizen != null) {
            citizen.setActive(true);
            citizen.setActivationCode(null);
            this.update(citizen);
            this.messagingService.sendEmail(citizen.getEmailId(), "Portal Registration Success", String.format("Dear %s,\r\n You have successfully registered into our portal, you can use your registered mobile number as Username to login to our portal.\r\nRegards,\r\n%s", citizen.getName(), ApplicationThreadLocals.getMunicipalityName()));
            this.messagingService.sendSMS(citizen.getMobileNumber(), "Your portal registration completed, please use your registered mobile number as Username to login");
        }
        return citizen;
    }

    @Transactional
    public void resendActivationCode(Citizen citizen) {
        citizen.setActivationCode(RandomStringUtils.random((int)5, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        this.sendActivationMessage(citizen);
        this.citizenRepository.save((Object)citizen);
    }

    public void sendActivationMessage(Citizen citizen) throws ApplicationRuntimeException {
        this.messagingService.sendEmail(citizen.getEmailId(), "Portal Activation", String.format("Dear %s,\r\n Your Portal Activation Code is : %s", citizen.getName(), citizen.getActivationCode()));
        this.messagingService.sendSMS(citizen.getMobileNumber(), "Your Portal Activation Code is : " + citizen.getActivationCode());
    }
}

