/*
 * Decompiled with CFR 0.152.
 */
package org.egov.portal.entity;

import java.util.Date;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.State;
import org.egov.portal.entity.CitizenInbox;
import org.egov.portal.entity.enums.MessageType;
import org.egov.portal.entity.enums.Priority;

public class CitizenInboxBuilder {
    private final CitizenInbox citizenInbox = new CitizenInbox();

    public CitizenInboxBuilder(MessageType messageType, String headerMessage, String detailedMessage, Date messageDate, User assignedToCitizen, Priority priority) {
        this.citizenInbox.setMessageType(messageType);
        this.citizenInbox.setHeaderMessage(headerMessage);
        this.citizenInbox.setDetailedMessage(detailedMessage);
        this.citizenInbox.setMessageDate(messageDate);
        this.citizenInbox.setAssignedToCitizen(assignedToCitizen);
        this.citizenInbox.setPriority(priority);
    }

    public CitizenInboxBuilder module(Module module) {
        this.citizenInbox.setModule(module);
        return this;
    }

    public CitizenInboxBuilder identifier(String identifier) {
        this.citizenInbox.setIdentifier(identifier);
        return this;
    }

    public CitizenInboxBuilder link(String link) {
        this.citizenInbox.setLink(link);
        return this;
    }

    public CitizenInboxBuilder state(State state) {
        this.citizenInbox.setState(state);
        return this;
    }

    public CitizenInboxBuilder status(String status) {
        this.citizenInbox.setStatus(status);
        return this;
    }

    public CitizenInbox build() throws ApplicationRuntimeException {
        this.validate();
        this.citizenInbox.setRead(false);
        return this.citizenInbox;
    }

    private void validate() throws ApplicationRuntimeException {
        if (this.citizenInbox.getMessageType() == null) {
            throw new ApplicationRuntimeException("Message Type is mandatory");
        }
        if (this.citizenInbox.getHeaderMessage() == null) {
            throw new ApplicationRuntimeException("Header Message is mandatory");
        }
        if (this.citizenInbox.getDetailedMessage() == null) {
            throw new ApplicationRuntimeException("Detailed Message is mandatory");
        }
        if (this.citizenInbox.getMessageDate() == null) {
            throw new ApplicationRuntimeException("Message Date is mandatory");
        }
        if (this.citizenInbox.getAssignedToCitizen() == null) {
            throw new ApplicationRuntimeException("Assigned To Citizen is mandatory");
        }
        if (this.citizenInbox.getPriority() == null) {
            throw new ApplicationRuntimeException("Priority is mandatory");
        }
    }
}

