/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.pgr.service.reports.DrillDownReportService;
import org.egov.pgr.web.controller.reports.DrillDownReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.DrillDownReportResult;
import org.egov.pgr.web.controller.reports.DrillDownReportWithcompTypeAdaptor;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report", "/public/report"})
public class DrillDownReportController {
    @Autowired
    private final DrillDownReportService drillDownReportService;

    @Autowired
    public DrillDownReportController(DrillDownReportService drillDownReportService) {
        this.drillDownReportService = drillDownReportService;
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        ReportHelper reportHealperObj = new ReportHelper();
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/drillDownReportByBoundary"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "drillDown-search";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/drillDownReportByDept"})
    public String searchAgeingReportByDepartmentForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "drillDown-search";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/drillDown/resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String groupBy, @RequestParam String deptid, @RequestParam String complainttypeid, @RequestParam String selecteduserid, @RequestParam String boundary, @RequestParam String type, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam DateTime toDate, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SQLQuery drillDownreportQuery = null;
        String result = null;
        if (!(deptid == null || complainttypeid == null || selecteduserid == null || "".equals(deptid) || "".equals(complainttypeid) || "".equals(selecteduserid))) {
            String userName = selecteduserid.split("~")[0];
            if (userName.equals("")) {
                userName = null;
            }
            drillDownreportQuery = this.drillDownReportService.getDrillDownReportQuery(fromDate, toDate, complaintDateType, deptid, boundary, complainttypeid, userName);
            drillDownreportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List drillDownresult = drillDownreportQuery.list();
            result = "{ \"data\":" + this.toJSONForComplaintType((Object)drillDownresult) + "}";
        } else {
            drillDownreportQuery = this.drillDownReportService.getDrillDownReportQuery(fromDate, toDate, complaintDateType, groupBy, deptid, boundary, complainttypeid, selecteduserid);
            drillDownreportQuery.setResultTransformer(Transformers.aliasToBean(DrillDownReportResult.class));
            List drillDownresult = drillDownreportQuery.list();
            result = "{ \"data\":" + this.toJSON((Object)drillDownresult) + "}";
        }
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private Object toJSONForComplaintType(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DrillDownReportResult.class, (Object)new DrillDownReportWithcompTypeAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DrillDownReportResult.class, (Object)new DrillDownReportHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

