/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.pgr.service.reports.AgeingReportService;
import org.egov.pgr.web.controller.reports.AgeingReportHelperAdaptor;
import org.egov.pgr.web.controller.reports.AgeingReportResult;
import org.egov.pgr.web.controller.reports.ReportHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report", "/public/report"})
public class AgeingReportController {
    @Autowired
    private final AgeingReportService ageingReportService;

    @Autowired
    public AgeingReportController(AgeingReportService ageingReportService) {
        this.ageingReportService = ageingReportService;
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        ReportHelper reportHealperObj = new ReportHelper();
        LinkedHashMap<String, String> status = new LinkedHashMap<String, String>();
        status.put("Completed", "Completed");
        status.put("Pending", "Pending");
        status.put("Rejected", "Rejected");
        model.addAttribute("status", status);
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/ageingReportByBoundary"})
    public String searchAgeingReportByBoundaryForm(Model model) {
        model.addAttribute("mode", (Object)"ByBoundary");
        return "ageing-search";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/ageingReportByDept"})
    public String searchAgeingReportByDepartmentForm(Model model) {
        model.addAttribute("mode", (Object)"ByDepartment");
        return "ageing-search";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/ageing/resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String mode, @RequestParam String complaintDateType, @RequestParam DateTime fromDate, @RequestParam String status, @RequestParam DateTime toDate, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SQLQuery ageingreportQuery = this.ageingReportService.getageingReportQuery(fromDate, toDate, status, complaintDateType, mode);
        ageingreportQuery.setResultTransformer(Transformers.aliasToBean(AgeingReportResult.class));
        List ageingresult = ageingreportQuery.list();
        String result = "{ \"data\":" + this.toJSON((Object)ageingresult) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AgeingReportResult.class, (Object)new AgeingReportHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

