/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters.escalation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.EscalationService;
import org.egov.pgr.web.controller.masters.escalation.BulkEscalationGenerator;
import org.egov.pgr.web.controller.masters.escalation.EscalationHelper;
import org.egov.pgr.web.controller.masters.escalation.EscalationHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/bulkEscalation"})
public class BulkEscalationController {
    private final EscalationService escalationService;
    private final ComplaintTypeService complaintTypeService;
    private final ObjectTypeService objectTypeService;
    private final PositionHierarchyService positionHierarchyService;

    @Autowired
    public BulkEscalationController(EscalationService escalationService, ComplaintTypeService complaintTypeService, ObjectTypeService objectTypeService, PositionHierarchyService positionHierarchyService) {
        this.escalationService = escalationService;
        this.complaintTypeService = complaintTypeService;
        this.objectTypeService = objectTypeService;
        this.positionHierarchyService = positionHierarchyService;
    }

    @ModelAttribute(value="complainttypes")
    public List<ComplaintType> complaintTypes() {
        return this.complaintTypeService.findActiveComplaintTypes();
    }

    @ModelAttribute
    public BulkEscalationGenerator bulkEscalationGenerator() {
        return new BulkEscalationGenerator();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String newform() {
        return "bulkEscalation-new";
    }

    @RequestMapping(value={"/search-result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(Model model, HttpServletRequest request, @ModelAttribute BulkEscalationGenerator bulkEscalationGenerator, HttpServletResponse response) throws IOException {
        ArrayList<EscalationHelper> escalationHelperList = new ArrayList<EscalationHelper>();
        List escalationRecords = this.escalationService.getEscalationObjByComplaintTypeFromPosition(bulkEscalationGenerator.getComplaintTypes(), bulkEscalationGenerator.getFromPosition());
        for (PositionHierarchy posHir : escalationRecords) {
            EscalationHelper escalationHelper = new EscalationHelper();
            if (posHir.getObjectSubType() != null) {
                escalationHelper.setComplaintType(this.complaintTypeService.findByCode(posHir.getObjectSubType()));
            }
            escalationHelper.setFromPosition(posHir.getFromPosition());
            escalationHelper.setToPosition(posHir.getToPosition());
            escalationHelperList.add(escalationHelper);
        }
        String escalationJSONData = "{ \"data\":" + this.toJSON(escalationHelperList) + "}";
        IOUtils.write((String)escalationJSONData, (Writer)response.getWriter());
    }

    private String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(EscalationHelper.class, (Object)new EscalationHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(@Valid @ModelAttribute BulkEscalationGenerator bulkEscalationGenerator, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("message", (Object)"bulkescalation.unble.to.save");
            return "bulkEscalation-new";
        }
        for (ComplaintType complaintType : bulkEscalationGenerator.getComplaintTypes()) {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            PositionHierarchy positionHierarchy = new PositionHierarchy();
            positionHierarchy.setObjectType(objectType);
            positionHierarchy.setObjectSubType(complaintType.getCode());
            positionHierarchy.setFromPosition(bulkEscalationGenerator.getFromPosition());
            positionHierarchy.setToPosition(bulkEscalationGenerator.getToPosition());
            PositionHierarchy existingPosHierarchy = this.escalationService.getExistingEscalation(positionHierarchy);
            if (existingPosHierarchy != null) {
                existingPosHierarchy.setToPosition(bulkEscalationGenerator.getToPosition());
                this.positionHierarchyService.updatePositionHierarchy(existingPosHierarchy);
                continue;
            }
            this.positionHierarchyService.createPositionHierarchy(positionHierarchy);
        }
        redirectAttrs.addFlashAttribute("message", (Object)"msg.bulkescalation.success");
        return "redirect:/bulkEscalation/search";
    }
}

