/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeAdaptor;
import org.egov.pgr.service.ComplaintTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

@Controller
@RequestMapping(value={"/complainttype"})
public class ViewComplaintTypeController
extends MultiActionController {
    private ComplaintTypeService complaintTypeService;
    public static final String CONTENTTYPE_JSON = "application/json";

    @Autowired
    public ViewComplaintTypeController(ComplaintTypeService complaintTypeService) {
        this.complaintTypeService = complaintTypeService;
    }

    @RequestMapping(value={"view"}, method={RequestMethod.GET})
    public String complaintTypeViewForm(@ModelAttribute ComplaintType complaintType, Model model) {
        return "view-complaintType";
    }

    public String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ComplaintType.class, (Object)new ComplaintTypeAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"ajax/result"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int pageStart = Integer.valueOf(request.getParameter("start"));
        int pageSize = Integer.valueOf(request.getParameter("length"));
        int pageNumber = pageStart / pageSize + 1;
        List totalRecords = this.complaintTypeService.findAll();
        if (pageSize == -1) {
            pageSize = totalRecords.size();
        }
        List complaintTypeList = this.complaintTypeService.getListOfComplaintTypes(Integer.valueOf(pageNumber), Integer.valueOf(pageSize)).getContent();
        StringBuilder complaintTypeJSONData = new StringBuilder();
        complaintTypeJSONData.append("{\"draw\": ").append("0");
        complaintTypeJSONData.append(",\"recordsTotal\":").append(totalRecords.size());
        complaintTypeJSONData.append(",\"totalDisplayRecords\":").append(complaintTypeList.size());
        complaintTypeJSONData.append(",\"recordsFiltered\":").append(totalRecords.size());
        complaintTypeJSONData.append(",\"data\":").append(this.toJSON((Object)complaintTypeList)).append("}");
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((CharSequence)complaintTypeJSONData, (Writer)response.getWriter());
    }
}

