/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.ComplaintRouterAdaptor;
import org.egov.pgr.service.ComplaintRouterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/router"})
public class SearchRoutingController {
    public static final String CONTENTTYPE_JSON = "application/json";
    protected BoundaryTypeService boundaryTypeService;
    protected ComplaintRouterService complaintRouterService;

    @Autowired
    public SearchRoutingController(BoundaryTypeService boundaryTypeService, ComplaintRouterService complaintRouterService) {
        this.boundaryTypeService = boundaryTypeService;
        this.complaintRouterService = complaintRouterService;
    }

    @ModelAttribute
    public ComplaintRouter complaintRouter() {
        return new ComplaintRouter();
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION");
    }

    @RequestMapping(value={"/search-update"}, method={RequestMethod.GET})
    public String searchRouterUpdateForm(Model model) {
        model.addAttribute("boundaryTypes", (Object)this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION"));
        return "router-searchUpdate";
    }

    @RequestMapping(value={"/search-view"}, method={RequestMethod.GET})
    public String searchRouterViewForm(Model model) {
        model.addAttribute("boundaryTypes", (Object)this.boundaryTypeService.getBoundaryTypeByHierarchyTypeName("ADMINISTRATION"));
        return "router-searchView";
    }

    @RequestMapping(value={"/resultList-update"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long boundaryTypeId = Long.valueOf(request.getParameter("boundaryTypeId"));
        Long complaintTypeId = Long.valueOf(request.getParameter("complaintTypeId"));
        Long boundaryId = Long.valueOf(request.getParameter("boundaryId"));
        String complaintRouterJSONData = this.commonSearchResult(boundaryTypeId, complaintTypeId, boundaryId);
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((String)complaintRouterJSONData, (Writer)response.getWriter());
    }

    @RequestMapping(value={"/resultList-view"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesView(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long boundaryTypeId = Long.valueOf(request.getParameter("boundaryTypeId"));
        Long complaintTypeId = Long.valueOf(request.getParameter("complaintTypeId"));
        Long boundaryId = Long.valueOf(request.getParameter("boundaryId"));
        String complaintRouterJSONData = this.commonSearchResult(boundaryTypeId, complaintTypeId, boundaryId);
        response.setContentType(CONTENTTYPE_JSON);
        IOUtils.write((String)complaintRouterJSONData, (Writer)response.getWriter());
    }

    public String commonSearchResult(Long boundaryTypeId, Long complaintTypeId, Long boundaryId) {
        List pageOfRouters = this.complaintRouterService.getPageOfRouters(boundaryTypeId, complaintTypeId, boundaryId);
        return "{ \"data\":" + this.toJSON((Object)pageOfRouters) + "}";
    }

    private String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ComplaintRouter.class, (Object)new ComplaintRouterAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

