/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.web.controller.masters;

import javax.validation.Valid;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/complainttype-category"})
public class ComplaintTypeCategoryUpdateController {
    private final ComplaintTypeCategoryService complaintTypeCategoryService;

    @Autowired
    public ComplaintTypeCategoryUpdateController(ComplaintTypeCategoryService complaintTypeCategoryService) {
        this.complaintTypeCategoryService = complaintTypeCategoryService;
    }

    @ModelAttribute
    public ComplaintTypeCategory complaintTypeCategory(@PathVariable String categoryName) {
        return this.complaintTypeCategoryService.findByName(categoryName);
    }

    @RequestMapping(value={"update/{categoryName}"}, method={RequestMethod.GET})
    public String editComplaintTypeCategoryForm(@PathVariable String categoryName, @ModelAttribute ComplaintTypeCategory complaintTypeCategory, RedirectAttributes redirectAttrs, Model model) {
        if (complaintTypeCategory == null) {
            redirectAttrs.addFlashAttribute("error", (Object)"grievance.category.not.found");
            redirectAttrs.addFlashAttribute("categoryname", (Object)categoryName);
            return "redirect:/complainttype-category/search-for-edit";
        }
        return "complainttype-category-update";
    }

    @RequestMapping(value={"update/{categoryName}"}, method={RequestMethod.POST})
    public String editComplaintTypeCategory(@PathVariable String categoryName, @Valid @ModelAttribute ComplaintTypeCategory complaintTypeCategory, BindingResult error, RedirectAttributes redirectAttrs) {
        if (error.hasErrors()) {
            return "complainttype-category-update";
        }
        this.complaintTypeCategoryService.createComplaintTypeCategory(complaintTypeCategory);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.comp.type.catgory.update.success");
        return "redirect:/complainttype-category/update/" + categoryName;
    }
}

