/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.web.controller;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.masters.entity.Charges;
import org.egov.meeseva.masters.service.ChargesService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/updateApplicantDetails/{transactionRequestId}"})
public class UpdateApplicantDetailsController {
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private ChargesService chargesService;

    @ModelAttribute(value="transactionRequest")
    public TransactionRequest transactionRequestModel(@PathVariable Long transactionRequestId) {
        return this.transactionRequestService.getRequestById(transactionRequestId);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(@PathVariable Long transactionRequestId, Model model) {
        TransactionRequest request = this.transactionRequestService.getRequestById(transactionRequestId);
        if (!this.validRequest(request)) {
            throw new ApplicationRuntimeException("MEESEVA.003");
        }
        List charges = this.chargesService.getListOfChargesByServiceId(request.getServiceId().getId());
        Double totalAmount = 0.0;
        for (Charges charge : charges) {
            if (charge.getType().equalsIgnoreCase("POSTALCHARGES-LOCAL") || charge.getType().equals("POSTALCHARGES-NONLOCAL")) continue;
            totalAmount = totalAmount + charge.getValue();
        }
        model.addAttribute("charges", (Object)charges);
        model.addAttribute("totalAmount", (Object)totalAmount);
        return "updateApplicantDetails-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public RedirectView redirect(@ModelAttribute TransactionRequest transactionRequest, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (!this.validRequest(transactionRequest)) {
            throw new ApplicationRuntimeException("MEESEVA.003");
        }
        RedirectView redirect = null;
        redirect = transactionRequest.getServiceId().getUrl().contains("?") ? new RedirectView(transactionRequest.getServiceId().getUrl() + "&applicationNo=" + transactionRequest.getApplicationNo() + "&meesevaServicecode=" + transactionRequest.getServiceId().getCode(), false) : new RedirectView(transactionRequest.getServiceId().getUrl() + "?applicationNo=" + transactionRequest.getApplicationNo() + "&meesevaServicecode=" + transactionRequest.getServiceId().getCode(), false);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("applicationNo", transactionRequest.getApplicationNo());
        params.put("meesevaServicecode", transactionRequest.getServiceId().getCode());
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
            outputFlashMap.put((Object)"params", params);
        }
        transactionRequest = this.transactionRequestService.updateChargesByServiceAndDeliveryType(transactionRequest.getPaymentDetails().getDeliveryType(), transactionRequest);
        transactionRequest.getPaymentDetails().setApplicantDetailsUpdated(true);
        transactionRequest.getPaymentDetails().setApplicantAddress(transactionRequest.getPaymentDetails().getApplicantAddress().replaceAll("[\\t\\n\\r]+", " "));
        this.transactionRequestService.update(transactionRequest);
        return redirect;
    }

    private boolean validRequest(TransactionRequest transactionRequest) {
        TransactionRequest request = this.transactionRequestService.getRequestById(transactionRequest.getId());
        return !request.getPaymentDetails().isApplicantDetailsUpdated();
    }
}

