/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.web.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.meeseva.transactions.entity.CollectMutationCharge;
import org.egov.meeseva.transactions.entity.PaymentDetails;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.PaymentDetailsService;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.webservice.service.MeeSevaWebService;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/payMutationCharge/{transactionRequestId}"})
public class PayMutationChargeController {
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private MeeSevaWebService meeSevaWebService;
    @Autowired
    PaymentDetailsService paymentDetailsService;
    private String COLLECTIONURL = "/collection/citizen/onlineReceipt-viewReceipt.action?receiptNumber=";
    private static final Logger LOGGER = Logger.getLogger(PayMutationChargeController.class);

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(@PathVariable Long transactionRequestId, Model model) {
        TransactionRequest request = this.transactionRequestService.getRequestById(transactionRequestId);
        if (!this.validRequest(request)) {
            throw new ApplicationRuntimeException("MEESEVA.003");
        }
        if (request != null) {
            CollectMutationCharge collectMutationCharge = new CollectMutationCharge();
            collectMutationCharge.setPropertyNumber(request.getPaymentDetails().getTransactionServiceNumber());
            collectMutationCharge.setServiceId(request.getServiceId().getId());
            collectMutationCharge.setServiceName(request.getServiceId().getName());
            collectMutationCharge.setTransactionRequestId(request.getId());
            model.addAttribute("collectMutationCharge", (Object)collectMutationCharge);
        }
        return "payMutationCharge-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public RedirectView redirect(@ModelAttribute CollectMutationCharge collectMutationCharge, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        RedirectView redirect = null;
        if (collectMutationCharge != null && collectMutationCharge.getTransactionRequestId() != null) {
            TransactionRequest transactionRequest = this.transactionRequestService.getRequestById(collectMutationCharge.getTransactionRequestId());
            if (transactionRequest != null) {
                if (!this.validApplicationNumber(collectMutationCharge.getApplicationNumber())) {
                    throw new ApplicationRuntimeException("MEESEVA.005");
                }
                TransactionRequest earlierTransactionRequest = this.transactionRequestService.getRequestByMeesevaApplicationNo(collectMutationCharge.getApplicationNumber());
                transactionRequest.getPaymentDetails().setTransactionServiceNumber(collectMutationCharge.getPropertyNumber());
                transactionRequest.getPaymentDetails().setServiceAmount(Double.valueOf(collectMutationCharge.getAmount().doubleValue()));
                transactionRequest.getPaymentDetails().setTotalAmount(Double.valueOf(collectMutationCharge.getAmount().doubleValue()));
                transactionRequest.getPaymentDetails().setApplicantDetailsUpdated(true);
                transactionRequest.getPaymentDetails().setApplicantAddress("Mutation Charge payment from meeseva");
                transactionRequest.getPaymentDetails().setApplicantName(earlierTransactionRequest.getPaymentDetails().getApplicantName());
                this.transactionRequestService.update(transactionRequest);
                boolean paymentGateWayResponse = this.meeSevaWebService.GetPaymentGatewayResponse(transactionRequest);
                if (!paymentGateWayResponse) {
                    throw new ApplicationRuntimeException("MEESEVA.004");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.info((Object)("paymentGateWayResponse " + paymentGateWayResponse));
                }
                transactionRequest.setPaymentConfirmStatus(paymentGateWayResponse);
                this.transactionRequestService.update(transactionRequest);
                ReceiptDetails receiptDetails = this.payMutationCharge(collectMutationCharge, transactionRequest);
                redirect = this.buildUrlRedirect(collectMutationCharge, receiptDetails);
                String updatePaymentTransaction = this.meeSevaWebService.getPaymentTransId(transactionRequest);
                this.transactionRequestService.buildTransactionRequestOnPaymentUpdate(transactionRequest, updatePaymentTransaction);
                transactionRequest.getPaymentDetails().setTransactionServiceNumber(collectMutationCharge.getApplicationNumber());
                transactionRequest.getPaymentDetails().setReceiptNumber(receiptDetails.getReceiptNo());
                boolean updateStatus = this.meeSevaWebService.UpdateApplicationDetails(transactionRequest, "NA", "04", "NA");
                if (updateStatus) {
                    transactionRequest.setTransactionStatus("04");
                    transactionRequest.setStatusUpdateRemarks("");
                    transactionRequest.setStatusUpdated(true);
                    transactionRequest.setHistory(true);
                }
                this.transactionRequestService.update(transactionRequest);
            } else {
                throw new ApplicationRuntimeException("MEESEVA.003");
            }
        }
        if (redirect == null) {
            throw new ApplicationRuntimeException("MEESEVA.003");
        }
        return redirect;
    }

    private ReceiptDetails payMutationCharge(CollectMutationCharge collectMutationCharge, TransactionRequest transactionRequest) {
        PayPropertyTaxDetails payPropTaxDetails = new PayPropertyTaxDetails();
        payPropTaxDetails.setApplicationNo(collectMutationCharge.getApplicationNumber());
        payPropTaxDetails.setAssessmentNo(collectMutationCharge.getPropertyNumber());
        payPropTaxDetails.setPaymentAmount(collectMutationCharge.getAmount());
        payPropTaxDetails.setSource("Meeseva");
        payPropTaxDetails.setUlbCode(transactionRequest.getPaymentDetails().getMunicipalCode());
        payPropTaxDetails.setPaymentMode("cash");
        payPropTaxDetails.setTransactionId(transactionRequest.getMeesevaRequestNo());
        ReceiptDetails receiptDetails = this.propertyExternalService.payMutationFee(payPropTaxDetails);
        return receiptDetails;
    }

    private RedirectView buildUrlRedirect(CollectMutationCharge collectMutationCharge, ReceiptDetails receiptDetails) {
        RedirectView redirect = null;
        redirect = new RedirectView(this.COLLECTIONURL + receiptDetails.getReceiptNo() + "&consumerCode=" + collectMutationCharge.getApplicationNumber() + "&serviceCode=PTMF");
        return redirect;
    }

    private boolean validApplicationNumber(String applcationNumber) {
        if (applcationNumber != null) {
            TransactionRequest request = this.transactionRequestService.getRequestByMeesevaApplicationNo(applcationNumber);
            if (request == null) {
                return false;
            }
            PaymentDetails paymentDetail = this.paymentDetailsService.checkApplicationNumberAlreadyUsedInEarlierTransaction(applcationNumber, "PT07");
            if (paymentDetail == null) {
                return true;
            }
            if (paymentDetail != null && paymentDetail.getReceiptNumber() != null) {
                return false;
            }
        }
        return true;
    }

    private boolean validRequest(TransactionRequest transactionRequest) {
        TransactionRequest request = this.transactionRequestService.getRequestById(transactionRequest.getId());
        return !request.getPaymentDetails().isApplicantDetailsUpdated();
    }
}

