/*
 * Decompiled with CFR 0.152.
 */
package org.egov.meeseva.web.controller;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.meeseva.common.service.GenericMeesevaService;
import org.egov.meeseva.rest.service.CheckSumService;
import org.egov.meeseva.transactions.entity.TransactionRequest;
import org.egov.meeseva.transactions.service.TransactionRequestService;
import org.egov.meeseva.utils.constants.MeesevaConstants;
import org.egov.ptis.domain.service.property.PropertyThirdPartyService;
import org.egov.wtms.integration.WaterChargesThirdPartyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MeeSevaServicesRedirectController {
    public static final String UPDATEAPPLICANTDETAILS_FORM = "/updateApplicantDetails";
    public static final String PAY_MUTATION_CHARGE_FORM = "/payMutationCharge";
    public static final String RECEIPT = "meeseva_receipt";
    public static final String GENERATE_RECEIPT = "/generatereceipt";
    public static final String PRINT_SERVICE_NOTICE_PDF = "/print-servicenotice-pdf";
    private String COLLECTIONURL = "/collection/citizen/onlineReceipt-viewReceipt.action?receiptNumber=";
    private String APPLICATIONNUMBER = "applicationNumber";
    private static final Logger LOGGER = Logger.getLogger(MeeSevaServicesRedirectController.class);
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private GenericMeesevaService genericMeesevaService;
    @Autowired
    private TransactionRequestService transactionRequestService;
    @Autowired
    private CheckSumService checkSumService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private PropertyThirdPartyService propertyThirdPartyService;
    @Autowired
    private WaterChargesThirdPartyService waterChargesThirdPartyService;
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;

    @RequestMapping(value={"/meesevaservices-redirect"}, method={RequestMethod.GET})
    public RedirectView redirectMeeSevaServices(HttpServletRequest request) {
        TransactionRequest meesevaRequest = null;
        HashMap requestParms = new HashMap();
        if (request.getParameter("enc") != null) {
            requestParms = this.checkSumService.decryptInitialServiceRequestParameters(request);
            if (!this.genericMeesevaService.validateMeesevaServiceId((String)requestParms.get("serviceId"))) {
                throw new ApplicationRuntimeException("MEESEVA.001");
            }
            if (this.genericMeesevaService.validateServiceRequest((String)requestParms.get("meesevaSequenceNumber"))) {
                meesevaRequest = this.genericMeesevaService.persistMeesevaRequest(request, requestParms);
                RedirectView redirect = null;
                redirect = meesevaRequest != null && meesevaRequest.getServiceId().getCode().equalsIgnoreCase("PT07") ? new RedirectView("/payMutationCharge/" + meesevaRequest.getId(), true) : new RedirectView("/updateApplicantDetails/" + meesevaRequest.getId(), true);
                FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
                if (outputFlashMap != null) {
                    outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
                }
                return redirect;
            }
            throw new ApplicationRuntimeException("MEESEVA.002");
        }
        if (request.getParameter("applicationNo") != null) {
            TransactionRequest ts = this.transactionRequestService.getRequestByMeesevaApplicationNo(request.getParameter("applicationNo"));
            if (ts != null) {
                requestParms = this.checkSumService.decryptPrintCertificateParameters(request);
                if (requestParms != null && requestParms.get(this.APPLICATIONNUMBER) != null && !request.getParameter("applicationNo").equalsIgnoreCase((String)requestParms.get(this.APPLICATIONNUMBER))) {
                    throw new ApplicationRuntimeException("MEESEVA.003");
                }
                RedirectView redirect = null;
                redirect = ts != null && ts.getServiceId().getCode().equalsIgnoreCase("PT07") ? new RedirectView(this.COLLECTIONURL + ts.getPaymentDetails().getReceiptNumber() + "&consumerCode=" + ts.getPaymentDetails().getTransactionServiceNumber() + "&serviceCode=PTMF") : new RedirectView("/print-servicenotice-pdf?transactionServiceNumber=" + ts.getPaymentDetails().getTransactionServiceNumber() + "&applicationNo=" + request.getParameter("applicationNo") + "&serviceType=" + ts.getServiceId().getCode(), true);
                FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
                if (outputFlashMap != null) {
                    outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
                }
                return redirect;
            }
            throw new ApplicationRuntimeException("MEESEVA.003");
        }
        throw new ApplicationRuntimeException("MEESEVA.003");
    }

    private ResponseEntity<byte[]> generateReport(TransactionRequest transactionRequest, HttpServletRequest request, HttpSession session) {
        LOGGER.info((Object)"--- Inside generateReport() ----");
        this.reportInput = null;
        if (transactionRequest != null && transactionRequest.getPaymentDetails().getReceiptNumber() != null) {
            LOGGER.info((Object)("---  transactionRequest receipt number ----" + transactionRequest.getPaymentDetails().getReceiptNumber()));
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            String serviceName = transactionRequest.getServiceId().getName();
            this.reportParams.put("cityName", session.getAttribute("citymunicipalityname"));
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            this.reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            this.reportParams.put("serviceName", serviceName);
            this.reportParams.put("applicantAddress", transactionRequest.getPaymentDetails().getApplicantAddress());
            this.reportParams.put("receiptNum", transactionRequest.getPaymentDetails().getReceiptNumber());
            this.reportParams.put("receiptDate", formatter.format(transactionRequest.getPaymentDetails().getReceiptDate()));
            this.reportParams.put("applicantName", transactionRequest.getPaymentDetails().getApplicantName());
            this.reportParams.put("applicationNumber", transactionRequest.getApplicationNo());
            this.reportParams.put("receiptDescription", serviceName);
            this.reportParams.put("meesevaTransactionID", transactionRequest.getMeesevaTransactionId());
            this.reportParams.put("scaUserID", transactionRequest.getScaUserId());
            this.reportParams.put("sla", transactionRequest.getServiceId().getSla());
            LOGGER.info((Object)"---  before calling ReportRequest ----");
            this.reportInput = new ReportRequest(RECEIPT, (Collection)this.getChargesList(transactionRequest), this.reportParams);
            LOGGER.info((Object)"---  after calling ReportRequest ----");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Receipt.pdf");
        LOGGER.info((Object)"---  before calling createReport ----");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        LOGGER.info((Object)("---  after calling createReport ----" + this.reportOutput.getReportOutputData()));
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.OK);
    }

    private List<Map<String, Object>> getChargesList(TransactionRequest transactionRequest) {
        ArrayList<Map<String, Object>> chargesList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> chargesMap = new HashMap<String, Object>();
        String DESCRIPTION = "description";
        String AMOUNT = "amount";
        chargesMap.put(DESCRIPTION, "User Charges");
        if (transactionRequest.getPaymentDetails().getUserCharges() != null) {
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getUserCharges());
        } else {
            chargesMap.put(AMOUNT, 0);
        }
        chargesList.add(chargesMap);
        chargesMap = new HashMap();
        chargesMap.put(DESCRIPTION, "Service Amount");
        if (transactionRequest.getPaymentDetails().getServiceAmount() != null) {
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getServiceAmount());
        } else {
            chargesMap.put(AMOUNT, 0);
        }
        chargesList.add(chargesMap);
        chargesMap = new HashMap();
        chargesMap.put(DESCRIPTION, "Print Charges");
        if (transactionRequest.getPaymentDetails().getPrintCharges() != null) {
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getPrintCharges());
        } else {
            chargesMap.put(AMOUNT, 0);
        }
        chargesList.add(chargesMap);
        chargesMap = new HashMap();
        chargesMap.put(DESCRIPTION, "Postal Charges");
        if (transactionRequest.getPaymentDetails().getPostalCharges() != null) {
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getPostalCharges());
        } else {
            chargesMap.put(AMOUNT, 0);
        }
        chargesList.add(chargesMap);
        chargesMap = new HashMap();
        chargesMap.put(DESCRIPTION, "Challan Amount");
        if (transactionRequest.getPaymentDetails().getChallanAmount() != null) {
            chargesMap.put(AMOUNT, transactionRequest.getPaymentDetails().getChallanAmount());
        } else {
            chargesMap.put(AMOUNT, 0);
        }
        chargesList.add(chargesMap);
        return chargesList;
    }

    @RequestMapping(value={"/generatereceipt"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewReport(@RequestParam String transactionServiceNumber, HttpServletRequest request, HttpSession session) {
        LOGGER.info((Object)"--- Inside GENERATE_RECEIPT  ----");
        TransactionRequest transactionRequest = this.transactionRequestService.getRequestByTransactionServiceNumber(transactionServiceNumber);
        LOGGER.info((Object)"--- Before calling generateReport()  ----");
        return this.generateReport(transactionRequest, request, session);
    }

    @RequestMapping(value={"/print-servicenotice-pdf"}, method={RequestMethod.GET})
    private ResponseEntity<byte[]> printServiceNoticePDF(@RequestParam String transactionServiceNumber, @RequestParam String applicationNo, @RequestParam String serviceType) throws IOException {
        LOGGER.info((Object)"--- Inside PRINT_SERVICE_NOTICE_PDF  ----");
        byte[] pdfOutputStream = null;
        if (serviceType.contains("PT")) {
            pdfOutputStream = this.propertyThirdPartyService.getSpecialNotice(null, transactionServiceNumber, (String)MeesevaConstants.SERVICE_TYPE_APPLICATION_TYPE_MAP.get(serviceType));
        } else if (serviceType.contains("WT")) {
            pdfOutputStream = this.waterChargesThirdPartyService.getEstimationNotice(transactionServiceNumber);
        }
        if (pdfOutputStream == null) {
            return this.redirectToErrorPage(this.messageSource.getMessage("err.validate.service.notices.null", (Object[])new String[]{applicationNo}, null));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=ServiceNotice.pdf");
        LOGGER.info((Object)"--- finished PRINT_SERVICE_NOTICE_PDF  ----");
        return new ResponseEntity((Object)pdfOutputStream, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private ResponseEntity<byte[]> redirectToErrorPage(String errorMessage) {
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = errorMessage.getBytes();
        errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }
}

