/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.entity.VacateStay;
import org.egov.lcms.transactions.service.LegalCaseInterimOrderService;
import org.egov.lcms.transactions.service.VacateStayService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacatestay"})
public class VacateStayController {
    @Autowired
    private LegalCaseInterimOrderService legalCaseInterimOrderService;
    @Autowired
    private VacateStayService vacateStayService;

    @RequestMapping(value={"/new/"}, method={RequestMethod.GET})
    public String viewForm(@ModelAttribute(value="vacateStay") VacateStay vacateStay, @RequestParam(value="lcInterimOrderId") String lcInterimOrderId, Model model, HttpServletRequest request) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.getLcInterimOrder(lcInterimOrderId);
        List vacateStayList = this.getLcInterimOrder(lcInterimOrderId).getVacateStay();
        if (!vacateStayList.isEmpty()) {
            vacateStay = (VacateStay)vacateStayList.get(0);
        }
        model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
        model.addAttribute("vacateStay", (Object)vacateStay);
        model.addAttribute("lcNumber", (Object)legalCaseInterimOrder.getLegalCase().getLcNumber());
        model.addAttribute("legalCase", (Object)legalCaseInterimOrder.getLegalCase());
        model.addAttribute("mode", (Object)"create");
        return "vacatestay-new";
    }

    @ModelAttribute
    private LegalCaseInterimOrder getLcInterimOrder(@RequestParam(value="lcInterimOrderId") String lcInterimOrderId) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.legalCaseInterimOrderService.findById(Long.valueOf(Long.parseLong(lcInterimOrderId)));
        return legalCaseInterimOrder;
    }

    @RequestMapping(value={"/new/"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute(value="vacateStay") VacateStay vacateStay, BindingResult errors, RedirectAttributes redirectAttrs, @RequestParam(value="lcInterimOrderId") String lcInterimOrderId, HttpServletRequest request, Model model) {
        LegalCaseInterimOrder legalCaseInterimOrder = this.getLcInterimOrder(lcInterimOrderId);
        if (errors.hasErrors()) {
            model.addAttribute("legalCaseInterimOrder", (Object)legalCaseInterimOrder);
            return "vacatestay-new";
        }
        vacateStay.setLegalCaseInterimOrder(legalCaseInterimOrder);
        this.vacateStayService.persist(vacateStay);
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("lcInterimOrderId", (Object)legalCaseInterimOrder.getId());
        model.addAttribute("lcNumber", (Object)legalCaseInterimOrder.getLegalCase().getLcNumber());
        model.addAttribute("legalCase", (Object)legalCaseInterimOrder.getLegalCase());
        redirectAttrs.addFlashAttribute("vacateStay", (Object)vacateStay);
        model.addAttribute("message", (Object)"Vacate Stay Saved successfully.");
        return "vacatestay-success";
    }
}

