/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.transactions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.lcms.masters.entity.CaseTypeMaster;
import org.egov.lcms.masters.entity.CourtMaster;
import org.egov.lcms.masters.entity.CourtTypeMaster;
import org.egov.lcms.masters.entity.GovernmentDepartment;
import org.egov.lcms.masters.entity.PetitionTypeMaster;
import org.egov.lcms.masters.entity.enums.LCNumberType;
import org.egov.lcms.masters.service.CaseTypeMasterService;
import org.egov.lcms.masters.service.CourtMasterService;
import org.egov.lcms.masters.service.CourtTypeMasterService;
import org.egov.lcms.masters.service.GovernmentDepartmentService;
import org.egov.lcms.masters.service.PetitionTypeMasterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;

public class GenericLegalCaseController {
    @Autowired
    private CourtTypeMasterService courtTypeMasterService;
    @Autowired
    private CaseTypeMasterService caseTypeMasterService;
    @Autowired
    private GovernmentDepartmentService governmentDepartmentService;
    @Autowired
    private PetitionTypeMasterService petitionTypeMasterService;
    @Autowired
    private CourtMasterService courtMasterService;

    @ModelAttribute(value="courtTypeList")
    public List<CourtTypeMaster> courtTypeList() {
        return this.courtTypeMasterService.getActiveCourtTypes();
    }

    @ModelAttribute(value="petitiontypeList")
    public List<PetitionTypeMaster> getPetitionList() {
        return this.petitionTypeMasterService.getActivePetitionTypes();
    }

    @ModelAttribute(value="courtsList")
    public List<CourtMaster> getCourtNameList() {
        return this.courtMasterService.getActiveCourtMaster();
    }

    @ModelAttribute(value="govtDeptList")
    public List<GovernmentDepartment> getGovtDeptList() {
        return this.governmentDepartmentService.getActiveGovernmentDepartment();
    }

    @ModelAttribute(value="lcNumberTypes")
    public Map<String, String> getLcNumberTypeTypes() {
        return this.getLcNumberTypesMap();
    }

    public Map<String, String> getLcNumberTypesMap() {
        LinkedHashMap<String, String> connectionTypeMap = new LinkedHashMap<String, String>(0);
        connectionTypeMap.put(LCNumberType.AUTOMATED.toString(), "AUTOMATED");
        connectionTypeMap.put(LCNumberType.MANUAL.toString(), "MANUAL");
        return connectionTypeMap;
    }

    @ModelAttribute(value="caseTypeList")
    public List<CaseTypeMaster> caseTypeList() {
        return this.caseTypeMasterService.getActiveCaseTypeList();
    }

    @ModelAttribute(value="wPYearList")
    public List<Integer> getWPYearList() {
        ArrayList<Integer> wPYearList = new ArrayList<Integer>();
        int startYear = Integer.parseInt("1980");
        Calendar cal = Calendar.getInstance();
        for (int currentYear = cal.get(1); startYear <= currentYear; --currentYear) {
            wPYearList.add(currentYear);
        }
        return wPYearList;
    }
}

