/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.reports;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.HearingsDocument;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.reports.entity.LcDueReportResult;
import org.egov.lcms.repository.es.HearingsDocumentRepository;
import org.egov.lcms.repository.es.LegalCaseDocumentRepository;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class EmployeeHearingDueReportController
extends GenericLegalCaseController {
    @Autowired
    private LegalCaseDocumentRepository legalCaseDocumentRepository;
    @Autowired
    private HearingsDocumentRepository hearingsDocumentRepository;

    @RequestMapping(value={"/employeehearingDueReportResult"}, method={RequestMethod.POST})
    @ResponseBody
    public List<LcDueReportResult> getEmployeeHearingReport(@ModelAttribute LcDueReportResult searchRequest) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        ArrayList<LcDueReportResult> finalResult = new ArrayList<LcDueReportResult>();
        List hearingsDocumentList = this.findAllHearingsIndexByFilter(searchRequest);
        for (HearingsDocument hearingsDocument : hearingsDocumentList) {
            searchRequest.setLcNumber(hearingsDocument.getLcNumber());
            BoolQueryBuilder query = this.getFilterQuery(searchRequest);
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"legalcasedocument"}).withQuery((QueryBuilder)query).build();
            Page legalcaseDocumentSearchList = this.legalCaseDocumentRepository.search((SearchQuery)searchQuery);
            if (legalcaseDocumentSearchList == null) continue;
            for (LegalCaseDocument legalcaseDocumentIndex : legalcaseDocumentSearchList) {
                LcDueReportResult dueReportResultObj = new LcDueReportResult();
                dueReportResultObj.setCaseNumber(legalcaseDocumentIndex.getCaseNumber());
                dueReportResultObj.setLcNumber(legalcaseDocumentIndex.getLcNumber());
                dueReportResultObj.setCaseTitle(legalcaseDocumentIndex.getCaseTitle());
                dueReportResultObj.setCaseNumber(legalcaseDocumentIndex.getCaseNumber());
                dueReportResultObj.setCourtName(legalcaseDocumentIndex.getCourtName());
                dueReportResultObj.setPetName(legalcaseDocumentIndex.getPetitionerNames());
                dueReportResultObj.setResName(legalcaseDocumentIndex.getRespondantNames());
                dueReportResultObj.setStandingCounsel(legalcaseDocumentIndex.getAdvocateName());
                dueReportResultObj.setOfficerIncharge(legalcaseDocumentIndex.getOfficerIncharge());
                dueReportResultObj.setNextDate(myFormat.format(dateFormat.parse(legalcaseDocumentIndex.getNextDate().toString())));
                finalResult.add(dueReportResultObj);
            }
        }
        return finalResult;
    }

    private BoolQueryBuilder getFilterQuery(LcDueReportResult searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        ArrayList<String> statusCodeList = new ArrayList<String>();
        statusCodeList.add("Hearing In Progress");
        statusCodeList.add("Interim Stay");
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName())).must((QueryBuilder)QueryBuilders.termsQuery((String)"status", statusCodeList));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"caseDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate())))));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getOfficerIncharge())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"officerIncharge", (String)searchRequest.getOfficerIncharge().split("@")[0]));
        }
        if (searchRequest.getLcNumber() != null) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lcNumber", (Object)searchRequest.getLcNumber()));
        }
        return boolQuery;
    }

    public List<HearingsDocument> findAllHearingsIndexByFilter(LcDueReportResult searchRequest) throws ParseException {
        BoolQueryBuilder query = this.getHearingsFilterQuery(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"hearingsdocument"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page hearingsDocumentSearchList = this.hearingsDocumentRepository.search((SearchQuery)searchQuery);
        ArrayList<HearingsDocument> hearingsDocumentList = new ArrayList<HearingsDocument>();
        for (HearingsDocument documentObj : hearingsDocumentSearchList) {
            hearingsDocumentList.add(documentObj);
        }
        return hearingsDocumentList;
    }

    private BoolQueryBuilder getHearingsFilterQuery(LcDueReportResult searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"hearingDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate())))));
        }
        return boolQuery;
    }
}

