/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.masters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.lcms.masters.entity.CourtMaster;
import org.egov.lcms.masters.service.CourtMasterService;
import org.egov.lcms.masters.service.CourtTypeMasterService;
import org.egov.lcms.web.adaptor.CourtMasterJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/courtmaster"})
public class CourtMasterController {
    private static final String COURTMASTER_NEW = "courtmaster-new";
    private static final String COURTMASTER_RESULT = "courtmaster-result";
    private static final String COURTMASTER_EDIT = "courtmaster-edit";
    private static final String COURTMASTER_VIEW = "courtmaster-view";
    private static final String COURTMASTER_SEARCH = "courtmaster-search";
    @Autowired
    private CourtMasterService courtMasterService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private CourtTypeMasterService courtTypeMasterService;

    private void prepareNewForm(Model model) {
        model.addAttribute("courtTypeMasters", (Object)this.courtTypeMasterService.getActiveCourtTypes());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("courtMaster", (Object)new CourtMaster());
        return COURTMASTER_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute CourtMaster courtMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COURTMASTER_NEW;
        }
        this.courtMasterService.persist(courtMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.courtMaster.success", null, null));
        return "redirect:/courtmaster/result/" + courtMaster.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        CourtMaster courtMaster = this.courtMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("courtMaster", (Object)courtMaster);
        return COURTMASTER_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute CourtMaster courtMaster, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return COURTMASTER_EDIT;
        }
        this.courtMasterService.persist(courtMaster);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.courtMaster.update", null, null));
        return "redirect:/courtmaster/result/" + courtMaster.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        CourtMaster courtMaster = this.courtMasterService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("courtMaster", (Object)courtMaster);
        return COURTMASTER_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        CourtMaster courtMaster = this.courtMasterService.findOne(id);
        model.addAttribute("courtMaster", (Object)courtMaster);
        return COURTMASTER_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        CourtMaster courtMaster = new CourtMaster();
        this.prepareNewForm(model);
        model.addAttribute("courtMaster", (Object)courtMaster);
        return COURTMASTER_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute CourtMaster courtMaster) {
        List searchResultList = this.courtMasterService.search(courtMaster);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(CourtMaster.class, (Object)new CourtMasterJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

