/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.es;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.LegalCaseDocument;
import org.egov.lcms.reports.entity.LegalCaseSearchResult;
import org.egov.lcms.repository.es.LegalCaseDocumentRepository;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.service.SearchLegalCaseService;
import org.egov.lcms.utils.LegalCaseUtil;
import org.egov.lcms.web.controller.transactions.GenericLegalCaseController;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/elasticsearch/legalcasesearch"})
public class SearchLegalCaseController
extends GenericLegalCaseController {
    @Autowired
    private SearchLegalCaseService searchLegalCaseService;
    @Autowired
    private LegalCaseDocumentRepository legalCaseDocumentRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @ModelAttribute
    public LegalCaseSearchResult searchRequest() {
        return new LegalCaseSearchResult();
    }

    @ModelAttribute(value="statusList")
    public List<EgwStatus> getStatusList() {
        return this.legalCaseUtil.getStatusForModule();
    }

    @ModelAttribute(value="reportStatusList")
    public List<ReportStatus> getReportStatusList() {
        return this.searchLegalCaseService.getReportStatus();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "legalcasesearch-from";
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<LegalCaseSearchResult> searchLegalcase(@ModelAttribute LegalCaseSearchResult searchRequest) throws ParseException {
        List legalcaseDocumentTempList = new ArrayList();
        ArrayList<LegalCaseSearchResult> finalResult = new ArrayList<LegalCaseSearchResult>();
        legalcaseDocumentTempList = this.findAllLegalcaseDocumentIndexByFilter(searchRequest);
        for (LegalCaseDocument legalcaseDocumentIndex : legalcaseDocumentTempList) {
            LegalCaseSearchResult legalcaseSearchResultObj = new LegalCaseSearchResult();
            legalcaseSearchResultObj.setLcNumber(legalcaseDocumentIndex.getLcNumber());
            legalcaseSearchResultObj.setCaseNumber(legalcaseDocumentIndex.getCaseNumber());
            legalcaseSearchResultObj.setCaseTitle(legalcaseDocumentIndex.getCaseTitle());
            legalcaseSearchResultObj.setCourtName(legalcaseDocumentIndex.getCourtName());
            legalcaseSearchResultObj.setStandingCouncil(legalcaseDocumentIndex.getAdvocateName());
            legalcaseSearchResultObj.setCaseStatus(legalcaseDocumentIndex.getStatus());
            legalcaseSearchResultObj.setPetName(legalcaseDocumentIndex.getPetitionerNames());
            legalcaseSearchResultObj.setResName(legalcaseDocumentIndex.getRespondantNames());
            finalResult.add(legalcaseSearchResultObj);
        }
        return finalResult;
    }

    public List<LegalCaseDocument> findAllLegalcaseDocumentIndexByFilter(LegalCaseSearchResult searchRequest) throws ParseException {
        BoolQueryBuilder query = this.getFilterQuery(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"legalcasedocument"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page legalcaseDocumentSearchList = this.legalCaseDocumentRepository.search((SearchQuery)searchQuery);
        ArrayList<LegalCaseDocument> legalcaseDocumentList = new ArrayList<LegalCaseDocument>();
        for (LegalCaseDocument documentObj : legalcaseDocumentSearchList) {
            legalcaseDocumentList.add(documentObj);
        }
        return legalcaseDocumentList;
    }

    private BoolQueryBuilder getFilterQuery(LegalCaseSearchResult searchRequest) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"caseDate").gte(newFormat.format(formatter.parse(searchRequest.getFromDate()))).lte((Object)new DateTime((Object)newFormat.format(formatter.parse(searchRequest.getToDate())))));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"caseNumber", (Object)searchRequest.getCaseNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getLcNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"lcNumber", (Object)searchRequest.getLcNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCourtName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"courtName", (Object)searchRequest.getCourtName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"caseType", (Object)searchRequest.getCaseType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCourtTypes())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"courtType", (Object)searchRequest.getCourtTypes()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getStandingCouncil())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"advocateName", (Object)searchRequest.getStandingCouncil()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCaseStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)searchRequest.getCaseStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getPetitionType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"petitionType", (Object)searchRequest.getPetitionType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getReportStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"subStatus", (Object)searchRequest.getReportStatus()));
        }
        if (searchRequest.getIsStatusExcluded() != null) {
            ArrayList<String> statusCodeList = new ArrayList<String>();
            statusCodeList.add("Judgment Implemented");
            statusCodeList.add("Closed");
            boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"status", statusCodeList));
        }
        return boolQuery;
    }
}

