/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.controller.ajax;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxEmployeePositionController {
    @Autowired
    private AssignmentService assignmentService;

    @RequestMapping(value={"/ajax/getpositionEmployee"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> getPositionForDeptAndDesig(@ModelAttribute(value="employeeBean") @RequestParam String positionName) {
        HashMap<Long, String> positionEmployeeMap = new HashMap<Long, String>();
        List assignmentList = this.assignmentService.getAllAssignmentsByPositionNameForGivenRange(positionName);
        for (Assignment assign : assignmentList) {
            String posEmpName = assign.getPosition().getName().concat("@").concat(assign.getEmployee().getUsername());
            positionEmployeeMap.put(assign.getEmployee().getId(), posEmpName);
        }
        return positionEmployeeMap;
    }

    @RequestMapping(value={"/ajax/getposition"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> getPosition(@ModelAttribute(value="employeeBean") @RequestParam String positionName) {
        HashMap<Long, String> positionEmployeeMap = new HashMap<Long, String>();
        List assignmentList = this.assignmentService.getAllAssignmentsByPositionNameForGivenRange(positionName);
        for (Assignment assign : assignmentList) {
            String posEmpName = assign.getPosition().getName().concat("@").concat(assign.getEmployee().getUsername());
            positionEmployeeMap.put(assign.getPosition().getId(), posEmpName);
        }
        return positionEmployeeMap;
    }

    @RequestMapping(value={"ajax/getemployeeNames"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<Long, String> getEmployeeForDeptAndDesig(@ModelAttribute(value="employeeBean") @RequestParam String employeeName) {
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        List assignmentList = this.assignmentService.getAllAssignmentForEmployeeNameLike(employeeName);
        for (Assignment assign : assignmentList) {
            if (assign == null) continue;
            String empName = assign.getEmployee().getName().concat("@").concat(assign.getDepartment().getName().concat("@").concat(assign.getDesignation().getName()));
            employeeMap.put(assign.getEmployee().getId(), empName);
        }
        return employeeMap;
    }
}

