/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.lcms.reports.entity.GenericSubReportResult;

public class GenericSubReportJsonAdaptor
implements JsonSerializer<GenericSubReportResult> {
    public JsonElement serialize(GenericSubReportResult genericSubResult, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("aggregatedBy", genericSubResult.getAggregatedBy() != null ? genericSubResult.getAggregatedBy() : "");
        jsonObject.addProperty("noOfCase", (Number)genericSubResult.getNoOfCase());
        if (genericSubResult.getAggregatedBy() == null && genericSubResult.getLegalCase() != null) {
            jsonObject.addProperty("casenumber", genericSubResult.getLegalCase().getCaseNumber() != null ? genericSubResult.getLegalCase().getCaseNumber() : "");
            jsonObject.addProperty("legalcaseno", genericSubResult.getLegalCase().getLcNumber());
            jsonObject.addProperty("casetitle", genericSubResult.getLegalCase().getCaseTitle());
            jsonObject.addProperty("courtname", genericSubResult.getLegalCase().getCourtMaster().getName());
            jsonObject.addProperty("petitioners", genericSubResult.getLegalCase().getPetitionersNames());
            jsonObject.addProperty("respondants", genericSubResult.getLegalCase().getRespondantNames());
            jsonObject.addProperty("standingcouncil", genericSubResult.getLegalCase().getOppPartyAdvocate() != null ? genericSubResult.getLegalCase().getOppPartyAdvocate() : "");
            jsonObject.addProperty("casestatus", genericSubResult.getCaseStatus());
            if (genericSubResult.getCaseStatus().equalsIgnoreCase("LCCREATED")) {
                jsonObject.addProperty("statusDesc", genericSubResult.getLegalCase().getReportStatus() != null ? genericSubResult.getLegalCase().getReportStatus().getName() : "");
            } else {
                jsonObject.addProperty("statusDesc", genericSubResult.getLegalCase().getStatus() != null ? genericSubResult.getLegalCase().getStatus().getDescription() : "");
            }
        }
        return jsonObject;
    }
}

