/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.lcms.reports.entity.TimeSeriesReportResult;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TimeSeriesReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<TimeSeriesReportResult> getTimeSeriesReports(TimeSeriesReportResult timeSeriesReportResults, Boolean clickOnCount) {
        StringBuilder queryStr = new StringBuilder();
        if (timeSeriesReportResults.getAggregatedBy().equals("Court Name")) {
            this.getAggregateQueryByCourtName(timeSeriesReportResults, queryStr, clickOnCount);
        }
        if (timeSeriesReportResults.getAggregatedBy().equals("Petition Type")) {
            this.getAggregateQueryByPetitionType(timeSeriesReportResults, queryStr, clickOnCount);
        }
        if (timeSeriesReportResults.getAggregatedBy().equals("Case Category")) {
            this.getAggregateQueryByCaseCategory(timeSeriesReportResults, queryStr, clickOnCount);
        }
        if (timeSeriesReportResults.getAggregatedBy().equals("Case Status")) {
            this.getAggregateQueryByCaseStatus(timeSeriesReportResults, queryStr, clickOnCount);
        }
        if (timeSeriesReportResults.getAggregatedBy().equals("Court Type")) {
            this.getAggregateQueryByCourtType(timeSeriesReportResults, queryStr, clickOnCount);
        }
        if (timeSeriesReportResults.getAggregatedBy().equals("In charge officer")) {
            this.getAggregateQueryByOfficerIncharge(timeSeriesReportResults, queryStr, clickOnCount);
        }
        if (timeSeriesReportResults.getAggregatedBy().equals("Standing Counsel")) {
            this.getAggregateQueryByStandingCounsel(timeSeriesReportResults, queryStr, clickOnCount);
        }
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParameterToQuery(timeSeriesReportResults, queryResult, clickOnCount);
        List timeSeriesReportList = queryResult.list();
        return timeSeriesReportList;
    }

    private Query setParameterToQuery(TimeSeriesReportResult timeSeriesReportObj, Query queryResult, Boolean clickOnCount) {
        if (clickOnCount.booleanValue()) {
            queryResult.setString("aggreagatedByValue", timeSeriesReportObj.getAggregatedByValue());
            if (timeSeriesReportObj.getPeriod().equals("Month")) {
                queryResult.setString("month", timeSeriesReportObj.getMonth());
            }
            queryResult.setInteger("year", timeSeriesReportObj.getYear().intValue());
        }
        if (timeSeriesReportObj.getAggregatedBy().equals("Case Status")) {
            queryResult.setString("moduleType", "Legal Case");
        }
        if (timeSeriesReportObj.getFromDate() != null) {
            queryResult.setDate("fromDate", timeSeriesReportObj.getFromDate());
        }
        if (timeSeriesReportObj.getToDate() != null) {
            queryResult.setDate("toDate", timeSeriesReportObj.getToDate());
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(TimeSeriesReportResult.class));
        return queryResult;
    }

    private void getAppendQuery(TimeSeriesReportResult timeSeriesReportObj, StringBuilder queryStr) {
        if (timeSeriesReportObj.getFromDate() != null) {
            queryStr.append("  legalcase.caseDate >=:fromDate and ");
        }
        if (timeSeriesReportObj.getToDate() != null) {
            queryStr.append("  legalcase.caseDate <=:toDate ");
        }
    }

    private void getAggregateQueryByCourtName(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as count ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(" ,courtmaster.name  as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase,CourtMaster courtmaster ");
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase.courtMaster.name=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by courtmaster.name,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by courtmaster.name ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }

    private void getAggregateQueryByPetitionType(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as count");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",petmaster.petitionType  as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase,PetitionTypeMaster petmaster ");
        queryStr.append("where legalcase.petitionTypeMaster.id=petmaster.id and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase.petitionTypeMaster.petitionType=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by petmaster.petitionType");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" ,to_char(legalcase.caseDate,'Mon') ,");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by petmaster.petitionType ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }

    private void getAggregateQueryByCaseCategory(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as count ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",casetypemaster.caseType  as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase,CaseTypeMaster casetypemaster ");
        queryStr.append(" where legalcase.caseTypeMaster.id=casetypemaster.id and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase.caseTypeMaster.caseType=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by casetypemaster.caseType,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by casetypemaster.caseType ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }

    private void getAggregateQueryByCaseStatus(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as count ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",egwStatus.description  as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase,EgwStatus egwStatus  where legalcase.status.id=egwStatus.id and egwStatus.moduletype =:moduleType and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" egwStatus.description=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by egwStatus.description,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by egwStatus.description ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }

    private void getAggregateQueryByCourtType(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as count ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",courtmaster.courtType.courtType  as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase,CourtMaster courtmaster ");
        queryStr.append(" where legalcase.courtMaster.id=courtmaster.id  and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase.courtMaster.courtType.courtType=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by courtmaster.courtType.courtType,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by courtmaster.courtType.courtType ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }

    private void getAggregateQueryByOfficerIncharge(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append("SELECT COUNT(DISTINCT legalcase.id) as count ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",position.name as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase,Position position where legalcase.officerIncharge=position.id and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" position.name=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by position.name,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by position.name ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }

    private void getAggregateQueryByStandingCounsel(TimeSeriesReportResult timeSeriesReportResults, StringBuilder queryStr, Boolean clickOnCount) {
        if (!clickOnCount.booleanValue()) {
            queryStr.append(" SELECT COUNT(DISTINCT legalcase.id) as count ");
        } else {
            queryStr.append("select distinct legalcase  as  legalCase ");
        }
        queryStr.append(",advocate.name as aggregatedBy,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon') as month,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) as year ");
        queryStr.append(" from LegalCase legalcase ,LegalCaseAdvocate legalCaseAdvocates ,AdvocateMaster advocate ");
        queryStr.append("where legalcase.id=legalCaseAdvocates.legalCase ");
        queryStr.append(" and advocate.isActive='true' and ");
        if (clickOnCount.booleanValue()) {
            queryStr.append(" advocate.name=:aggreagatedByValue ");
            if (timeSeriesReportResults.getPeriod().equals("Month")) {
                queryStr.append(" and to_char(legalcase.caseDate,'Mon')=:month ");
            }
            queryStr.append(" and extract(year from legalcase.caseDate)=:year ");
        }
        this.getAppendQuery(timeSeriesReportResults, queryStr);
        queryStr.append(" group by advocate.name,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        if (clickOnCount.booleanValue()) {
            queryStr.append(" legalcase,");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
        queryStr.append(" order by advocate.name ,");
        if (timeSeriesReportResults.getPeriod().equals("Month")) {
            queryStr.append(" to_char(legalcase.caseDate,'Mon'), ");
        }
        queryStr.append(" extract(year from legalcase.caseDate) ");
    }
}

