/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.lcms.reports.entity.LegalCaseSearchResult;
import org.egov.lcms.transactions.entity.ReportStatus;
import org.egov.lcms.transactions.repository.ReportStatusRepository;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SearchLegalCaseService {
    @Autowired
    private ReportStatusRepository reportStatusRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<LegalCaseSearchResult> getLegalCaseReport(LegalCaseSearchResult legalCaseSearchResultObj) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct legalObj  as  legalCase ,courtmaster.name  as  courtName ,");
        queryStr.append(" egwStatus.code  as  caseStatus ");
        queryStr.append(" from LegalCase legalObj,CourtMaster courtmaster,CaseTypeMaster casetypemaster,");
        queryStr.append(" PetitionTypeMaster petmaster,EgwStatus egwStatus,ReportStatus reportStatus");
        queryStr.append(" where legalObj.courtMaster.id=courtmaster.id and ");
        queryStr.append(" legalObj.caseTypeMaster.id=casetypemaster.id and legalObj.petitionTypeMaster.id=petmaster.id and ");
        queryStr.append(" legalObj.status.id=egwStatus.id and egwStatus.moduletype =:moduleType ");
        if (legalCaseSearchResultObj.getReportStatusId() != null) {
            queryStr.append("  and legalObj.reportStatus.id = reportStatus.id ");
        }
        this.getAppendQuery(legalCaseSearchResultObj, queryStr);
        Query queryResult = this.getCurrentSession().createQuery(queryStr.toString());
        queryResult = this.setParametersToQuery(legalCaseSearchResultObj, queryResult);
        List legalcaseSearchList = queryResult.list();
        return legalcaseSearchList;
    }

    private Query setParametersToQuery(LegalCaseSearchResult legalCaseSearchResultObj, Query queryResult) {
        queryResult.setString("moduleType", "Legal Case");
        if (StringUtils.isNotBlank((String)legalCaseSearchResultObj.getLcNumber())) {
            queryResult.setString("lcNumber", legalCaseSearchResultObj.getLcNumber());
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultObj.getCaseNumber())) {
            queryResult.setString("caseNumber", legalCaseSearchResultObj.getCaseNumber() + "%");
        }
        if (legalCaseSearchResultObj.getCourtId() != null) {
            queryResult.setInteger("court", legalCaseSearchResultObj.getCourtId().intValue());
        }
        if (legalCaseSearchResultObj.getCasecategory() != null) {
            queryResult.setInteger("casetype", legalCaseSearchResultObj.getCasecategory().intValue());
        }
        if (legalCaseSearchResultObj.getCourtType() != null) {
            queryResult.setInteger("courttype", legalCaseSearchResultObj.getCourtType().intValue());
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultObj.getStandingCouncil())) {
            queryResult.setString("standingcoouncil", legalCaseSearchResultObj.getStandingCouncil() + "%");
        }
        if (legalCaseSearchResultObj.getStatusId() != null) {
            queryResult.setInteger("status", legalCaseSearchResultObj.getStatusId().intValue());
        }
        if (legalCaseSearchResultObj.getCaseFromDate() != null) {
            queryResult.setDate("fromdate", legalCaseSearchResultObj.getCaseFromDate());
        }
        if (legalCaseSearchResultObj.getCaseToDate() != null) {
            queryResult.setDate("toDate", legalCaseSearchResultObj.getCaseToDate());
        }
        if (legalCaseSearchResultObj.getPetitionTypeId() != null) {
            queryResult.setInteger("petiontionType", legalCaseSearchResultObj.getPetitionTypeId().intValue());
        }
        if (legalCaseSearchResultObj.getReportStatusId() != null) {
            queryResult.setInteger("reportStatus", legalCaseSearchResultObj.getReportStatusId().intValue());
        }
        if (legalCaseSearchResultObj.getIsStatusExcluded() != null) {
            ArrayList<String> statusCodeList = new ArrayList<String>();
            statusCodeList.add("CLOSED");
            statusCodeList.add("JUDGEMENT_IMPL");
            queryResult.setParameterList("statusCodeList", statusCodeList);
        }
        queryResult.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(LegalCaseSearchResult.class));
        return queryResult;
    }

    private void getAppendQuery(LegalCaseSearchResult legalCaseSearchResultOblj, StringBuilder queryStr) {
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getLcNumber())) {
            queryStr.append(" and legalObj.lcNumber =:lcNumber");
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getCaseNumber())) {
            queryStr.append(" and legalObj.caseNumber like :caseNumber ");
        }
        if (legalCaseSearchResultOblj.getCourtId() != null) {
            queryStr.append(" and courtmaster.id =:court ");
        }
        if (legalCaseSearchResultOblj.getCasecategory() != null) {
            queryStr.append(" and casetypemaster.id =:casetype");
        }
        if (legalCaseSearchResultOblj.getCourtType() != null) {
            queryStr.append(" and courtmaster.id =:courttype ");
        }
        if (StringUtils.isNotBlank((String)legalCaseSearchResultOblj.getStandingCouncil())) {
            queryStr.append(" and legalObj.oppPartyAdvocate like :standingcoouncil ");
        }
        if (legalCaseSearchResultOblj.getStatusId() != null) {
            queryStr.append(" and egwStatus.id =:status ");
        }
        if (legalCaseSearchResultOblj.getCaseFromDate() != null) {
            queryStr.append(" and legalObj.caseDate >=:fromdate ");
        }
        if (legalCaseSearchResultOblj.getCaseToDate() != null) {
            queryStr.append(" and legalObj.caseDate <=:toDate ");
        }
        if (legalCaseSearchResultOblj.getPetitionTypeId() != null) {
            queryStr.append(" and petmaster.id =:petiontionType ");
        }
        if (legalCaseSearchResultOblj.getIsStatusExcluded() != null) {
            queryStr.append(" and egwStatus.code not in (:statusCodeList ) ");
        }
        if (legalCaseSearchResultOblj.getReportStatusId() != null) {
            queryStr.append(" and reportStatus.id =:reportStatus ");
        }
    }

    public List<ReportStatus> getReportStatus() {
        List reportStatusList = this.reportStatusRepository.findAll();
        return reportStatusList;
    }
}

