/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.entity.Employee;
import org.egov.lcms.masters.entity.enums.JudgmentImplIsComplied;
import org.egov.lcms.transactions.entity.CounterAffidavit;
import org.egov.lcms.transactions.entity.EmployeeHearing;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.entity.LegalCaseDisposal;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.utils.LegalCaseUtil;
import org.egov.lcms.utils.constants.LcmsConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class LegalCaseSmsService {
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource messageSource;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    public void sendSmsToOfficerInchargeForLegalCase(LegalCase legalcase) {
        if (legalcase.getOfficerIncharge() != null && legalcase.getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(legalcase);
            if ("LCCREATED".equalsIgnoreCase(legalcase.getStatus().getCode())) {
                this.getSmsForLegalCase(legalcase, mobileNumber);
            }
        }
    }

    public void getSmsForLegalCase(LegalCase legalcase, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeForLegalcase("msg.createlegalcase.sms", legalcase);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForLegalcase(String code, LegalCase legalcase) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(legalcase), legalcase.getCaseNumber(), legalcase.getPetitionersNames(), legalcase.getRespondantNames()}, null);
        return smsMsg;
    }

    public void sendSmsToHearingEmployee(Hearings hearings) {
        if (hearings.getTempEmplyeeHearing() != null && !hearings.getTempEmplyeeHearing().isEmpty()) {
            for (EmployeeHearing hearingEmp : hearings.getTempEmplyeeHearing()) {
                this.getSmsForHearingsEmployee(hearings, hearingEmp.getEmployee());
            }
        }
    }

    public void getSmsForHearingsEmployee(Hearings hearings, Employee employee) {
        String mobileNo = employee.getMobileNumber();
        if ("HEARING".equalsIgnoreCase(hearings.getLegalCase().getStatus().getCode())) {
            String smsMsg = this.smsBodyByCodeAndArgsWithTypeForHearingsEmployee("msg.hearingemployee.sms", hearings, employee);
            if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
                this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
            }
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForHearingsEmployee(String code, Hearings hearings, Employee employee) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{employee.getName(), hearings.getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(hearings.getHearingDate()).toString(), hearings.getPurposeofHearings()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeInterimOrder(LegalCaseInterimOrder legalCaseInterimOrder) {
        if (legalCaseInterimOrder.getLegalCase().getOfficerIncharge() != null && legalCaseInterimOrder.getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(legalCaseInterimOrder.getLegalCase());
            if ("INTERIM_STAY".equalsIgnoreCase(legalCaseInterimOrder.getLegalCase().getStatus().getCode())) {
                this.getSmsForInterimOrder(legalCaseInterimOrder, mobileNumber);
            }
        }
    }

    public void getSmsForInterimOrder(LegalCaseInterimOrder legalCaseInterimOrder, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeForInterimOrder("msg.interimorder.sms", legalCaseInterimOrder);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForInterimOrder(String code, LegalCaseInterimOrder legalCaseInterimOrder) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(legalCaseInterimOrder.getLegalCase()), legalCaseInterimOrder.getLegalCase().getCaseNumber(), legalCaseInterimOrder.getInterimOrder().getInterimOrderType(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(legalCaseInterimOrder.getIoDate()).toString()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeForHearings(Hearings hearings) {
        if (hearings.getLegalCase().getOfficerIncharge() != null && hearings.getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(hearings.getLegalCase());
            if ("HEARING".equalsIgnoreCase(hearings.getLegalCase().getStatus().getCode())) {
                this.getSmsForHearings(hearings, mobileNumber);
            }
        }
    }

    public void getSmsForHearings(Hearings hearings, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeForHearings("msg.hearing.sms", hearings);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForHearings(String code, Hearings hearings) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(hearings.getLegalCase()), hearings.getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(hearings.getHearingDate()).toString(), hearings.getPurposeofHearings()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeForJudgment(Judgment judgment) {
        if (judgment.getLegalCase().getOfficerIncharge() != null && judgment.getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(judgment.getLegalCase());
            if ("JUDGMENT".equalsIgnoreCase(judgment.getLegalCase().getStatus().getCode())) {
                this.getSmsForJudgment(judgment, mobileNumber);
            }
        }
    }

    public void getSmsForJudgment(Judgment judgment, String mobileNo) {
        String smsMsg = "";
        smsMsg = judgment.getImplementByDate() != null ? this.smsBodyByCodeAndArgsWithTypeForJudgmentWithImplementDate("msg.judgmentwithimplementdate.sms", judgment) : this.smsBodyByCodeAndArgsWithTypeForJudgmentWithoutImplementDate("msg.judgmentwithoutimplementDate.sms", judgment);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForJudgmentWithImplementDate(String code, Judgment judgment) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(judgment.getLegalCase()), judgment.getLegalCase().getCaseNumber(), judgment.getJudgmentType().getName(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(judgment.getImplementByDate()).toString()}, null);
        return smsMsg;
    }

    public String smsBodyByCodeAndArgsWithTypeForJudgmentWithoutImplementDate(String code, Judgment judgment) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(judgment.getLegalCase()), judgment.getLegalCase().getCaseNumber(), judgment.getJudgmentType().getName()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeForJudgmentImpl(JudgmentImpl judgmentImpl) {
        if (judgmentImpl.getJudgment().getLegalCase().getOfficerIncharge() != null && judgmentImpl.getJudgment().getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(judgmentImpl.getJudgment().getLegalCase());
            if ("JUDGEMENT_IMPL".equalsIgnoreCase(judgmentImpl.getJudgment().getLegalCase().getStatus().getCode())) {
                this.getSmsForJudgmentImpl(judgmentImpl, mobileNumber);
            }
        }
    }

    public void getSmsForJudgmentImpl(JudgmentImpl judgmentImpl, String mobileNo) {
        String smsMsg = "";
        if (judgmentImpl.getJudgmentImplIsComplied().toString().equals(JudgmentImplIsComplied.YES.toString())) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeForJudgmentImplIsCompliedYes("msg.judgmentimpliscompliedyes.sms", judgmentImpl);
        } else if (judgmentImpl.getJudgmentImplIsComplied().toString().equals(JudgmentImplIsComplied.NO.toString())) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeForJudgmentImplIsCompliedNo("msg.judgmentimpliscompliedno.sms", judgmentImpl);
        }
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForJudgmentImplIsCompliedYes(String code, JudgmentImpl judgmentImpl) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(judgmentImpl.getJudgment().getLegalCase()), judgmentImpl.getJudgment().getLegalCase().getCaseNumber(), judgmentImpl.getJudgmentImplIsComplied().toString(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(judgmentImpl.getDateOfCompliance()).toString()}, null);
        return smsMsg;
    }

    public String smsBodyByCodeAndArgsWithTypeForJudgmentImplIsCompliedNo(String code, JudgmentImpl judgmentImpl) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(judgmentImpl.getJudgment().getLegalCase()), judgmentImpl.getJudgment().getLegalCase().getCaseNumber(), judgmentImpl.getJudgmentImplIsComplied().toString(), judgmentImpl.getImplementationFailure().toString()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeForCloseCase(LegalCaseDisposal legalCaseDisposal) {
        if (legalCaseDisposal.getLegalCase().getOfficerIncharge() != null && legalCaseDisposal.getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(legalCaseDisposal.getLegalCase());
            if ("CLOSED".equalsIgnoreCase(legalCaseDisposal.getLegalCase().getStatus().getCode())) {
                this.getSmsForCloseCase(legalCaseDisposal, mobileNumber);
            }
        }
    }

    public void getSmsForCloseCase(LegalCaseDisposal legalCaseDisposal, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeForCloseCase("msg.closecase.sms", legalCaseDisposal);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForCloseCase(String code, LegalCaseDisposal legalCaseDisposal) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(legalCaseDisposal.getLegalCase()), legalCaseDisposal.getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(legalCaseDisposal.getDisposalDate()).toString()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeForCounterAffidavit(List<CounterAffidavit> counterAffidavit) {
        if (counterAffidavit.get(0).getLegalCase().getOfficerIncharge() != null && counterAffidavit.get(0).getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(counterAffidavit.get(0).getLegalCase());
            this.getSmsForCounterAffidavit(counterAffidavit, mobileNumber);
        }
    }

    public void getSmsForCounterAffidavit(List<CounterAffidavit> counterAffidavit, String mobileNo) {
        String smsMsg = "";
        if (counterAffidavit.get(0).getCounterAffidavitDueDate() != null) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeForCounterAffidavitwithSubmissionDate("msg.counteraffidavitsubmissiondate.sms", counterAffidavit);
        }
        if (counterAffidavit.get(0).getCounterAffidavitApprovalDate() != null) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeForCounterAffidavitwithApprovalDate("msg.counteraffidavitapprovaldate.sms", counterAffidavit);
        }
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForCounterAffidavitwithSubmissionDate(String code, List<CounterAffidavit> counterAffidavit) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(counterAffidavit.get(0).getLegalCase()), counterAffidavit.get(0).getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(counterAffidavit.get(0).getCounterAffidavitDueDate()).toString()}, null);
        return smsMsg;
    }

    public String smsBodyByCodeAndArgsWithTypeForCounterAffidavitwithApprovalDate(String code, List<CounterAffidavit> counterAffidavit) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(counterAffidavit.get(0).getLegalCase()), counterAffidavit.get(0).getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(counterAffidavit.get(0).getCounterAffidavitApprovalDate()).toString()}, null);
        return smsMsg;
    }

    public void sendSmsToOfficerInchargeForPWR(List<Pwr> pwr) {
        if (pwr.get(0).getLegalCase().getOfficerIncharge() != null && pwr.get(0).getLegalCase().getOfficerIncharge().getName() != null) {
            String mobileNumber = this.legalCaseUtil.getOfficerInchargeMobileNumber(pwr.get(0).getLegalCase());
            this.getSmsForPWR(pwr, mobileNumber);
        }
    }

    public void getSmsForPWR(List<Pwr> pwr, String mobileNo) {
        String smsMsg = "";
        if (pwr.get(0).getPwrDueDate() != null) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeForPwrWithSubmissionDate("msg.pwrwithsubmissiondate.sms", pwr);
        }
        if (pwr.get(0).getPwrApprovalDate() != null) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeForPwrwithApprovalDate("msg.pwrwithapprovaldate.sms", pwr);
        }
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForPwrWithSubmissionDate(String code, List<Pwr> pwr) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(pwr.get(0).getLegalCase()), pwr.get(0).getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(pwr.get(0).getPwrDueDate()).toString()}, null);
        return smsMsg;
    }

    public String smsBodyByCodeAndArgsWithTypeForPwrwithApprovalDate(String code, List<Pwr> pwr) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{this.legalCaseUtil.getOfficerInchargeName(pwr.get(0).getLegalCase()), pwr.get(0).getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(pwr.get(0).getPwrApprovalDate()).toString()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounsel(LegalCaseAdvocate legalCaseAdvocate) {
        if (legalCaseAdvocate.getAdvocateMaster() != null && legalCaseAdvocate.getAdvocateMaster().getName() != null) {
            String mobileNumber = legalCaseAdvocate.getAdvocateMaster().getMobileNumber();
            this.getSmsForStandingCounsel(legalCaseAdvocate, mobileNumber);
        }
    }

    public void getSmsForStandingCounsel(LegalCaseAdvocate legalCaseAdvocate, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeForStandingCounsel("msg.standingcounsel.sms", legalCaseAdvocate);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForStandingCounsel(String code, LegalCaseAdvocate legalCaseAdvocate) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{legalCaseAdvocate.getAdvocateMaster().getName(), legalCaseAdvocate.getLegalCase().getCaseNumber(), legalCaseAdvocate.getLegalCase().getPetitionersNames(), legalCaseAdvocate.getLegalCase().getRespondantNames()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounselForHearings(Hearings hearings) {
        if (hearings.getLegalCase().getLegalCaseAdvocates() != null && !hearings.getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            String mobileNumber = hearings.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getMobileNumber();
            this.getSmsForStandingCounselForHearings(hearings, mobileNumber);
        }
    }

    public void getSmsForStandingCounselForHearings(Hearings hearings, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeForStandingCounselForHearings("msg.standingcounselforhearings.sms", hearings);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeForStandingCounselForHearings(String code, Hearings hearings) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{hearings.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), hearings.getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(hearings.getHearingDate()).toString(), hearings.getPurposeofHearings()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounselForInterimOrder(LegalCaseInterimOrder legalCaseInterimOrder) {
        if (legalCaseInterimOrder.getLegalCase().getLegalCaseAdvocates() != null && !legalCaseInterimOrder.getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            String mobileNumber = legalCaseInterimOrder.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getMobileNumber();
            this.getSmsToStandingCounselForInterimOrder(legalCaseInterimOrder, mobileNumber);
        }
    }

    public void getSmsToStandingCounselForInterimOrder(LegalCaseInterimOrder legalCaseInterimOrder, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeToStandingCounselForInterimOrder("msg.standingcounselforinterimorder.sms", legalCaseInterimOrder);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForInterimOrder(String code, LegalCaseInterimOrder legalCaseInterimOrder) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{legalCaseInterimOrder.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), legalCaseInterimOrder.getLegalCase().getCaseNumber(), legalCaseInterimOrder.getInterimOrder().getInterimOrderType(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(legalCaseInterimOrder.getIoDate()).toString()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounselForJudgment(Judgment judgment) {
        if (judgment.getLegalCase().getLegalCaseAdvocates() != null && !judgment.getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            String mobileNumber = judgment.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getMobileNumber();
            this.getSmsToStandingCounselForJudgment(judgment, mobileNumber);
        }
    }

    public void getSmsToStandingCounselForJudgment(Judgment judgment, String mobileNo) {
        String smsMsg = "";
        smsMsg = judgment.getImplementByDate() != null ? this.smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentWithImplementDate("msg.standingcounselforjudgmentwithimplementdate.sms", judgment) : this.smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentWithoutImplementDate("msg.standingcounselforjudgmentwithoutimplementdate.sms", judgment);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentWithImplementDate(String code, Judgment judgment) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{judgment.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), judgment.getLegalCase().getCaseNumber(), judgment.getJudgmentType().getName(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(judgment.getImplementByDate()).toString()}, null);
        return smsMsg;
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentWithoutImplementDate(String code, Judgment judgment) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{judgment.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), judgment.getLegalCase().getCaseNumber(), judgment.getJudgmentType().getName()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounselForJudgmentImpl(JudgmentImpl judgmentImpl) {
        if (judgmentImpl.getJudgment().getLegalCase().getLegalCaseAdvocates() != null && !judgmentImpl.getJudgment().getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            String mobileNumber = judgmentImpl.getJudgment().getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getMobileNumber();
            this.getSmsToStandingCounselForJudgmentImpl(judgmentImpl, mobileNumber);
        }
    }

    public void getSmsToStandingCounselForJudgmentImpl(JudgmentImpl judgmentImpl, String mobileNo) {
        String smsMsg = "";
        if (judgmentImpl.getJudgmentImplIsComplied().toString().equals(JudgmentImplIsComplied.YES.toString())) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentImplIsCompliedYes("msg.standingcounselforjudgmentimpliscompliedyes.sms", judgmentImpl);
        } else if (judgmentImpl.getJudgmentImplIsComplied().toString().equals(JudgmentImplIsComplied.NO.toString())) {
            smsMsg = this.smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentImplIsCompliedNo("msg.standingcounseljudgmentimpliscompliedno.sms", judgmentImpl);
        }
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentImplIsCompliedYes(String code, JudgmentImpl judgmentImpl) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{judgmentImpl.getJudgment().getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), judgmentImpl.getJudgment().getLegalCase().getCaseNumber(), judgmentImpl.getJudgmentImplIsComplied().toString(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(judgmentImpl.getDateOfCompliance()).toString()}, null);
        return smsMsg;
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForJudgmentImplIsCompliedNo(String code, JudgmentImpl judgmentImpl) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{judgmentImpl.getJudgment().getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), judgmentImpl.getJudgment().getLegalCase().getCaseNumber(), judgmentImpl.getJudgmentImplIsComplied().toString(), judgmentImpl.getImplementationFailure().toString()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounselForCloseCase(LegalCaseDisposal legalCaseDisposal) {
        if (legalCaseDisposal.getLegalCase().getLegalCaseAdvocates() != null && !legalCaseDisposal.getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            String mobileNumber = legalCaseDisposal.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getMobileNumber();
            this.getSmsToStandingCounselForCloseCase(legalCaseDisposal, mobileNumber);
        }
    }

    public void getSmsToStandingCounselForCloseCase(LegalCaseDisposal legalCaseDisposal, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeToStandingCounselForCloseCase("msg.standingcounselforclosecase.sms", legalCaseDisposal);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForCloseCase(String code, LegalCaseDisposal legalCaseDisposal) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{legalCaseDisposal.getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), legalCaseDisposal.getLegalCase().getCaseNumber(), LcmsConstants.DATEFORMATTER_DD_MM_YYYY.format(legalCaseDisposal.getDisposalDate()).toString()}, null);
        return smsMsg;
    }

    public void sendSmsToStandingCounselForCounterAffidavit(List<CounterAffidavit> counterAffidavit) {
        if (counterAffidavit.get(0).getLegalCase().getLegalCaseAdvocates() != null && !counterAffidavit.get(0).getLegalCase().getLegalCaseAdvocates().isEmpty()) {
            String mobileNumber = counterAffidavit.get(0).getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getMobileNumber();
            this.getSmsToStandingCounselForCA(counterAffidavit, mobileNumber);
        }
    }

    public void getSmsToStandingCounselForCA(List<CounterAffidavit> counterAffidavit, String mobileNo) {
        String smsMsg = this.smsBodyByCodeAndArgsWithTypeToStandingCounselForCA("msg.standingcounseltoca.sms", counterAffidavit);
        if (StringUtils.isNotBlank((String)mobileNo) && StringUtils.isNotBlank((String)smsMsg)) {
            this.legalCaseUtil.sendSMSOnLegalCase(mobileNo, smsMsg);
        }
    }

    public String smsBodyByCodeAndArgsWithTypeToStandingCounselForCA(String code, List<CounterAffidavit> counterAffidavit) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{counterAffidavit.get(0).getLegalCase().getLegalCaseAdvocates().get(0).getAdvocateMaster().getName(), counterAffidavit.get(0).getLegalCase().getCaseNumber()}, null);
        return smsMsg;
    }
}

