/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.Reminder;
import org.egov.pims.commons.Position;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;

@Entity
@Table(name="EGLC_LEGALCASE_DEPT")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASE_DEPT", sequenceName="SEQ_EGLC_LEGALCASE_DEPT", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class LegalCaseDepartment
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LEGALCASE_DEPT = "SEQ_EGLC_LEGALCASE_DEPT";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASE_DEPT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @NotNull
    @JoinColumn(name="legalcase", nullable=false)
    @Audited
    private LegalCase legalCase;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dateofreceiptofpwr")
    @Audited
    private Date dateofreceiptofpwr;
    @ManyToOne
    @NotNull
    @JoinColumn(name="DEPARTMENT")
    @NotAudited
    private Department department;
    @ManyToOne
    @NotNull
    @JoinColumn(name="POSITION")
    @NotAudited
    private Position position;
    @Column(name="isprimarydepartment")
    @Audited
    private boolean isPrimaryDepartment;
    @OneToMany(mappedBy="legalCaseDepartment", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotAudited
    private List<Reminder> legalCaseReminders = new ArrayList<Reminder>(0);
    @Temporal(value=TemporalType.DATE)
    @Audited
    private Date assignOn;

    public boolean getIsPrimaryDepartment() {
        return this.isPrimaryDepartment;
    }

    public void setIsPrimaryDepartment(boolean isPrimaryDepartment) {
        this.isPrimaryDepartment = isPrimaryDepartment;
    }

    public void setPrimaryDepartment(boolean isPrimaryDepartment) {
        this.isPrimaryDepartment = isPrimaryDepartment;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getLegalCase() != null && !DateUtils.compareDates((Date)this.getDateofreceiptofpwr(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("dateOfReceipt", "dateOfReceipt.less.casedate"));
        }
        if (this.legalCase != null && !DateUtils.compareDates((Date)this.getAssignOn(), (Date)this.legalCase.getCaseDate())) {
            errors.add(new ValidationError("assignOnDate", "assignOn.less.casedate"));
        }
        return errors;
    }

    public Date getDateofreceiptofpwr() {
        return this.dateofreceiptofpwr;
    }

    public void setDateofreceiptofpwr(Date dateofreceiptofpwr) {
        this.dateofreceiptofpwr = dateofreceiptofpwr;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public void addReminder(Reminder reminder) {
        this.getLegalCaseReminders().add(reminder);
    }

    public void removeReminder(Reminder reminder) {
        this.getLegalCaseReminders().remove((Object)reminder);
    }

    public Date getAssignOn() {
        return this.assignOn;
    }

    public void setAssignOn(Date assignOn) {
        this.assignOn = assignOn;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public List<Reminder> getLegalCaseReminders() {
        return this.legalCaseReminders;
    }

    public void setLegalCaseReminders(List<Reminder> legalCaseReminders) {
        this.legalCaseReminders = legalCaseReminders;
    }
}

