/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.service.es;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.lcms.entity.es.HearingsDocument;
import org.egov.lcms.repository.es.HearingsDocumentRepository;
import org.egov.lcms.transactions.entity.Hearings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class HearingsDocumentService {
    private final HearingsDocumentRepository hearingsDocumentRepository;
    @Autowired
    private CityService cityService;

    @Autowired
    public HearingsDocumentService(HearingsDocumentRepository hearingsDocumentRepository) {
        this.hearingsDocumentRepository = hearingsDocumentRepository;
    }

    public HearingsDocument persistHearingsDocumentIndex(Hearings hearings) throws ParseException {
        Map cityInfo = this.cityService.cityDataAsMap();
        HearingsDocument hearingsDocument = null;
        if (hearings.getId() != null) {
            hearingsDocument = (HearingsDocument)this.hearingsDocumentRepository.findOne((Serializable)((Object)(ApplicationThreadLocals.getCityCode() + "_" + hearings.getId())));
        }
        if (hearingsDocument != null) {
            this.updateHearingsIndex(hearingsDocument, hearings);
        } else {
            hearingsDocument = HearingsDocument.builder().withLcNumber(hearings.getLegalCase().getLcNumber()).withHearingDate(hearings.getHearingDate()).withHearingOutcome(hearings.getHearingOutcome() != null ? hearings.getHearingOutcome() : "").withPurposeOfHearing(hearings.getPurposeofHearings()).withAdditionalLawyer(hearings.getAdditionalLawyers() != null ? hearings.getAdditionalLawyers() : "").withEmployeeNames(hearings.getTempEmplyeeHearing() != null ? hearings.getEmployeeHearing() : "").withStandingCounselPresent(hearings.getIsStandingCounselPresent()).withCityName(ApplicationThreadLocals.getCityName()).withCityCode(ApplicationThreadLocals.getCityCode()).withId(ApplicationThreadLocals.getCityCode().concat("_").concat(String.valueOf(hearings.getId()))).withCityGrade(StringUtils.defaultString((String)((String)cityInfo.get("cityGrade")))).withRegionName(StringUtils.defaultString((String)((String)cityInfo.get("cityRegion")))).withDistrictName(StringUtils.defaultString((String)((String)cityInfo.get("districtName")))).withCreatedDate(hearings.getHearingDate()).build();
            this.createHearingsDocument(hearingsDocument);
        }
        return hearingsDocument;
    }

    public HearingsDocument updateHearingsIndex(HearingsDocument hearingsDocument, Hearings hearings) throws ParseException {
        hearingsDocument.setHearingDate(hearings.getHearingDate());
        hearingsDocument.setPurposeOfHearing(hearings.getPurposeofHearings());
        hearingsDocument.setHearingOutcome(hearings.getHearingOutcome());
        hearingsDocument.setAdditionalLawyer(hearings.getAdditionalLawyers());
        hearingsDocument.setEmployeeNames(hearings.getTempEmplyeeHearing() != null ? hearings.getEmployeeHearing() : "");
        hearingsDocument.setStandingCounselPresent(hearings.getIsStandingCounselPresent());
        this.createHearingsDocument(hearingsDocument);
        return hearingsDocument;
    }

    @Transactional
    public HearingsDocument createHearingsDocument(HearingsDocument hearingsIndex) {
        this.hearingsDocumentRepository.save(hearingsIndex);
        return hearingsIndex;
    }
}

