/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.service.AdvocateMasterService;
import org.egov.lcms.transactions.entity.BipartisanDetails;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.LegalCaseAdvocate;
import org.egov.lcms.transactions.entity.LegalCaseDepartment;
import org.egov.lcms.transactions.entity.LegalCaseDocuments;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.lcms.transactions.entity.PwrDocuments;
import org.egov.lcms.transactions.repository.BipartisanDetailsRepository;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LegalCaseService {
    private final LegalCaseRepository legalCaseRepository;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AdvocateMasterService advocateMasterService;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private BipartisanDetailsRepository bipartisanDetailsRepository;

    @Autowired
    public LegalCaseService(LegalCaseRepository legalCaseRepository) {
        this.legalCaseRepository = legalCaseRepository;
    }

    public LegalCase findById(Long Id2) {
        return (LegalCase)((Object)this.legalCaseRepository.findOne(Id2));
    }

    public LegalCase findByLcNumber(String lcnumber) {
        return this.legalCaseRepository.findByLcNumber(lcnumber);
    }

    public LegalCase getLegalCaseByCaseNumber(String caseNumber) {
        return this.legalCaseRepository.findByCaseNumber(caseNumber);
    }

    @Transactional
    public LegalCase persist(LegalCase legalcase) {
        legalcase.setCaseNumber(legalcase.getCaseNumber() + (legalcase.getWpYear() != null ? "/" + legalcase.getWpYear() : ""));
        legalcase.setStatus(this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "LCCREATED"));
        List<LegalCaseDocuments> legalDoc = this.legalCaseRepository.getLegalCaseDocumentList(legalcase.getId());
        this.prepareChildEntities(legalcase);
        this.processAndStoreApplicationDocuments(legalcase, legalDoc);
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    @Transactional
    public LegalCase update(LegalCase legalcase) {
        this.updateLegalCaseDeptAndPwr(legalcase, legalcase.getEglcPwrs(), legalcase.getLegalCaseDepartment());
        List<PwrDocuments> legalDoc = null;
        if (!legalcase.getEglcPwrs().isEmpty()) {
            legalDoc = this.legalCaseRepository.getPwrDocumentList(legalcase.getEglcPwrs().get(0).getId());
        }
        this.processAndStorePwrDocuments(legalcase, legalDoc);
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalcase));
    }

    @Transactional
    public void updateLegalCaseDeptAndPwr(LegalCase legalcase, List<Pwr> pwrList, List<LegalCaseDepartment> legalDept) {
        ArrayList<LegalCaseDepartment> legalcaseDetails = new ArrayList<LegalCaseDepartment>();
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>();
        for (Pwr legalpwr : pwrList) {
            legalpwr.setLegalCase(legalcase);
            legalpwr.setCaFilingdate(new Date());
            pwrListtemp.add(legalpwr);
        }
        legalcase.getEglcPwrs().clear();
        legalcase.setEglcPwrs(pwrListtemp);
        for (LegalCaseDepartment legaldeptObj : legalDept) {
            legaldeptObj.setLegalCase(legalcase);
            legaldeptObj.setPosition(this.positionMasterService.getPositionByName(legaldeptObj.getPosition().getName()));
            legaldeptObj.setDepartment(this.departmentService.getDepartmentByName(legaldeptObj.getDepartment().getName()));
            legalcaseDetails.add(legaldeptObj);
        }
        legalcase.getLegalCaseDepartment().clear();
        legalcase.setLegalCaseDepartment(legalcaseDetails);
    }

    public List<LegalCaseDocuments> getLegalCaseDocList(LegalCase legalCase) {
        ArrayList<LegalCaseDocuments> legalDOc = null;
        HashSet<LegalCaseDocuments> legalDOcSet = new HashSet<LegalCaseDocuments>();
        for (LegalCaseDocuments legalDoc : legalCase.getLegalCaseDocuments()) {
            legalDOcSet.add(legalDoc);
        }
        legalDOc = new ArrayList<LegalCaseDocuments>(legalDOcSet);
        return legalDOc;
    }

    @Transactional
    public void prepareChildEntities(LegalCase legalcase) {
        ArrayList<BipartisanDetails> partitionDetails = new ArrayList<BipartisanDetails>();
        List<BipartisanDetails> biparttionerList = this.legalCaseRepository.getBipartitionDetList(legalcase.getId());
        legalcase.getBipartisanDetails().addAll(biparttionerList);
        ArrayList<Pwr> pwrListtemp = new ArrayList<Pwr>();
        legalcase.getBipartisanDetails().clear();
        for (BipartisanDetails bipartObjtemp : legalcase.getBipartisanDetails()) {
            this.bipartisanDetailsRepository.delete(bipartObjtemp);
        }
        if (legalcase != null && legalcase.getId() != null) {
            for (BipartisanDetails bipartObj : legalcase.getBipartisanPetitionDetailsList()) {
                if (bipartObj.getName() == null || "".equals(bipartObj.getName())) continue;
                bipartObj.setSerialNumber(bipartObj.getSerialNumber() != null ? bipartObj.getSerialNumber() : 111L);
                bipartObj.setIsRepondent(Boolean.FALSE);
                if (bipartObj.getIsRespondentGovernment() == null) {
                    bipartObj.setIsRespondentGovernment(Boolean.FALSE);
                }
                bipartObj.setLegalCase(legalcase);
                partitionDetails.add(bipartObj);
            }
        } else {
            for (BipartisanDetails bipartObj : legalcase.getBipartisanPetitionDetailsList()) {
                if (bipartObj.getName() == null || !bipartObj.getIsRepondent().equals(Boolean.FALSE) || "".equals(bipartObj.getName())) continue;
                bipartObj.setSerialNumber(bipartObj.getSerialNumber() != null ? bipartObj.getSerialNumber() : 111L);
                bipartObj.setIsRepondent(Boolean.FALSE);
                if (bipartObj.getIsRespondentGovernment() == null) {
                    bipartObj.setIsRespondentGovernment(Boolean.FALSE);
                }
                bipartObj.setLegalCase(legalcase);
                partitionDetails.add(bipartObj);
            }
        }
        for (BipartisanDetails bipartObjtemp : legalcase.getBipartisanDetailsBeanList()) {
            if (bipartObjtemp.getId() != null && bipartObjtemp.getId() == null || bipartObjtemp.getName() == null || "".equals(bipartObjtemp.getName())) continue;
            bipartObjtemp.setSerialNumber(bipartObjtemp.getSerialNumber() != null ? bipartObjtemp.getSerialNumber() : 111L);
            bipartObjtemp.setLegalCase(legalcase);
            if (bipartObjtemp.getIsRespondentGovernment() == null) {
                bipartObjtemp.setIsRespondentGovernment(Boolean.FALSE);
            }
            bipartObjtemp.setIsRepondent(Boolean.TRUE);
            partitionDetails.add(bipartObjtemp);
        }
        legalcase.getBipartisanDetails().clear();
        legalcase.getBipartisanDetails().addAll(partitionDetails);
        if (!legalcase.getEglcPwrs().isEmpty()) {
            for (Pwr legalpwr : legalcase.getEglcPwrs()) {
                legalpwr.setLegalCase(legalcase);
                legalpwr.setCaFilingdate(new Date());
                pwrListtemp.add(legalpwr);
            }
            legalcase.getEglcPwrs().clear();
            legalcase.setEglcPwrs(pwrListtemp);
        }
    }

    @Transactional
    public LegalCase saveStandingCouncilEntity(LegalCaseAdvocate legalCaseAdvocate) {
        LegalCaseAdvocate legalCaseAdvocatetemp = null;
        AdvocateMaster seniorLegalMaster = null;
        AdvocateMaster advocateName = this.advocateMasterService.findByName(legalCaseAdvocate.getAdvocateMaster().getName());
        if (legalCaseAdvocate.getEglcSeniorAdvocateMaster().getName() != null) {
            seniorLegalMaster = this.advocateMasterService.findByName(legalCaseAdvocate.getEglcSeniorAdvocateMaster().getName());
        }
        if (!legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().isEmpty()) {
            legalCaseAdvocatetemp = legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().get(0);
            legalCaseAdvocatetemp.setAdvocateMaster(advocateName);
            legalCaseAdvocatetemp.setAssignedtodate(legalCaseAdvocate.getAssignedtodate());
            legalCaseAdvocatetemp.setVakalatdate(legalCaseAdvocate.getVakalatdate());
            legalCaseAdvocatetemp.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocatetemp.setIsActive(Boolean.TRUE);
            legalCaseAdvocatetemp.setChangeAdvocate(legalCaseAdvocate.getChangeAdvocate());
            legalCaseAdvocatetemp.setChangeSeniorAdvocate(legalCaseAdvocate.getChangeSeniorAdvocate());
            legalCaseAdvocatetemp.setEglcSeniorAdvocateMaster(seniorLegalMaster);
            legalCaseAdvocatetemp.setAssignedtodateForsenior(legalCaseAdvocate.getAssignedtodateForsenior());
            legalCaseAdvocatetemp.setOrderdate(legalCaseAdvocate.getOrderdate());
            legalCaseAdvocatetemp.setOrdernumber(legalCaseAdvocate.getOrdernumber());
            legalCaseAdvocatetemp.setOrderdateJunior(legalCaseAdvocate.getOrderdateJunior());
            legalCaseAdvocatetemp.setOrdernumberJunior(legalCaseAdvocate.getOrdernumberJunior());
            legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().add(legalCaseAdvocatetemp);
        } else {
            legalCaseAdvocate.setAdvocateMaster(advocateName);
            legalCaseAdvocate.getLegalCase().setIsSenioradvrequired(legalCaseAdvocate.getIsSeniorAdvocate());
            legalCaseAdvocate.setEglcSeniorAdvocateMaster(seniorLegalMaster);
            legalCaseAdvocate.setIsActive(Boolean.TRUE);
            legalCaseAdvocate.getLegalCase().getEglcLegalcaseAdvocates().add(legalCaseAdvocate);
        }
        return (LegalCase)((Object)this.legalCaseRepository.save((Object)legalCaseAdvocate.getLegalCase()));
    }

    @Transactional
    public void processAndStoreApplicationDocuments(LegalCase legalcase, List<LegalCaseDocuments> legalDoc) {
        if (legalcase.getId() == null) {
            if (!legalcase.getLegalCaseDocuments().isEmpty()) {
                for (LegalCaseDocuments applicationDocument : legalcase.getLegalCaseDocuments()) {
                    applicationDocument.setLegalCase(legalcase);
                    applicationDocument.setDocumentName("LegalCase");
                    applicationDocument.setSupportDocs(this.addToFileStore(applicationDocument.getFiles()));
                }
            }
        } else {
            for (LegalCaseDocuments applicationDocument : legalcase.getLegalCaseDocuments()) {
                applicationDocument.setLegalCase(legalcase);
                applicationDocument.setDocumentName("LegalCase");
                applicationDocument.getSupportDocs().addAll(this.addToFileStore(applicationDocument.getFiles()));
                legalcase.getLegalCaseDocuments().clear();
                legalcase.getLegalCaseDocuments().add(applicationDocument);
            }
            legalcase.getLegalCaseDocuments().addAll(legalDoc);
        }
    }

    @Transactional
    public void processAndStorePwrDocuments(LegalCase legalcase, List<PwrDocuments> pwrDoc) {
        if (legalcase.getId() == null) {
            if (!legalcase.getEglcPwrs().get(0).getPwrDocuments().isEmpty()) {
                for (PwrDocuments pwr : legalcase.getEglcPwrs().get(0).getPwrDocuments()) {
                    pwr.setPwr(legalcase.getEglcPwrs().get(0));
                    pwr.setDocumentName("Pwr");
                    pwr.setSupportDocs(this.addToFileStore(pwr.getFiles()));
                }
            }
        } else {
            for (PwrDocuments pwr : legalcase.getEglcPwrs().get(0).getPwrDocuments()) {
                pwr.setPwr(legalcase.getEglcPwrs().get(0));
                pwr.setDocumentName("Pwr");
                pwr.getSupportDocs().addAll(this.addToFileStore(pwr.getFiles()));
                legalcase.getEglcPwrs().get(0).getPwrDocuments().clear();
                legalcase.getEglcPwrs().get(0).getPwrDocuments().add(pwr);
            }
            legalcase.getEglcPwrs().get(0).getPwrDocuments().addAll(pwrDoc);
        }
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "LCMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }
}

