/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.lcms.transactions.entity.LcInterimOrderDocuments;
import org.egov.lcms.transactions.entity.LegalCaseInterimOrder;
import org.egov.lcms.transactions.repository.LegalCaseInterimOrderRepository;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class LegalCaseInterimOrderService {
    private final LegalCaseInterimOrderRepository legalCaseInterimOrderRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    private LegalCaseRepository legalCaseRepository;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @Autowired
    public LegalCaseInterimOrderService(LegalCaseInterimOrderRepository legalCaseInterimOrderRepository) {
        this.legalCaseInterimOrderRepository = legalCaseInterimOrderRepository;
    }

    @Transactional
    public LegalCaseInterimOrder persist(LegalCaseInterimOrder legalCaseInterimOrder) {
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "IN_PROGRESS");
        legalCaseInterimOrder.getLegalCase().setStatus(statusObj);
        this.legalCaseRepository.save((Object)legalCaseInterimOrder.getLegalCase());
        this.processAndStoreApplicationDocuments(legalCaseInterimOrder);
        return (LegalCaseInterimOrder)((Object)this.legalCaseInterimOrderRepository.save((Object)legalCaseInterimOrder));
    }

    public List<LcInterimOrderDocuments> getLcInterimOrderDocList(LegalCaseInterimOrder legalCaseInterimOrder) {
        ArrayList<LcInterimOrderDocuments> lcInterimOrderDOc = new ArrayList<LcInterimOrderDocuments>();
        for (LcInterimOrderDocuments lcInterimOrderDoc : legalCaseInterimOrder.getLcInterimOrderDocuments()) {
            lcInterimOrderDOc.add(lcInterimOrderDoc);
        }
        return lcInterimOrderDOc;
    }

    public List<LegalCaseInterimOrder> findAll() {
        return this.legalCaseInterimOrderRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }

    public LegalCaseInterimOrder findById(Long id) {
        return this.legalCaseInterimOrderRepository.findById(id);
    }

    protected void processAndStoreApplicationDocuments(LegalCaseInterimOrder legalCaseInterimOrder) {
        if (!legalCaseInterimOrder.getLcInterimOrderDocuments().isEmpty()) {
            for (LcInterimOrderDocuments applicationDocument : legalCaseInterimOrder.getLcInterimOrderDocuments()) {
                applicationDocument.setLegalCaseInterimOrder(legalCaseInterimOrder);
                applicationDocument.setDocumentName("LcInterimOrder");
                applicationDocument.setSupportDocs(this.addToFileStore(applicationDocument.getFiles()));
            }
        }
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "LCMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    public List<LegalCaseInterimOrder> findBYLcNumber(String lcNumber) {
        return this.legalCaseInterimOrderRepository.findByLegalCase_lcNumber(lcNumber);
    }
}

