/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentDocuments;
import org.egov.lcms.transactions.repository.JudgmentRepository;
import org.egov.lcms.transactions.repository.LegalCaseRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class JudgmentService {
    @Autowired
    private final JudgmentRepository judgmentRepository;
    @Autowired
    private LegalCaseRepository legalCaseRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @Autowired
    public JudgmentService(JudgmentRepository judgmentRepository) {
        this.judgmentRepository = judgmentRepository;
    }

    @Transactional
    public Judgment persist(Judgment judgment) {
        this.processAndStoreApplicationDocuments(judgment);
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "JUDGMENT");
        judgment.getLegalCase().setStatus(statusObj);
        this.legalCaseRepository.save((Object)judgment.getLegalCase());
        return (Judgment)((Object)this.judgmentRepository.save((Object)judgment));
    }

    public List<JudgmentDocuments> getJudgmentDocList(Judgment judgment) {
        ArrayList<JudgmentDocuments> judgmentDOc = new ArrayList<JudgmentDocuments>();
        for (JudgmentDocuments judgmentDoc : judgment.getJudgmentDocuments()) {
            judgmentDOc.add(judgmentDoc);
        }
        return judgmentDOc;
    }

    public List<Judgment> findAll() {
        return this.judgmentRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public Judgment findById(Long id) {
        return (Judgment)((Object)this.judgmentRepository.findOne(id));
    }

    protected void processAndStoreApplicationDocuments(Judgment judgment) {
        if (!judgment.getJudgmentDocuments().isEmpty()) {
            for (JudgmentDocuments applicationDocument : judgment.getJudgmentDocuments()) {
                applicationDocument.setJudgment(judgment);
                applicationDocument.setDocumentName("Judgment");
                applicationDocument.setSupportDocs(this.addToFileStore(applicationDocument.getFiles()));
            }
        }
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "LCMS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }
}

