/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.service;

import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.repository.HearingsRepository;
import org.egov.lcms.utils.LegalCaseUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HearingsService {
    @Autowired
    private HearingsRepository hearingsRepository;
    @Autowired
    private LegalCaseUtil legalCaseUtil;

    @Transactional
    public Hearings persist(Hearings hearings) {
        EgwStatus statusObj = this.legalCaseUtil.getStatusForModuleAndCode("Legal Case", "IN_PROGRESS");
        hearings.setStatus(statusObj);
        hearings.getLegalCase().setStatus(statusObj);
        return (Hearings)((Object)this.hearingsRepository.save((Object)hearings));
    }

    public List<Hearings> findAll() {
        return this.hearingsRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public Hearings findById(Long id) {
        return (Hearings)((Object)this.hearingsRepository.findOne(id));
    }

    public List<Hearings> findBYLcNumber(String lcNumber) {
        return this.hearingsRepository.findByLegalCase_lcNumber(lcNumber);
    }
}

