/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.PwrDocuments;

@Entity
@Table(name="EGLC_PWR")
@SequenceGenerator(name="seq_eglc_pwr", sequenceName="seq_eglc_pwr", allocationSize=1)
public class Pwr
implements Serializable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_PWR = "seq_eglc_pwr";
    @Id
    @GeneratedValue(generator="seq_eglc_pwr", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @Transient
    private String uploadPwr;
    @DateFormat(message="invalid.fieldvalue.caFilingdate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.cafiling.date")
    @Column(name="cafilingdate")
    private Date caFilingdate;
    @DateFormat(message="invalid.fieldvalue.caDueDate")
    @Column(name="caduedate")
    private Date caDueDate;
    @DateFormat(message="invalid.fieldvalue.pwrDueDate")
    @Column(name="pwrduedate")
    private Date pwrDueDate;
    @DateFormat(message="invalid.fieldvalue.pwrDueDate")
    @Column(name="pwrapprovaldate")
    private Date pwrApprovalDate;
    @OneToMany(mappedBy="pwr", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PwrDocuments> pwrDocuments = new ArrayList<PwrDocuments>(0);

    public String getUploadPwr() {
        return this.uploadPwr;
    }

    public void setUploadPwr(String uploadPwr) {
        this.uploadPwr = uploadPwr;
    }

    public Date getCaFilingdate() {
        return this.caFilingdate;
    }

    public void setCaFilingdate(Date caFilingdate) {
        this.caFilingdate = caFilingdate;
    }

    public Date getPwrApprovalDate() {
        return this.pwrApprovalDate;
    }

    public void setPwrApprovalDate(Date pwrApprovalDate) {
        this.pwrApprovalDate = pwrApprovalDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCaDueDate() {
        return this.caDueDate;
    }

    public void setCaDueDate(Date caDueDate) {
        this.caDueDate = caDueDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!DateUtils.compareDates((Date)this.getCaDueDate(), (Date)this.legalCase.getCasedate())) {
            errors.add(new ValidationError("caDueDate", "caDueDate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getCaFilingdate(), (Date)this.legalCase.getCasedate())) {
            errors.add(new ValidationError("caFilingDate", "caFilingDate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getPwrDueDate(), (Date)this.legalCase.getCasedate())) {
            errors.add(new ValidationError("pwrDueDate", "pwrDueDate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getCaDueDate(), (Date)this.getPwrDueDate())) {
            errors.add(new ValidationError("caDueDate", "caDueDate.greaterThan.pwrDueDate"));
        }
        return errors;
    }

    public Date getPwrDueDate() {
        return this.pwrDueDate;
    }

    public void setPwrDueDate(Date pwrDueDate) {
        this.pwrDueDate = pwrDueDate;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public List<PwrDocuments> getPwrDocuments() {
        return this.pwrDocuments;
    }

    public void setPwrDocuments(List<PwrDocuments> pwrDocuments) {
        this.pwrDocuments = pwrDocuments;
    }
}

