/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.Hearings;
import org.egov.lcms.transactions.entity.Judgment;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_LEGALCASEDISPOSAL")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASEDISPOSAL", sequenceName="SEQ_EGLC_LEGALCASEDISPOSAL", allocationSize=1)
public class LegalCaseDisposal
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LEGALCASEDISPOSAL = "SEQ_EGLC_LEGALCASEDISPOSAL";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASEDISPOSAL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @Valid
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @Required(message="disposalDate.null")
    @DateFormat(message="invalid.fieldvalue.model.disposalDate")
    @Column(name="disposaldate")
    private Date disposalDate;
    @Length(max=1024, message="io.disposalDetails.length")
    @Column(name="disposaldetails")
    private String disposalDetails;
    @DateFormat(message="invalid.fieldvalue.model.consignmentDate")
    @Column(name="consignmenttorecordroomdate")
    private Date consignmentDate;

    public Date getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public String getDisposalDetails() {
        return this.disposalDetails;
    }

    public void setDisposalDetails(String disposalDetails) {
        this.disposalDetails = disposalDetails;
    }

    public Date getConsignmentDate() {
        return this.consignmentDate;
    }

    public void setConsignmentDate(Date consignmentDate) {
        this.consignmentDate = consignmentDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!DateUtils.compareDates((Date)this.getDisposalDate(), (Date)this.getLegalCase().getCasedate())) {
            errors.add(new ValidationError("disposalDate", "disposalDate.greaterthan.caseDate"));
        }
        for (Hearings hearingsObj : this.legalCase.getHearings()) {
            int i = 0;
            if (!DateUtils.compareDates((Date)this.getDisposalDate(), (Date)hearingsObj.getHearingDate())) {
                errors.add(new ValidationError("disposalDate", "disposalDate.greaterthan.hearingDate"));
                ++i;
            }
            if (i <= 0) continue;
            break;
        }
        for (Judgment judgmentObj : this.getLegalCase().getJudgment()) {
            if (!DateUtils.compareDates((Date)this.getDisposalDate(), (Date)judgmentObj.getOrderDate())) {
                errors.add(new ValidationError("disposalDate", "disposalDate.greaterthan.judgementDate"));
            }
            for (JudgmentImpl judgementImpl : judgmentObj.getJudgmentImpl()) {
                if (DateUtils.compareDates((Date)this.getDisposalDate(), (Date)judgementImpl.getDateOfCompliance())) continue;
                errors.add(new ValidationError("disposalDate", "disposalDate.greaterthan.judgementImplDate"));
            }
        }
        return errors;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }
}

