/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.AdvocateMaster;
import org.egov.lcms.masters.entity.CaseStage;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_LEGALCASE_ADVOCATE")
@SequenceGenerator(name="SEQ_EGLC_LEGALCASE_ADVOCATE", sequenceName="SEQ_EGLC_LEGALCASE_ADVOCATE", allocationSize=1)
public class LegalCaseAdvocate
extends AbstractPersistable<Long> {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_LEGALCASE_ADVOCATE = "SEQ_EGLC_LEGALCASE_ADVOCATE";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_LEGALCASE_ADVOCATE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @ManyToOne
    @JoinColumn(name="advocatemaster")
    private AdvocateMaster advocateMaster;
    @DateFormat(message="invalid.fieldvalue.assignedOnDate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.assignedtodate.date")
    private Date assignedtodate;
    @DateFormat(message="invalid.fieldvalue.assignedOnForSeniorAdv")
    @Column(name="seniorassignedtodate")
    private Date assignedtodateForsenior;
    @DateFormat(message="invalid.fieldvalue.vakalaatDate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.vakalatdate.date")
    private Date vakalatdate;
    private Boolean isActive;
    @Length(max=32, message="ordernumber.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/(){}\\[\\]]+", message="orderNumber.format")
    private String ordernumber;
    @DateFormat(message="invalid.fieldvalue.orderDate")
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.orderdate.date")
    private Date orderdate;
    @ManyToOne
    @JoinColumn(name="senioradvocate")
    private AdvocateMaster eglcSeniorAdvocateMaster;
    @Length(max=32, message="ordernumberJunior.length")
    @JoinColumn(name="ordernumberjunior")
    private String ordernumberJunior;
    @DateFormat(message="invalid.fieldvalue.juniororderDate")
    @Column(name="orderdatejunior")
    private Date orderdateJunior;
    @ManyToOne
    @JoinColumn(name="JUNIORSTAGE")
    private CaseStage juniorStage;
    @ManyToOne
    @JoinColumn(name="SENIORSTAGE")
    private CaseStage seniorStage;
    @Length(max=256, message="reassignmentJunior.length")
    private String reassignmentreasonjunior;
    @Length(max=256, message="reassignmentSenior.length")
    private String reassignmentreasonsenior;
    private Boolean changeAdvocate = Boolean.FALSE;
    private Boolean changeSeniorAdvocate = Boolean.FALSE;
    @Transient
    private Boolean isSeniorAdvocate = Boolean.FALSE;

    public Boolean getChangeAdvocate() {
        return this.changeAdvocate;
    }

    public void setChangeAdvocate(Boolean changeAdvocate) {
        this.changeAdvocate = changeAdvocate;
    }

    public Boolean getChangeSeniorAdvocate() {
        return this.changeSeniorAdvocate;
    }

    public void setChangeSeniorAdvocate(Boolean changeSeniorAdvocate) {
        this.changeSeniorAdvocate = changeSeniorAdvocate;
    }

    public AdvocateMaster getAdvocateMaster() {
        return this.advocateMaster;
    }

    public void setAdvocateMaster(AdvocateMaster advocateMaster) {
        this.advocateMaster = advocateMaster;
    }

    public Date getAssignedtodate() {
        return this.assignedtodate;
    }

    public void setAssignedtodate(Date assignedtodate) {
        this.assignedtodate = assignedtodate;
    }

    public Date getVakalatdate() {
        return this.vakalatdate;
    }

    public void setVakalatdate(Date vakalatdate) {
        this.vakalatdate = vakalatdate;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public String getOrdernumber() {
        return this.ordernumber;
    }

    public void setOrdernumber(String ordernumber) {
        this.ordernumber = ordernumber;
    }

    public Date getOrderdate() {
        return this.orderdate;
    }

    public void setOrderdate(Date orderdate) {
        this.orderdate = orderdate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.legalCase.getIsSenioradvrequired().booleanValue()) {
            if (this.getEglcSeniorAdvocateMaster() == null) {
                errors.add(new ValidationError("eglcSeniorAdvocateMaster", "legalcase.eglcSeniorAdvocateMaster.null"));
            }
            if (StringUtils.isBlank((String)this.getOrdernumber())) {
                errors.add(new ValidationError("ordernumber", "legalcase.ordernumber.null"));
            }
            if (this.getOrderdate() == null) {
                errors.add(new ValidationError("orderDate", "legalcase.orderdate.null"));
            }
            if (!DateUtils.compareDates((Date)this.getOrderdate(), (Date)this.legalCase.getCaseReceivingDate())) {
                errors.add(new ValidationError("orderDate", "orderdate.less.casereceivingdate"));
            }
            if (!DateUtils.compareDates((Date)this.getOrderdate(), (Date)this.legalCase.getCasedate())) {
                errors.add(new ValidationError("orderDate", "orderdate.less.casedate"));
            }
            if (!DateUtils.compareDates((Date)this.getAssignedtodateForsenior(), (Date)this.getOrderdate())) {
                errors.add(new ValidationError("assignedtodatesenior", "assignedon.less.orderdate"));
            }
        }
        if (!DateUtils.compareDates((Date)this.getAssignedtodate(), (Date)this.legalCase.getCaseReceivingDate())) {
            errors.add(new ValidationError("assignedon", "assignedon.less.casereceivingdate"));
        }
        if (!DateUtils.compareDates((Date)this.getAssignedtodate(), (Date)this.legalCase.getCasedate())) {
            errors.add(new ValidationError("assignedon", "assignedon.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getVakalatdate(), (Date)this.legalCase.getCasedate())) {
            errors.add(new ValidationError("vakalatdate", "vakalatdate.less.casedate"));
        }
        if (!DateUtils.compareDates((Date)this.getVakalatdate(), (Date)this.legalCase.getCaseReceivingDate())) {
            errors.add(new ValidationError("vakalatdate", "vakalatdate.less.caserecdate"));
        }
        if (!DateUtils.compareDates((Date)this.getVakalatdate(), (Date)this.getAssignedtodate())) {
            errors.add(new ValidationError("vakalatdate", "vakalatdate.less.assingedon"));
        }
        return errors;
    }

    public AdvocateMaster getEglcSeniorAdvocateMaster() {
        return this.eglcSeniorAdvocateMaster;
    }

    public void setEglcSeniorAdvocateMaster(AdvocateMaster eglcSeniorAdvocateMaster) {
        this.eglcSeniorAdvocateMaster = eglcSeniorAdvocateMaster;
    }

    public Date getAssignedtodateForsenior() {
        return this.assignedtodateForsenior;
    }

    public void setAssignedtodateForsenior(Date assignedtodateForsenior) {
        this.assignedtodateForsenior = assignedtodateForsenior;
    }

    public String getOrdernumberJunior() {
        return this.ordernumberJunior;
    }

    public void setOrdernumberJunior(String ordernumberJunior) {
        this.ordernumberJunior = ordernumberJunior;
    }

    public Date getOrderdateJunior() {
        return this.orderdateJunior;
    }

    public void setOrderdateJunior(Date orderdateJunior) {
        this.orderdateJunior = orderdateJunior;
    }

    public CaseStage getJuniorStage() {
        return this.juniorStage;
    }

    public void setJuniorStage(CaseStage juniorStage) {
        this.juniorStage = juniorStage;
    }

    public CaseStage getSeniorStage() {
        return this.seniorStage;
    }

    public void setSeniorStage(CaseStage seniorStage) {
        this.seniorStage = seniorStage;
    }

    public String getReassignmentreasonjunior() {
        return this.reassignmentreasonjunior;
    }

    public void setReassignmentreasonjunior(String reassignmentreasonjunior) {
        this.reassignmentreasonjunior = reassignmentreasonjunior;
    }

    public String getReassignmentreasonsenior() {
        return this.reassignmentreasonsenior;
    }

    public void setReassignmentreasonsenior(String reassignmentreasonsenior) {
        this.reassignmentreasonsenior = reassignmentreasonsenior;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public Boolean getIsSeniorAdvocate() {
        return this.isSeniorAdvocate;
    }

    public void setIsSeniorAdvocate(Boolean isSeniorAdvocate) {
        this.isSeniorAdvocate = isSeniorAdvocate;
    }
}

