/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.EmployeeHearing;
import org.egov.lcms.transactions.entity.LegalCase;
import org.egov.lcms.transactions.entity.Pwr;
import org.egov.pims.commons.Position;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_HEARINGS")
@SequenceGenerator(name="SEQ_EGLC_HEARINGS", sequenceName="SEQ_EGLC_HEARINGS", allocationSize=1)
public class Hearings
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_HEARINGS = "SEQ_EGLC_HEARINGS";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_HEARINGS", strategy=GenerationType.SEQUENCE)
    private Long id;
    private Date hearingDate;
    @ManyToOne
    @Valid
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @Column(name="isstandingcounselpresent")
    private boolean isStandingCounselPresent;
    @Length(max=128, message="hearing.additionalLawyer.length")
    @OptionalPattern(regex="^[a-z|A-Z|]+[a-z|A-Z|&/ :,-.]*", message="hearing.additionalLawyerName.text")
    private String additionalLawyers;
    @OneToMany(mappedBy="hearing", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    List<EmployeeHearing> employeeHearingList = new ArrayList<EmployeeHearing>();
    @Transient
    List<Position> positionTemplList = new ArrayList<Position>(0);
    @Length(max=1024, message="hearing.outcome.length")
    private String hearingOutcome;
    private boolean isSeniorStandingCounselPresent;
    @Length(max=2056, message="hearing.purpose.length")
    @Column(name="purposeofhearing")
    private String purposeofHearings;
    @ManyToOne
    @Valid
    @JoinColumn(name="STATUS", nullable=false)
    private EgwStatus status;
    @Length(max=50, message="ti.referencenumber.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/() .]+", message="ti.referencenumber.alphanumeric")
    private String referenceNumber;

    public Date getHearingDate() {
        return this.hearingDate;
    }

    public void setHearingDate(Date hearingDate) {
        this.hearingDate = hearingDate;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public String getAdditionalLawyers() {
        return this.additionalLawyers;
    }

    public void setAdditionalLawyers(String additionalLawyers) {
        this.additionalLawyers = additionalLawyers;
    }

    public String getHearingOutcome() {
        return this.hearingOutcome;
    }

    public void setHearingOutcome(String hearingOutcome) {
        this.hearingOutcome = hearingOutcome;
    }

    public boolean getIsSeniorStandingcounselpresent() {
        return this.isSeniorStandingCounselPresent;
    }

    public void setIsSeniorStandingcounselpresent(boolean isSeniorStandingcounselpresent) {
        this.isSeniorStandingCounselPresent = isSeniorStandingcounselpresent;
    }

    public String getPurposeofHearings() {
        return this.purposeofHearings;
    }

    public void setPurposeofHearings(String purposeofHearings) {
        this.purposeofHearings = purposeofHearings;
    }

    public Date getCaDueDate() {
        Date caDueDate = null;
        for (Pwr pwr : this.getLegalCase().getEglcPwrs()) {
            caDueDate = pwr.getCaDueDate();
        }
        return caDueDate;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getHearingDate() != null) {
            if (this.getCaDueDate() != null && !DateUtils.compareDates((Date)this.getHearingDate(), (Date)this.getCaDueDate())) {
                errors.add(new ValidationError("hearingDate", "hearingDate.greaterThan.caDueDate"));
            }
            if (this.legalCase.getCaseReceivingDate() != null && !DateUtils.compareDates((Date)this.getHearingDate(), (Date)this.legalCase.getCaseReceivingDate())) {
                errors.add(new ValidationError("hearingDate", "hearingDate.greaterThan.caseReceivingDate"));
            }
            if (!DateUtils.compareDates((Date)this.getHearingDate(), (Date)this.legalCase.getCasedate())) {
                errors.add(new ValidationError("hearingDate", "hearingDate.greaterThan.caseDate"));
            }
        }
        return errors;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus egwStatus) {
        this.status = egwStatus;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean getIsStandingCounselPresent() {
        return this.isStandingCounselPresent;
    }

    public void setIsStandingCounselPresent(boolean isStandingCounselPresent) {
        this.isStandingCounselPresent = isStandingCounselPresent;
    }

    public void setSeniorStandingCounselPresent(boolean isSeniorStandingCounselPresent) {
        this.isSeniorStandingCounselPresent = isSeniorStandingCounselPresent;
    }

    public void setStandingCounselPresent(boolean isStandingCounselPresent) {
        this.isStandingCounselPresent = isStandingCounselPresent;
    }

    public List<EmployeeHearing> getEmployeeHearingList() {
        return this.employeeHearingList;
    }

    public void setEmployeeHearingList(List<EmployeeHearing> employeeHearingList) {
        this.employeeHearingList = employeeHearingList;
    }

    public List<Position> getPositionTemplList() {
        return this.positionTemplList;
    }

    public void setPositionTemplList(List<Position> positionTemplList) {
        this.positionTemplList = positionTemplList;
    }
}

