/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.masters.entity.GovernmentDepartment;
import org.egov.lcms.transactions.entity.LegalCase;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_BIPARTISANDETAILS")
@SequenceGenerator(name="SEQ_EGLC_BIPARTISANDETAILS", sequenceName="SEQ_EGLC_BIPARTISANDETAILS", allocationSize=1)
public class BipartisanDetails
implements Serializable {
    private static final long serialVersionUID = 845357231248646624L;
    public static final String SEQ_EGLC_BIPARTISANDETAILS = "SEQ_EGLC_BIPARTISANDETAILS";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_BIPARTISANDETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="legalcase", nullable=false)
    private LegalCase legalCase;
    @Length(max=128, message="petitionerName.length")
    @OptionalPattern(regex="^[a-z|A-Z|]+[a-z|A-Z|0-9|&/() .]*", message="petitionerName.name.mixedChar")
    private String name;
    @Length(max=256, message="address.length")
    private String address;
    @OptionalPattern(regex="[0-9-,()OR]+", message="contactNumber.numeric")
    private Long contactNumber;
    @Column(name="isrespondent")
    private Boolean isRepondent = false;
    @ManyToOne
    @Valid
    @JoinColumn(name="respondentgovtdept")
    private GovernmentDepartment governmentDepartment;
    @Column(name="isrespondentgovernment", nullable=false)
    private Boolean isRespondentGovernment = false;
    @Column(name="serialnumber")
    private Long serialNumber;

    public GovernmentDepartment getGovernmentDepartment() {
        return this.governmentDepartment;
    }

    public void setGovernmentDepartment(GovernmentDepartment governmentDepartment) {
        this.governmentDepartment = governmentDepartment;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(Long contactNumber) {
        this.contactNumber = contactNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getIsRespondentGovernment().booleanValue() && this.getGovernmentDepartment() == null) {
            if (this.getIsRepondent().booleanValue()) {
                errors.add(new ValidationError("govtDept", "respondent.govtDept.select"));
            } else {
                errors.add(new ValidationError("govtDept", "petitioner.govtDept.select"));
            }
        }
        if (!this.getIsRespondentGovernment().booleanValue()) {
            if (this.getIsRepondent().booleanValue() && StringUtils.isBlank((String)this.getName())) {
                errors.add(new ValidationError("respondent", "respondentName.null"));
            }
            if (!this.getIsRepondent().booleanValue() && StringUtils.isBlank((String)this.getName())) {
                errors.add(new ValidationError("petitioner", "petitionerName.null"));
            }
        }
        return errors;
    }

    public Long getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public LegalCase getLegalCase() {
        return this.legalCase;
    }

    public void setLegalCase(LegalCase legalCase) {
        this.legalCase = legalCase;
    }

    public Boolean getIsRepondent() {
        return this.isRepondent;
    }

    public void setIsRepondent(Boolean isRepondent) {
        this.isRepondent = isRepondent;
    }

    public Boolean getIsRespondentGovernment() {
        return this.isRespondentGovernment;
    }

    public void setIsRespondentGovernment(Boolean isRespondentGovernment) {
        this.isRespondentGovernment = isRespondentGovernment;
    }
}

