/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.transactions.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.ValidateDate;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.lcms.transactions.entity.AppealDocuments;
import org.egov.lcms.transactions.entity.JudgmentImpl;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGLC_APPEAL")
@SequenceGenerator(name="SEQ_EGLC_APPEAL", sequenceName="SEQ_EGLC_APPEAL", allocationSize=1)
public class Appeal
extends AbstractAuditable {
    private static final long serialVersionUID = 1517694643078084884L;
    public static final String SEQ_EGLC_APPEAL = "SEQ_EGLC_APPEAL";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_APPEAL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="JUDGMENTIMPL")
    private JudgmentImpl judgmentImpl;
    @NotNull
    @Length(max=50)
    private String srNumber;
    @NotNull
    @ValidateDate(allowPast=true, dateFormat="dd/MM/yyyy", message="invalid.appeal.date")
    @Temporal(value=TemporalType.DATE)
    private Date appealFiledOn;
    @NotNull
    @Length(max=100)
    private String appealFiledBy;
    @OneToMany(mappedBy="appeal", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AppealDocuments> appealDocuments = new ArrayList<AppealDocuments>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSrNumber() {
        return this.srNumber;
    }

    public void setSrNumber(String srNumber) {
        this.srNumber = srNumber;
    }

    public Date getAppealFiledOn() {
        return this.appealFiledOn;
    }

    public void setAppealFiledOn(Date appealFiledOn) {
        this.appealFiledOn = appealFiledOn;
    }

    public String getAppealFiledBy() {
        return this.appealFiledBy;
    }

    public void setAppealFiledBy(String appealFiledBy) {
        this.appealFiledBy = appealFiledBy;
    }

    public JudgmentImpl getJudgmentImpl() {
        return this.judgmentImpl;
    }

    public void setJudgmentImpl(JudgmentImpl judgmentImpl) {
        this.judgmentImpl = judgmentImpl;
    }

    public List<AppealDocuments> getAppealDocuments() {
        return this.appealDocuments;
    }

    public void setAppealDocuments(List<AppealDocuments> appealDocuments) {
        this.appealDocuments = appealDocuments;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getAppealFiledOn() != null && !DateUtils.compareDates((Date)this.getAppealFiledOn(), (Date)this.getJudgmentImpl().getJudgment().getOrderDate())) {
            errors.add(new ValidationError("appealfiledon", "appealfiledon.less.orderDate"));
        }
        return errors;
    }
}

